/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.registry;

import java.util.Iterator;
import net.shadowmage.ancientwarfare.vehicle.entity.IVehicleType;
import net.shadowmage.ancientwarfare.vehicle.entity.types.VehicleType;
import net.shadowmage.ancientwarfare.vehicle.entity.types.VehicleTypeBallistaMobile;
import net.shadowmage.ancientwarfare.vehicle.entity.types.VehicleTypeBallistaMobileTurret;
import net.shadowmage.ancientwarfare.vehicle.entity.types.VehicleTypeBallistaStand;
import net.shadowmage.ancientwarfare.vehicle.entity.types.VehicleTypeBallistaStandTurret;
import net.shadowmage.ancientwarfare.vehicle.entity.types.VehicleTypeBatteringRam;
import net.shadowmage.ancientwarfare.vehicle.entity.types.VehicleTypeBoatBallista;
import net.shadowmage.ancientwarfare.vehicle.entity.types.VehicleTypeBoatCatapult;
import net.shadowmage.ancientwarfare.vehicle.entity.types.VehicleTypeBoatTransport;
import net.shadowmage.ancientwarfare.vehicle.entity.types.VehicleTypeCannonMobileFixed;
import net.shadowmage.ancientwarfare.vehicle.entity.types.VehicleTypeCannonStandFixed;
import net.shadowmage.ancientwarfare.vehicle.entity.types.VehicleTypeCannonStandTurret;
import net.shadowmage.ancientwarfare.vehicle.entity.types.VehicleTypeCatapultMobileFixed;
import net.shadowmage.ancientwarfare.vehicle.entity.types.VehicleTypeCatapultMobileTurret;
import net.shadowmage.ancientwarfare.vehicle.entity.types.VehicleTypeCatapultStandFixed;
import net.shadowmage.ancientwarfare.vehicle.entity.types.VehicleTypeCatapultStandTurret;
import net.shadowmage.ancientwarfare.vehicle.entity.types.VehicleTypeChestCart;
import net.shadowmage.ancientwarfare.vehicle.entity.types.VehicleTypeHwacha;
import net.shadowmage.ancientwarfare.vehicle.entity.types.VehicleTypeTrebuchetLarge;
import net.shadowmage.ancientwarfare.vehicle.entity.types.VehicleTypeTrebuchetMobileFixed;
import net.shadowmage.ancientwarfare.vehicle.entity.types.VehicleTypeTrebuchetStandFixed;
import net.shadowmage.ancientwarfare.vehicle.entity.types.VehicleTypeTrebuchetStandTurret;
import net.shadowmage.ancientwarfare.vehicle.missiles.IAmmo;

public class VehicleRegistry {
    public static final IVehicleType CATAPULT_STAND_FIXED = new VehicleTypeCatapultStandFixed(0);
    public static final IVehicleType CATAPULT_STAND_TURRET = new VehicleTypeCatapultStandTurret(1);
    public static final IVehicleType CATAPULT_MOBILE_FIXED = new VehicleTypeCatapultMobileFixed(2);
    public static final IVehicleType CATAPULT_MOBILE_TURRET = new VehicleTypeCatapultMobileTurret(3);
    public static final IVehicleType BALLISTA_STAND_FIXED = new VehicleTypeBallistaStand(4);
    public static final IVehicleType BALLISTA_STAND_TURRET = new VehicleTypeBallistaStandTurret(5);
    public static final IVehicleType BALLISTA_MOBILE_FIXED = new VehicleTypeBallistaMobile(6);
    public static final IVehicleType BALLISTA_MOBILE_TURRET = new VehicleTypeBallistaMobileTurret(7);
    public static final IVehicleType BATTERING_RAM = new VehicleTypeBatteringRam(8);
    public static final IVehicleType CANNON_STAND_FIXED = new VehicleTypeCannonStandFixed(9);
    public static final IVehicleType CANNON_STAND_TURRET = new VehicleTypeCannonStandTurret(10);
    public static final IVehicleType CANNON_MOBILE_FIXED = new VehicleTypeCannonMobileFixed(11);
    public static final IVehicleType HWACHA = new VehicleTypeHwacha(12);
    public static final IVehicleType TREBUCHET_STAND_FIXED = new VehicleTypeTrebuchetStandFixed(13);
    public static final IVehicleType TREBUCHET_STAND_TURRET = new VehicleTypeTrebuchetStandTurret(14);
    public static final IVehicleType TREBUCHET_MOBILE_FIXED = new VehicleTypeTrebuchetMobileFixed(15);
    public static final IVehicleType TREBUCHET_LARGE = new VehicleTypeTrebuchetLarge(16);
    public static final IVehicleType CHEST_CART = new VehicleTypeChestCart(17);
    public static final IVehicleType BOAT_BALLISTA = new VehicleTypeBoatBallista(18);
    public static final IVehicleType BOAT_CATAPULT = new VehicleTypeBoatCatapult(19);
    public static final IVehicleType BOAT_TRANSPORT = new VehicleTypeBoatTransport(20);

    private VehicleRegistry() {
    }

    public static void registerVehicles() {
        for (IVehicleType vehicle : VehicleType.vehicleTypes) {
            if (vehicle == null) continue;
            vehicle.setEnabled(vehicle.isEnabled());
            if (!vehicle.isEnabled()) {
                VehicleType.vehicleTypes[vehicle.getGlobalVehicleType()] = null;
                continue;
            }
            vehicle.setEnabledForLoot(true);
            vehicle.setBaseAccuracy(vehicle.getBaseAccuracy());
            vehicle.setBaseForwardSpeed(vehicle.getBaseForwardSpeed());
            vehicle.setBaseHealth(vehicle.getBaseHealth());
            vehicle.setBaseMissileVelocity(vehicle.getBaseMissileVelocityMax());
            vehicle.setBasePitchMax(vehicle.getBasePitchMax());
            vehicle.setBasePitchMin(vehicle.getBasePitchMin());
            vehicle.setBaseStrafeSpeed(vehicle.getBaseStrafeSpeed());
            vehicle.setBaseTurretRotationAmount(vehicle.getBaseTurretRotationAmount());
            Iterator<IAmmo> it = vehicle.getValidAmmoTypes().iterator();
            while (it.hasNext()) {
                IAmmo t = it.next();
                if (t.isEnabled()) continue;
                it.remove();
            }
        }
    }
}

