/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.shadowmage.ancientwarfare.vehicle.config.AWVehicleStatics;
import net.shadowmage.ancientwarfare.vehicle.item.ItemAmmo;
import net.shadowmage.ancientwarfare.vehicle.missiles.AmmoArrow;
import net.shadowmage.ancientwarfare.vehicle.missiles.AmmoBallShot;
import net.shadowmage.ancientwarfare.vehicle.missiles.AmmoBallistaBolt;
import net.shadowmage.ancientwarfare.vehicle.missiles.AmmoBallistaBoltExplosive;
import net.shadowmage.ancientwarfare.vehicle.missiles.AmmoBallistaBoltFlame;
import net.shadowmage.ancientwarfare.vehicle.missiles.AmmoBallistaBoltIron;
import net.shadowmage.ancientwarfare.vehicle.missiles.AmmoCanisterShot;
import net.shadowmage.ancientwarfare.vehicle.missiles.AmmoClusterShot;
import net.shadowmage.ancientwarfare.vehicle.missiles.AmmoExplosiveShot;
import net.shadowmage.ancientwarfare.vehicle.missiles.AmmoFlameShot;
import net.shadowmage.ancientwarfare.vehicle.missiles.AmmoGrapeShot;
import net.shadowmage.ancientwarfare.vehicle.missiles.AmmoHwachaRocket;
import net.shadowmage.ancientwarfare.vehicle.missiles.AmmoHwachaRocketAirburst;
import net.shadowmage.ancientwarfare.vehicle.missiles.AmmoHwachaRocketExplosive;
import net.shadowmage.ancientwarfare.vehicle.missiles.AmmoHwachaRocketFlame;
import net.shadowmage.ancientwarfare.vehicle.missiles.AmmoIronBallShot;
import net.shadowmage.ancientwarfare.vehicle.missiles.AmmoIronShot;
import net.shadowmage.ancientwarfare.vehicle.missiles.AmmoNapalmShot;
import net.shadowmage.ancientwarfare.vehicle.missiles.AmmoPebbleShot;
import net.shadowmage.ancientwarfare.vehicle.missiles.AmmoStoneShot;
import net.shadowmage.ancientwarfare.vehicle.missiles.IAmmo;

public class AmmoRegistry {
    public static IAmmo ammoBallShot;
    public static IAmmo ammoBallIronShot;
    public static IAmmo ammoStoneShot10;
    public static IAmmo ammoStoneShot15;
    public static IAmmo ammoStoneShot30;
    public static IAmmo ammoStoneShot45;
    public static IAmmo ammoFireShot10;
    public static IAmmo ammoFireShot15;
    public static IAmmo ammoFireShot30;
    public static IAmmo ammoFireShot45;
    public static IAmmo ammoExplosive10;
    public static IAmmo ammoExplosive15;
    public static IAmmo ammoExplosive30;
    public static IAmmo ammoExplosive45;
    public static IAmmo ammoHE10;
    public static IAmmo ammoHE15;
    public static IAmmo ammoHE30;
    public static IAmmo ammoHE45;
    public static IAmmo ammoNapalm10;
    public static IAmmo ammoNapalm15;
    public static IAmmo ammoNapalm30;
    public static IAmmo ammoNapalm45;
    public static IAmmo ammoClusterShot10;
    public static IAmmo ammoClusterShot15;
    public static IAmmo ammoClusterShot30;
    public static IAmmo ammoClusterShot45;
    public static IAmmo ammoPebbleShot10;
    public static IAmmo ammoPebbleShot15;
    public static IAmmo ammoPebbleShot30;
    public static IAmmo ammoPebbleShot45;
    public static IAmmo ammoIronShot5;
    public static IAmmo ammoIronShot10;
    public static IAmmo ammoIronShot15;
    public static IAmmo ammoIronShot25;
    public static IAmmo ammoCanisterShot5;
    public static IAmmo ammoCanisterShot10;
    public static IAmmo ammoCanisterShot15;
    public static IAmmo ammoCanisterShot25;
    public static IAmmo ammoGrapeShot5;
    public static IAmmo ammoGrapeShot10;
    public static IAmmo ammoGrapeShot15;
    public static IAmmo ammoGrapeShot25;
    public static IAmmo ammoArrow;
    public static IAmmo ammoBallistaBolt;
    public static IAmmo ammoBallistaBoltFlame;
    public static IAmmo ammoBallistaBoltExplosive;
    public static IAmmo ammoBallistaBoltIron;
    public static IAmmo ammoRocket;
    public static IAmmo ammoHwachaRocketFlame;
    public static IAmmo ammoHwachaRocketExplosive;
    public static IAmmo ammoHwachaRocketAirburst;
    private static Map<ResourceLocation, IAmmo> ammoInstances;
    private static Map<ResourceLocation, ItemAmmo> ammoItemInstances;

    private AmmoRegistry() {
    }

    public static void registerAmmo(IForgeRegistry<Item> registry) {
        ammoBallShot = AmmoRegistry.registerAmmoType(new AmmoBallShot(), registry);
        ammoBallIronShot = AmmoRegistry.registerAmmoType(new AmmoIronBallShot(), registry);
        ammoStoneShot10 = AmmoRegistry.registerAmmoType(new AmmoStoneShot(10), registry);
        ammoStoneShot15 = AmmoRegistry.registerAmmoType(new AmmoStoneShot(15), registry);
        ammoStoneShot30 = AmmoRegistry.registerAmmoType(new AmmoStoneShot(30), registry);
        ammoStoneShot45 = AmmoRegistry.registerAmmoType(new AmmoStoneShot(45), registry);
        ammoFireShot10 = AmmoRegistry.registerAmmoType(new AmmoFlameShot(10), registry);
        ammoFireShot15 = AmmoRegistry.registerAmmoType(new AmmoFlameShot(15), registry);
        ammoFireShot30 = AmmoRegistry.registerAmmoType(new AmmoFlameShot(30), registry);
        ammoFireShot45 = AmmoRegistry.registerAmmoType(new AmmoFlameShot(45), registry);
        ammoExplosive10 = AmmoRegistry.registerAmmoType(new AmmoExplosiveShot(10, false), registry);
        ammoExplosive15 = AmmoRegistry.registerAmmoType(new AmmoExplosiveShot(15, false), registry);
        ammoExplosive30 = AmmoRegistry.registerAmmoType(new AmmoExplosiveShot(30, false), registry);
        ammoExplosive45 = AmmoRegistry.registerAmmoType(new AmmoExplosiveShot(45, false), registry);
        ammoHE10 = AmmoRegistry.registerAmmoType(new AmmoExplosiveShot(10, true), registry);
        ammoHE15 = AmmoRegistry.registerAmmoType(new AmmoExplosiveShot(15, true), registry);
        ammoHE30 = AmmoRegistry.registerAmmoType(new AmmoExplosiveShot(30, true), registry);
        ammoHE45 = AmmoRegistry.registerAmmoType(new AmmoExplosiveShot(45, true), registry);
        ammoNapalm10 = AmmoRegistry.registerAmmoType(new AmmoNapalmShot(10), registry);
        ammoNapalm15 = AmmoRegistry.registerAmmoType(new AmmoNapalmShot(15), registry);
        ammoNapalm30 = AmmoRegistry.registerAmmoType(new AmmoNapalmShot(30), registry);
        ammoNapalm45 = AmmoRegistry.registerAmmoType(new AmmoNapalmShot(45), registry);
        ammoClusterShot10 = AmmoRegistry.registerAmmoType(new AmmoClusterShot(10), registry);
        ammoClusterShot15 = AmmoRegistry.registerAmmoType(new AmmoClusterShot(15), registry);
        ammoClusterShot30 = AmmoRegistry.registerAmmoType(new AmmoClusterShot(30), registry);
        ammoClusterShot45 = AmmoRegistry.registerAmmoType(new AmmoClusterShot(45), registry);
        ammoPebbleShot10 = AmmoRegistry.registerAmmoType(new AmmoPebbleShot(10), registry);
        ammoPebbleShot15 = AmmoRegistry.registerAmmoType(new AmmoPebbleShot(15), registry);
        ammoPebbleShot30 = AmmoRegistry.registerAmmoType(new AmmoPebbleShot(30), registry);
        ammoPebbleShot45 = AmmoRegistry.registerAmmoType(new AmmoPebbleShot(45), registry);
        ammoIronShot5 = AmmoRegistry.registerAmmoType(new AmmoIronShot(5, AWVehicleStatics.vehicleStats.ammoCannonBall5kgDamage), registry);
        ammoIronShot10 = AmmoRegistry.registerAmmoType(new AmmoIronShot(10, AWVehicleStatics.vehicleStats.ammoCannonBall10kgDamage), registry);
        ammoIronShot15 = AmmoRegistry.registerAmmoType(new AmmoIronShot(15, AWVehicleStatics.vehicleStats.ammoCannonBall15kgDamage), registry);
        ammoIronShot25 = AmmoRegistry.registerAmmoType(new AmmoIronShot(25, AWVehicleStatics.vehicleStats.ammoCannonBall25kgDamage), registry);
        ammoCanisterShot5 = AmmoRegistry.registerAmmoType(new AmmoCanisterShot(5), registry);
        ammoCanisterShot10 = AmmoRegistry.registerAmmoType(new AmmoCanisterShot(10), registry);
        ammoCanisterShot15 = AmmoRegistry.registerAmmoType(new AmmoCanisterShot(15), registry);
        ammoCanisterShot25 = AmmoRegistry.registerAmmoType(new AmmoCanisterShot(25), registry);
        ammoGrapeShot5 = AmmoRegistry.registerAmmoType(new AmmoGrapeShot(5), registry);
        ammoGrapeShot10 = AmmoRegistry.registerAmmoType(new AmmoGrapeShot(10), registry);
        ammoGrapeShot15 = AmmoRegistry.registerAmmoType(new AmmoGrapeShot(15), registry);
        ammoGrapeShot25 = AmmoRegistry.registerAmmoType(new AmmoGrapeShot(25), registry);
        ammoArrow = AmmoRegistry.registerAmmoType(new AmmoArrow(), registry);
        ammoBallistaBolt = AmmoRegistry.registerAmmoType(new AmmoBallistaBolt(), registry);
        ammoBallistaBoltFlame = AmmoRegistry.registerAmmoType(new AmmoBallistaBoltFlame(), registry);
        ammoBallistaBoltExplosive = AmmoRegistry.registerAmmoType(new AmmoBallistaBoltExplosive(), registry);
        ammoBallistaBoltIron = AmmoRegistry.registerAmmoType(new AmmoBallistaBoltIron(), registry);
        ammoRocket = AmmoRegistry.registerAmmoType(new AmmoHwachaRocket(), registry);
        ammoHwachaRocketFlame = AmmoRegistry.registerAmmoType(new AmmoHwachaRocketFlame(), registry);
        ammoHwachaRocketExplosive = AmmoRegistry.registerAmmoType(new AmmoHwachaRocketExplosive(), registry);
        ammoHwachaRocketAirburst = AmmoRegistry.registerAmmoType(new AmmoHwachaRocketAirburst(), registry);
    }

    private static IAmmo registerAmmoType(IAmmo ammo, IForgeRegistry<Item> registry) {
        ammoInstances.put(ammo.getRegistryName(), ammo);
        ItemAmmo item = new ItemAmmo(ammo.getRegistryName(), ammo);
        ammoItemInstances.put(ammo.getRegistryName(), item);
        registry.register((IForgeRegistryEntry)item);
        return ammo;
    }

    public static Optional<IAmmo> getAmmoForStack(ItemStack stack) {
        return Optional.ofNullable(ammoInstances.get(stack.func_77973_b().getRegistryName()));
    }

    public static IAmmo getAmmo(ResourceLocation registryName) {
        return ammoInstances.get(registryName);
    }

    public static ItemAmmo getItemForAmmo(IAmmo ammo) {
        return ammoItemInstances.get(ammo.getRegistryName());
    }

    public static ItemAmmo getItem(ResourceLocation ammoRegistryName) {
        return ammoItemInstances.get(ammoRegistryName);
    }

    static {
        ammoInstances = new HashMap<ResourceLocation, IAmmo>();
        ammoItemInstances = new HashMap<ResourceLocation, ItemAmmo>();
    }
}

