/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.pathing;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.shadowmage.ancientwarfare.vehicle.pathing.Node;
import net.shadowmage.ancientwarfare.vehicle.pathing.PathUtils;
import net.shadowmage.ancientwarfare.vehicle.pathing.PathWorldAccess;

public class PathFinderCrawler {
    private ArrayList<CrawlNode> allNodes = new ArrayList();
    private CrawlNode currentNode;
    LinkedList<Node> path = new LinkedList();
    int sx;
    int sy;
    int sz;
    int tx;
    int ty;
    int tz;
    int maxRange;
    PathWorldAccess world;
    int cx;
    int cy;
    int cz;
    int dx;
    int dy;
    int dz;
    int pdx;
    int pdy;
    int pdz;
    int pcx;
    int pcy;
    int pcz;
    int gx;
    int gy;
    int gz;
    int xDiff;
    int yDiff;
    int zDiff;
    boolean followingWall = false;
    int turnDir = 1;

    public List<Node> findPath(PathWorldAccess world, int x, int y, int z, BlockPos target, int maxRange) {
        long t1 = System.nanoTime();
        this.world = world;
        this.sx = this.cx = x;
        this.sy = this.cy = y;
        this.sz = this.cz = z;
        this.tx = target.func_177958_n();
        this.ty = target.func_177956_o();
        this.tz = target.func_177952_p();
        this.maxRange = maxRange;
        this.currentNode = this.getOrMakeNode(this.sx, this.sy, this.sz, null);
        this.path.clear();
        this.searchLoop();
        LinkedList<Node> foundPath = new LinkedList<Node>();
        Node p = null;
        Node n = null;
        boolean skip = false;
        for (int i = 0; i < this.path.size(); ++i) {
            n = this.path.get(i);
            for (int k = this.path.size() - 1; k > i; --k) {
                p = this.path.get(k);
                if (!PathUtils.canPathStraightToTarget(world, n.x, n.y, n.z, new BlockPos(p.x, p.y, p.z))) continue;
                i = k - 1;
                break;
            }
            foundPath.add(new Node(n.x, n.y, n.z));
        }
        if (this.cx == this.tx && this.cy == this.ty && this.cz == this.tz) {
            foundPath.add(new Node(this.tx, this.ty, this.tz));
        }
        this.currentNode = null;
        this.world = null;
        this.allNodes.clear();
        this.path.clear();
        return foundPath;
    }

    protected void setInitialDirection() {
        if (Math.abs(this.xDiff) > Math.abs(this.zDiff)) {
            this.dx = this.gx;
            this.dz = 0;
            if (!(this.world.isWalkable(this.cx + this.dx, this.cy, this.cz) || this.world.isWalkable(this.cx + this.dx, this.cy + 1, this.cz) || this.world.isWalkable(this.cx, this.cy - 1, this.cz))) {
                this.dx = 0;
                this.dz = this.gz;
            }
        } else {
            this.dz = this.gz;
            this.dx = 0;
            if (!(this.world.isWalkable(this.cx, this.cy, this.cz + this.dz) || this.world.isWalkable(this.cx, this.cy + 1, this.cz + this.dz) || this.world.isWalkable(this.cx, this.cy - 1, this.cz + this.dz))) {
                this.dz = 0;
                this.dx = this.gx;
            }
        }
    }

    protected void searchLoop() {
        this.calcTargetDirection();
        this.setInitialDirection();
        this.dy = 0;
        if (this.dx == 0 && this.dz == 0) {
            this.path.add(this.currentNode);
            return;
        }
        Object newNode = null;
        for (int i = 0; i < this.maxRange && (this.cx != this.tx || this.cy != this.ty || this.cz != this.tz); ++i) {
            this.path.add(this.currentNode);
            this.pdx = this.dx;
            this.pdy = this.dy;
            this.pdz = this.dz;
            this.pcx = this.cx;
            this.pcy = this.cy;
            this.pcz = this.cz;
            if (this.tryPathDirectlyToTarget()) break;
            if (this.tryMoveTowardsGoal() || this.tryFollowWall()) continue;
            this.dx = this.pdx;
            this.dz = this.pdz;
            this.dy = this.pdy;
            if (!this.tryMoveStraight() && !this.tryTurn() && (!this.tryFindLastTurn() || this.dx == 0 && this.dy == 0 && this.dz == 0 || this.pcx == this.cx && this.pcy == this.cy && this.pcz == this.cz)) break;
        }
        if (this.cx == this.tx && this.cy == this.ty && this.cz == this.tz) {
            this.path.add(new Node(this.tx, this.ty, this.tz));
        }
    }

    protected boolean tryMoveTowardsGoal() {
        this.calcTargetDirection();
        if (Math.abs(this.xDiff) > Math.abs(this.zDiff)) {
            this.dx = this.gx;
            this.dz = 0;
            if (this.dx != 0 && this.tryMoveStraight()) {
                return true;
            }
        } else {
            this.dz = this.gz;
            this.dx = 0;
            if (this.dz != 0 && this.tryMoveStraight()) {
                return true;
            }
        }
        return false;
    }

    protected boolean tryFollowWall() {
        return false;
    }

    protected boolean tryMoveStraight() {
        if (this.world.isWalkable(this.cx, this.cy + 1, this.cz) && this.ty > this.cy) {
            this.dy = 1;
            this.cy += this.dy;
            this.currentNode = this.getOrMakeNode(this.cx, this.cy, this.cz, this.currentNode);
            return true;
        }
        if (this.world.isWalkable(this.cx, this.cy - 1, this.cz) && this.ty < this.cy) {
            this.dy = -1;
            this.cy += this.dy;
            this.currentNode = this.getOrMakeNode(this.cx, this.cy, this.cz, this.currentNode);
            return true;
        }
        if (this.world.isWalkable(this.cx + this.dx, this.cy, this.cz + this.dz)) {
            this.dy = 0;
            this.cx += this.dx;
            this.cz += this.dz;
            this.cy += this.dy;
            this.currentNode = this.getOrMakeNode(this.cx, this.cy, this.cz, this.currentNode);
            return true;
        }
        if (this.world.isWalkable(this.cx + this.dx, this.cy + 1, this.cz + this.dz) && !this.world.checkBlockBounds(this.cx, this.cy + 2, this.cz)) {
            this.dy = 1;
            this.cx += this.dx;
            this.cz += this.dz;
            this.cy += this.dy;
            this.currentNode = this.getOrMakeNode(this.cx, this.cy, this.cz, this.currentNode);
            return true;
        }
        if (this.world.isWalkable(this.cx + this.dx, this.cy - 1, this.cz + this.dz) && !this.world.checkBlockBounds(this.cx + this.dx, this.cy + 1, this.cz + this.dz)) {
            this.dy = -1;
            this.cx += this.dx;
            this.cz += this.dz;
            this.cy += this.dy;
            this.currentNode = this.getOrMakeNode(this.cx, this.cy, this.cz, this.currentNode);
            return true;
        }
        return false;
    }

    protected boolean tryTurn() {
        this.dx = this.pdx;
        this.dz = this.pdz;
        if (this.dx != 0) {
            this.dx = 0;
            this.dz = this.getZforTurn(this.dz);
            if (this.tryMoveStraight()) {
                this.followingWall = true;
                return true;
            }
        } else if (this.dz != 0) {
            this.dz = 0;
            this.dx = this.getXforTurn(this.dx);
            if (this.tryMoveStraight()) {
                this.followingWall = true;
                return true;
            }
        }
        return false;
    }

    protected int getXforTurn(int dx) {
        dx = this.pcz < this.cz ? this.turnDir : (this.pcz > this.cz ? -this.turnDir : 0);
        return dx;
    }

    protected int getZforTurn(int dz) {
        dz = this.pcx < this.cx ? this.turnDir : (this.pcx > this.cx ? -this.turnDir : 0);
        return dz;
    }

    protected boolean tryFindLastTurn() {
        return false;
    }

    protected boolean tryPathDirectlyToTarget() {
        return false;
    }

    protected void calcTargetDirection() {
        this.gx = this.tx - this.cx;
        this.gy = this.ty - this.cy;
        this.gz = this.tz - this.cz;
        this.xDiff = this.gx;
        this.yDiff = this.gy;
        this.zDiff = this.gz;
        int n = this.gx < 0 ? -1 : (this.gx = this.gx > 0 ? 1 : 0);
        int n2 = this.gy < 0 ? -1 : (this.gy = this.gy > 0 ? 1 : 0);
        this.gz = this.gz < 0 ? -1 : (this.gz > 0 ? 1 : 0);
    }

    private CrawlNode getOrMakeNode(int x, int y, int z, Node p) {
        CrawlNode n = null;
        for (CrawlNode c : this.allNodes) {
            if (!c.equals(x, y, z)) continue;
            return c;
        }
        n = new CrawlNode(x, y, z);
        this.allNodes.add(n);
        return n;
    }

    private class CrawlNode
    extends Node {
        public CrawlNode(int bX, int bY, int bZ) {
            super(bX, bY, bZ);
        }
    }
}

