/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.pathing;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.shadowmage.ancientwarfare.core.util.Trig;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.entity.EntityGate;
import net.shadowmage.ancientwarfare.structure.init.AWStructureBlocks;
import net.shadowmage.ancientwarfare.structure.tile.TEGateProxy;
import net.shadowmage.ancientwarfare.vehicle.entity.IPathableEntity;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleBase;
import net.shadowmage.ancientwarfare.vehicle.pathing.EntityPath;
import net.shadowmage.ancientwarfare.vehicle.pathing.IPathableCallback;
import net.shadowmage.ancientwarfare.vehicle.pathing.Node;
import net.shadowmage.ancientwarfare.vehicle.pathing.PathFinderCrawler;
import net.shadowmage.ancientwarfare.vehicle.pathing.PathFinderThetaStar;
import net.shadowmage.ancientwarfare.vehicle.pathing.PathUtils;
import net.shadowmage.ancientwarfare.vehicle.pathing.PathWorldAccess;

public class Navigator
implements IPathableCallback {
    private static final int DOOR_OPEN_MAX = 15;
    private static final int DOOR_CHECK_TICKS_MAX = 5;
    private PathFinderThetaStar pathFinder = new PathFinderThetaStar();
    protected IPathableEntity owner;
    protected Entity entity;
    protected PathWorldAccess world;
    protected EntityPath path;
    private final Node finalTarget = new Node(0, 0, 0);
    private Node currentTarget;
    protected Random rng = new Random();
    protected EntityGate gate = null;
    private boolean hasDoor = false;
    private BlockPos doorPos = BlockPos.field_177992_a;
    private int doorOpenTicks = 0;
    private int doorCheckTicks = 0;
    private Vec3d stuckCheckPosition = Vec3d.field_186680_a;
    private int stuckCheckTicks = 40;
    private int stuckCheckTicksMax = 40;
    private PathFinderCrawler testCrawler;

    public Navigator(VehicleBase owner) {
        this.owner = owner;
        this.entity = owner.getEntity();
        this.world = owner.worldAccess;
        this.path = new EntityPath();
        this.finalTarget.reassign(MathHelper.func_76128_c((double)this.entity.field_70165_t), MathHelper.func_76128_c((double)this.entity.field_70163_u), MathHelper.func_76128_c((double)this.entity.field_70161_v));
        this.stuckCheckPosition = new Vec3d(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v);
        this.testCrawler = new PathFinderCrawler();
    }

    public void setStuckCheckTicks(int ticks) {
        if (ticks > 0) {
            this.stuckCheckTicksMax = ticks;
        }
    }

    public void setMoveToTarget(BlockPos pos) {
        if (!this.entity.field_70170_p.func_175667_e(pos)) {
            return;
        }
        this.sendToClients(pos);
        int ex = MathHelper.func_76128_c((double)this.entity.field_70165_t);
        int ey = MathHelper.func_76128_c((double)this.entity.field_70163_u);
        int ez = MathHelper.func_76128_c((double)this.entity.field_70161_v);
        if (this.entity.field_70163_u % 1.0 > 0.75 && !this.world.isWalkable(ex, ey, ez)) {
            ++ey;
        }
        if (this.shouldCalculatePath(pos)) {
            this.finalTarget.reassign(pos);
            this.calculatePath(ex, ey, ez, pos);
        }
    }

    public void onMovementUpdate() {
        this.updateMoveHelper();
        this.detectStuck();
        this.claimNode();
        if (this.currentTarget != null) {
            if (this.world.canUseLaders) {
                this.handleLadderMovement();
            }
            if (this.world.canOpenDoors) {
                this.doorInteraction();
            }
            this.owner.setMoveTo((double)this.currentTarget.x + 0.5, this.currentTarget.y, (double)this.currentTarget.z + 0.5, this.owner.getDefaultMoveSpeed());
        }
    }

    private void handleLadderMovement() {
        if (this.owner.isPathableEntityOnLadder()) {
            if (this.currentTarget.y < (int)this.entity.field_70163_u) {
                this.entity.field_70181_x = -0.125;
            } else if (this.currentTarget.y > (int)this.entity.field_70163_u) {
                this.entity.field_70181_x = 0.125;
            }
        }
    }

    private void updateMoveHelper() {
        this.pathFinder.doSearchIterations(10);
        if (this.doorOpenTicks > 0) {
            --this.doorOpenTicks;
        }
        if (this.hasDoor && this.doorOpenTicks <= 0) {
            this.hasDoor = false;
            this.interactWithDoor(this.doorPos, false);
        }
        if (this.gate != null && this.doorOpenTicks <= 0) {
            this.interactWithGate(false);
            this.gate = null;
        }
    }

    private void detectStuck() {
        if (this.stuckCheckTicks <= 0) {
            this.stuckCheckTicks = this.stuckCheckTicksMax;
            if (this.currentTarget != null && this.entity.func_70011_f(this.stuckCheckPosition.field_72450_a, this.stuckCheckPosition.field_72448_b, this.stuckCheckPosition.field_72449_c) < 1.5) {
                this.owner.onStuckDetected();
                this.clearPath();
                this.currentTarget = null;
            }
            this.stuckCheckPosition = new Vec3d(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v);
        } else {
            --this.stuckCheckTicks;
        }
    }

    private boolean isNewTargetClose(BlockPos target) {
        float dist = (float)this.entity.func_70011_f((double)this.finalTarget.x, (double)this.finalTarget.y, (double)this.finalTarget.z);
        float tDist = Trig.getDistance(this.finalTarget.x, this.finalTarget.y, this.finalTarget.z, target.func_177958_n(), target.func_177956_o(), target.func_177952_p());
        return tDist < dist * 0.1f;
    }

    private boolean isNewTarget(BlockPos target) {
        return !this.isNewTargetClose(target) && !this.finalTarget.equals(target.func_177958_n(), target.func_177956_o(), target.func_177952_p());
    }

    private boolean isAtTarget(BlockPos pos) {
        return this.entity.func_70011_f((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5) < (double)this.entity.field_70130_N;
    }

    private boolean isPathEmpty() {
        return this.path.getActivePathSize() <= 0;
    }

    private boolean shouldCalculatePath(BlockPos target) {
        return this.isNewTarget(target) || this.isPathEmpty() && !this.isAtTarget(target) && this.currentTarget == null && !this.pathFinder.isSearching;
    }

    private void calculatePath(int ex, int ey, int ez, BlockPos target) {
        this.path.clearPath();
        this.currentTarget = null;
        if (PathUtils.canPathStraightToTarget(this.world, ex, ey, ez, target)) {
            this.currentTarget = new Node(target);
        } else {
            this.path.setPath(this.testCrawler.findPath(this.world, ex, ey, ez, target, 8));
            Node end = this.path.getEndNode();
            if (end != null && (end.x != target.func_177958_n() || end.y != target.func_177956_o() || end.z != target.func_177952_p())) {
                this.pathFinder.findPath(this.world, end.x, end.y, end.z, target, 60, this, false);
            }
        }
        this.stuckCheckTicks = this.stuckCheckTicksMax;
        this.stuckCheckPosition = new Vec3d(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v);
        Node start = this.path.getFirstNode();
        if (start != null && this.getEntityDistance(start) < 0.8f && start.y == ey) {
            this.path.claimNode();
        }
        this.claimNode();
    }

    private void doorInteraction() {
        if (this.doorCheckTicks <= 0) {
            this.doorCheckTicks = 5;
            if (this.entity.field_70123_F && this.checkForDoors(this.entity.func_180425_c())) {
                if (this.hasDoor) {
                    this.interactWithDoor(this.doorPos, true);
                    this.doorOpenTicks = 15;
                } else if (this.gate != null) {
                    this.interactWithGate(true);
                    this.doorOpenTicks = 15;
                }
            }
        } else {
            --this.doorCheckTicks;
        }
    }

    private boolean checkForDoors(BlockPos entityPos) {
        float yaw;
        IBlockState state = this.entity.field_70170_p.func_180495_p(entityPos);
        Block block = state.func_177230_c();
        if (block instanceof BlockDoor && state.func_185904_a() == Material.field_151575_d || block instanceof BlockFenceGate) {
            if (this.hasDoor && !this.doorPos.equals((Object)entityPos)) {
                this.interactWithDoor(this.doorPos, false);
            }
            this.doorPos = entityPos;
            this.hasDoor = true;
            return true;
        }
        if (block == AWStructureBlocks.GATE_PROXY) {
            WorldTools.getTile((IBlockAccess)this.entity.field_70170_p, entityPos, TEGateProxy.class).ifPresent(proxy -> {
                this.interactWithGate(false);
                this.gate = proxy.getOwner().orElse(null);
            });
            return true;
        }
        for (yaw = this.entity.field_70177_z; yaw < 0.0f; yaw += 360.0f) {
        }
        while (yaw >= 360.0f) {
            yaw -= 360.0f;
        }
        int x = entityPos.func_177958_n();
        int y = entityPos.func_177956_o();
        int z = entityPos.func_177952_p();
        if (yaw >= 315.0f || yaw < 45.0f) {
            ++z;
        } else if (yaw >= 45.0f && yaw < 135.0f) {
            --x;
        } else if (yaw >= 135.0f && yaw < 225.0f) {
            --z;
        } else {
            ++x;
        }
        state = this.entity.field_70170_p.func_180495_p(new BlockPos(x, y, z));
        block = state.func_177230_c();
        if (block instanceof BlockDoor && state.func_185904_a() == Material.field_151575_d || block instanceof BlockFenceGate) {
            if (this.hasDoor && !this.doorPos.equals((Object)entityPos)) {
                this.interactWithDoor(this.doorPos, false);
            }
            this.doorPos = entityPos;
            this.hasDoor = true;
            return true;
        }
        if (block == AWStructureBlocks.GATE_PROXY) {
            WorldTools.getTile((IBlockAccess)this.entity.field_70170_p, new BlockPos(x, y, z), TEGateProxy.class).ifPresent(proxy -> {
                this.interactWithGate(false);
                this.gate = proxy.getOwner().orElse(null);
            });
            return true;
        }
        return false;
    }

    private void interactWithGate(boolean open) {
        if (this.gate.edgePosition > 0.0f && !open || this.gate.edgePosition == 0.0f && open) {
            this.gate.activateGate();
        }
        if (!open) {
            this.gate = null;
        }
    }

    private void interactWithDoor(BlockPos doorPos, boolean open) {
        IBlockState state = this.entity.field_70170_p.func_180495_p(doorPos);
        Block block = state.func_177230_c();
        if (block instanceof BlockDoor && state.func_185904_a() == Material.field_151575_d) {
            ((BlockDoor)block).func_176512_a(this.entity.field_70170_p, doorPos, open);
        } else if (block instanceof BlockFenceGate && open != (Boolean)state.func_177229_b((IProperty)BlockFenceGate.field_176466_a)) {
            if (open && !((Boolean)state.func_177229_b((IProperty)BlockFenceGate.field_176466_a)).booleanValue()) {
                this.entity.field_70170_p.func_180501_a(doorPos, state.func_177226_a((IProperty)BlockFenceGate.field_176466_a, (Comparable)Boolean.valueOf(true)), 2);
                this.entity.field_70170_p.func_180498_a(null, 1008, doorPos, 0);
            } else if (!open && ((Boolean)state.func_177229_b((IProperty)BlockFenceGate.field_176466_a)).booleanValue()) {
                this.entity.field_70170_p.func_180501_a(doorPos, state.func_177226_a((IProperty)BlockFenceGate.field_176466_a, (Comparable)Boolean.valueOf(false)), 2);
                this.entity.field_70170_p.func_180498_a(null, 1014, doorPos, 0);
            }
        }
    }

    private void claimNode() {
        if (this.currentTarget == null || this.getEntityDistance(this.currentTarget) < this.entity.field_70130_N) {
            this.currentTarget = this.path.claimNode();
            while (this.currentTarget != null && this.getEntityDistance(this.currentTarget) < this.entity.field_70130_N) {
                this.currentTarget = this.path.claimNode();
            }
            this.stuckCheckTicks = this.stuckCheckTicksMax;
            this.stuckCheckPosition = new Vec3d(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v);
        }
    }

    private float getEntityDistance(Node n) {
        return this.entity == null ? 0.0f : (n == null ? 0.0f : (float)this.entity.func_70011_f((double)n.x + 0.5, (double)n.y, (double)n.z + 0.5));
    }

    private void sendToClients(BlockPos pos) {
    }

    @Override
    public void onPathFound(List<Node> pathNodes) {
        this.path.addPath(this.world, pathNodes);
    }

    public void clearPath() {
        this.path.clearPath();
        this.currentTarget = null;
    }

    public void forcePath(List<Node> n) {
        this.path.setPath(n);
        this.claimNode();
    }

    public void setCanGoOnLand(boolean land) {
        this.world.setCanGoOnLand(land);
    }
}

