/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.network;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Optional;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleBase;
import net.shadowmage.ancientwarfare.vehicle.network.PacketVehicleBase;

public class PacketAimUpdate
extends PacketVehicleBase {
    private Optional<Float> pitch;
    private Optional<Float> yaw;
    private Optional<Float> power;

    public PacketAimUpdate() {
    }

    public PacketAimUpdate(VehicleBase vehicle, Optional<Float> pitch, Optional<Float> yaw, Optional<Float> power) {
        super(vehicle);
        this.pitch = pitch;
        this.yaw = yaw;
        this.power = power;
    }

    @Override
    protected void writeToStream(ByteBuf data) {
        super.writeToStream(data);
        data.writeBoolean(this.pitch.isPresent());
        this.pitch.ifPresent(arg_0 -> ((ByteBuf)data).writeFloat(arg_0));
        data.writeBoolean(this.yaw.isPresent());
        this.yaw.ifPresent(arg_0 -> ((ByteBuf)data).writeFloat(arg_0));
        data.writeBoolean(this.power.isPresent());
        this.power.ifPresent(arg_0 -> ((ByteBuf)data).writeFloat(arg_0));
    }

    @Override
    protected void readFromStream(ByteBuf data) throws IOException {
        super.readFromStream(data);
        this.pitch = data.readBoolean() ? Optional.of(Float.valueOf(data.readFloat())) : Optional.empty();
        this.yaw = data.readBoolean() ? Optional.of(Float.valueOf(data.readFloat())) : Optional.empty();
        this.power = data.readBoolean() ? Optional.of(Float.valueOf(data.readFloat())) : Optional.empty();
    }

    @Override
    public void execute() {
        this.vehicle.firingHelper.updateAim(this.pitch, this.yaw, this.power);
    }
}

