/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.missiles;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.util.Trig;
import net.shadowmage.ancientwarfare.vehicle.entity.IMissileHitCallback;
import net.shadowmage.ancientwarfare.vehicle.missiles.Ammo;
import net.shadowmage.ancientwarfare.vehicle.missiles.IAmmo;
import net.shadowmage.ancientwarfare.vehicle.registry.AmmoRegistry;

public class MissileBase
extends Entity
implements IEntityAdditionalSpawnData {
    public IAmmo ammoType = AmmoRegistry.ammoArrow;
    public Entity launcher = null;
    public Entity shooterLiving;
    IMissileHitCallback shooter = null;
    private int rocketBurnTime = 0;
    private boolean inGround = false;
    private boolean hasImpacted = false;
    private BlockPos persistentBlockPos = BlockPos.field_177992_a;
    private IBlockState persistentBlock = Blocks.field_150350_a.func_176223_P();
    private float mX;
    private float mY;
    private float mZ;

    public MissileBase(World par1World) {
        super(par1World);
        this.field_70144_Y = 1.0f;
        this.func_70105_a(0.4f, 0.4f);
    }

    private void setMissileParams(IAmmo type, float x, float y, float z, float mx, float my, float mz) {
        this.ammoType = type;
        this.func_70107_b(x, y, z);
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70159_w = mx;
        this.field_70181_x = my;
        this.field_70179_y = mz;
        this.mX = mx;
        this.mY = my;
        this.mZ = mz;
        if (this.ammoType.updateAsArrow()) {
            this.onUpdateArrowRotation();
        }
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
        if (this.ammoType.isRocket()) {
            float temp = MathHelper.func_76129_c((float)(mx * mx + my * my + mz * mz));
            this.rocketBurnTime = (int)(temp * 20.0f * 3.0f);
            this.mX = (float)(this.field_70159_w / (double)temp) * 0.01f;
            this.mY = (float)(this.field_70181_x / (double)temp) * 0.01f;
            this.mZ = (float)(this.field_70179_y / (double)temp) * 0.01f;
            this.field_70159_w = this.mX;
            this.field_70181_x = this.mY;
            this.field_70179_y = this.mZ;
        }
    }

    public void setMissileParams2(IAmmo ammo, float x, float y, float z, float yaw, float angle, float velocity) {
        float vX = -Trig.sinDegrees(yaw) * Trig.cosDegrees(angle) * velocity * 0.05f;
        float vY = Trig.sinDegrees(angle) * velocity * 0.05f;
        float vZ = -Trig.cosDegrees(yaw) * Trig.cosDegrees(angle) * velocity * 0.05f;
        this.setMissileParams(ammo, x, y, z, vX, vY, vZ);
    }

    public void setShooter(Entity shooter) {
        this.shooterLiving = shooter;
    }

    public void setLaunchingEntity(Entity ent) {
        this.launcher = ent;
    }

    public void setMissileCallback(IMissileHitCallback shooter) {
        this.shooter = shooter;
    }

    public void onImpactEntity(Entity ent, float x, float y, float z) {
        if (Ammo.shouldEffectEntity(this.field_70170_p, ent, this)) {
            this.ammoType.onImpactEntity(this.field_70170_p, ent, x, y, z, this);
            if (this.shooter != null) {
                this.shooter.onMissileImpactEntity(this.field_70170_p, ent);
            }
        }
    }

    public void onImpactWorld(RayTraceResult hit) {
        this.ammoType.onImpactWorld(this.field_70170_p, hit.func_178782_a().func_177958_n(), hit.func_178782_a().func_177956_o(), hit.func_178782_a().func_177952_p(), this, hit);
        if (this.shooter != null) {
            this.shooter.onMissileImpact(this.field_70170_p, hit.func_178782_a().func_177958_n(), hit.func_178782_a().func_177956_o(), hit.func_178782_a().func_177952_p());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_90999_ad() {
        return this.ammoType.isFlaming();
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70108_f(Entity par1Entity) {
    }

    public void func_70071_h_() {
        ++this.field_70173_aa;
        super.func_70071_h_();
        this.onMovementTick();
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa > 6000) {
            this.func_70106_y();
        }
    }

    private void checkProximity() {
        if (this.field_70181_x > 0.0) {
            return;
        }
        int groundDiff = 0;
        int x = (int)this.field_70165_t;
        int y = (int)this.field_70163_u;
        int z = (int)this.field_70161_v;
        boolean impacted = false;
        if (this.ammoType.groundProximity() > 0.0f) {
            while ((float)groundDiff <= this.ammoType.groundProximity()) {
                if (this.field_70170_p.func_175623_d(new BlockPos(x, y - ++groundDiff, z))) continue;
                this.onImpactWorld(new RayTraceResult(new Vec3d((double)x, (double)y, (double)z), EnumFacing.DOWN, new BlockPos(x, y, z)));
                impacted = true;
                break;
            }
        }
        if (!impacted && this.ammoType.entityProximity() > 0.0f) {
            float entProx = this.ammoType.entityProximity();
            float foundDist = 0.0f;
            List entities = this.field_70170_p.func_72839_b((Entity)this, new AxisAlignedBB(this.field_70165_t - (double)entProx, this.field_70163_u - (double)entProx, this.field_70161_v - (double)entProx, this.field_70165_t + (double)entProx, this.field_70163_u + (double)entProx, this.field_70161_v + (double)entProx));
            if (!entities.isEmpty()) {
                for (Entity ent : entities) {
                    if (ent == null || ent.getClass() == MissileBase.class || !((foundDist = this.func_70032_d(ent)) < entProx)) continue;
                    this.onImpactEntity(ent, (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v);
                    break;
                }
            }
        }
    }

    private void onMovementTick() {
        if (this.inGround && this.persistentBlock != this.field_70170_p.func_180495_p(this.persistentBlockPos)) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.inGround = false;
        }
        if (!this.inGround) {
            Vec3d positionVector = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d moveVector = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            RayTraceResult hitPosition = this.field_70170_p.func_147447_a(positionVector, moveVector, false, true, false);
            Entity hitEntity = null;
            boolean testEntities = true;
            if (this.field_70170_p.field_72995_K) {
                testEntities = false;
            }
            if (testEntities) {
                List nearbyEntities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72317_d(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
                double closestHit = 0.0;
                for (int i = 0; i < nearbyEntities.size(); ++i) {
                    double hitDistance;
                    Entity curEnt = (Entity)nearbyEntities.get(i);
                    if (!curEnt.func_70067_L() || this.launcher != null && (curEnt == this.launcher || curEnt == this.launcher.func_184179_bs() || curEnt == this.shooterLiving || curEnt == this.shooter)) continue;
                    float borderSize = 0.3f;
                    AxisAlignedBB var12 = curEnt.func_174813_aQ().func_72314_b((double)borderSize, (double)borderSize, (double)borderSize);
                    RayTraceResult checkHit = var12.func_72327_a(positionVector, moveVector);
                    if (checkHit == null || !((hitDistance = positionVector.func_72438_d(checkHit.field_72307_f)) < closestHit) && closestHit != 0.0) continue;
                    hitEntity = curEnt;
                    closestHit = hitDistance;
                }
            }
            if (hitEntity != null) {
                hitPosition = new RayTraceResult(hitEntity);
            }
            if (hitPosition != null) {
                if (hitPosition.field_72308_g != null) {
                    this.onImpactEntity(hitPosition.field_72308_g, (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v);
                    this.hasImpacted = true;
                    if (!this.ammoType.isPenetrating() && !this.field_70170_p.field_72995_K) {
                        this.func_70106_y();
                    } else if (this.ammoType.isPenetrating()) {
                        this.field_70159_w *= (double)0.65f;
                        this.field_70181_x *= (double)0.65f;
                        this.field_70179_y *= (double)0.65f;
                    }
                } else {
                    this.onImpactWorld(hitPosition);
                    this.hasImpacted = true;
                    if (!this.ammoType.isPenetrating()) {
                        this.field_70159_w = (float)(hitPosition.field_72307_f.field_72450_a - this.field_70165_t);
                        this.field_70181_x = (float)(hitPosition.field_72307_f.field_72448_b - this.field_70163_u);
                        this.field_70179_y = (float)(hitPosition.field_72307_f.field_72449_c - this.field_70161_v);
                        float var20 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
                        this.field_70165_t -= this.field_70159_w / (double)var20 * (double)0.05f;
                        this.field_70163_u -= this.field_70181_x / (double)var20 * (double)0.05f;
                        this.field_70161_v -= this.field_70179_y / (double)var20 * (double)0.05f;
                        this.inGround = true;
                        if (!this.ammoType.isPersistent() && !this.field_70170_p.field_72995_K) {
                            this.func_70106_y();
                        } else if (this.ammoType.isPersistent()) {
                            this.persistentBlockPos = hitPosition.func_178782_a();
                            this.persistentBlock = this.field_70170_p.func_180495_p(this.persistentBlockPos);
                        }
                    } else {
                        this.field_70159_w *= (double)0.65f;
                        this.field_70181_x *= (double)0.65f;
                        this.field_70179_y *= (double)0.65f;
                    }
                }
            }
            if (this.ammoType.isProximityAmmo() && this.field_70173_aa > 20) {
                this.checkProximity();
                if (this.field_70128_L) {
                    return;
                }
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            if (this.ammoType.isRocket() && this.rocketBurnTime > 0) {
                --this.rocketBurnTime;
                this.field_70159_w += (double)this.mX;
                this.field_70181_x += (double)this.mY;
                this.field_70179_y += (double)this.mZ;
                if (this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
                }
            } else {
                this.field_70181_x -= (double)this.ammoType.getGravityFactor();
            }
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            if (this.ammoType.updateAsArrow()) {
                this.onUpdateArrowRotation();
            }
        }
    }

    private void onUpdateArrowRotation() {
        double motionSpeed = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = Trig.toDegrees((float)Math.atan2(this.field_70159_w, this.field_70179_y)) - 90.0f;
        this.field_70125_A = Trig.toDegrees((float)Math.atan2(this.field_70181_x, motionSpeed)) - 90.0f;
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
    }

    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.func_70107_b(x, y, z);
    }

    public ResourceLocation getTexture() {
        return this.ammoType.getModelTexture();
    }

    protected void func_70037_a(NBTTagCompound tag) {
        this.ammoType = AmmoRegistry.getAmmo(new ResourceLocation(tag.func_74779_i("ammoRegistryName")));
        this.inGround = tag.func_74767_n("inGround");
        this.persistentBlockPos = BlockPos.func_177969_a((long)tag.func_74763_f("persistentBlockPos"));
        this.persistentBlock = NBTUtil.func_190008_d((NBTTagCompound)tag.func_74775_l("persistentBlock"));
        this.field_70173_aa = tag.func_74762_e("ticks");
        this.mX = tag.func_74760_g("mX");
        this.mY = tag.func_74760_g("mY");
        this.mZ = tag.func_74760_g("mZ");
        if (this.ammoType == null) {
            this.ammoType = AmmoRegistry.ammoArrow;
        }
    }

    protected void func_70014_b(NBTTagCompound tag) {
        tag.func_74778_a("ammoRegistryName", this.ammoType.getRegistryName().toString());
        tag.func_74757_a("inGround", this.inGround);
        tag.func_74772_a("persistentBlockPos", this.persistentBlockPos.func_177986_g());
        NBTTagCompound block = new NBTTagCompound();
        NBTUtil.func_190009_a((NBTTagCompound)block, (IBlockState)this.persistentBlock);
        tag.func_74782_a("persistentBlock", (NBTBase)block);
        tag.func_74768_a("ticks", this.field_70173_aa);
        tag.func_74776_a("mX", this.mX);
        tag.func_74776_a("mY", this.mY);
        tag.func_74776_a("mZ", this.mZ);
    }

    protected void func_70088_a() {
    }

    public void writeSpawnData(ByteBuf data) {
        PacketBuffer pb = new PacketBuffer(data);
        pb.func_180714_a(this.ammoType.getRegistryName().toString());
        pb.writeFloat(this.field_70177_z);
        pb.writeFloat(this.field_70125_A);
        pb.writeBoolean(this.inGround);
        pb.writeLong(this.persistentBlockPos.func_177986_g());
        pb.writeInt(Block.func_176210_f((IBlockState)this.persistentBlock));
        pb.writeInt(this.rocketBurnTime);
        pb.writeBoolean(this.launcher != null);
        if (this.launcher != null) {
            pb.writeInt(this.launcher.func_145782_y());
        }
    }

    public void readSpawnData(ByteBuf data) {
        PacketBuffer pb = new PacketBuffer(data);
        this.ammoType = AmmoRegistry.getAmmo(new ResourceLocation(pb.func_150789_c(64)));
        this.field_70126_B = this.field_70177_z = pb.readFloat();
        this.field_70127_C = this.field_70125_A = pb.readFloat();
        this.inGround = pb.readBoolean();
        this.persistentBlockPos = BlockPos.func_177969_a((long)pb.readLong());
        this.persistentBlock = Block.func_176220_d((int)pb.readInt());
        this.rocketBurnTime = pb.readInt();
        boolean hasLauncher = pb.readBoolean();
        if (hasLauncher) {
            this.launcher = this.field_70170_p.func_73045_a(pb.readInt());
        }
    }
}

