/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.missiles;

import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.vehicle.missiles.Ammo;
import net.shadowmage.ancientwarfare.vehicle.missiles.DamageType;
import net.shadowmage.ancientwarfare.vehicle.missiles.MissileBase;

public class AmmoFlameShot
extends Ammo {
    public AmmoFlameShot(int weight) {
        super("ammo_flame_shot_" + weight);
        this.isPersistent = false;
        this.isArrow = false;
        this.isRocket = false;
        this.isFlaming = true;
        this.ammoWeight = weight;
        float scaleFactor = (float)weight + 45.0f;
        this.renderScale = (float)weight / scaleFactor * 2.0f;
        this.configName = "flame_shot_" + weight;
        this.vehicleDamage = 8;
        this.entityDamage = 8;
        this.modelTexture = new ResourceLocation("ancientwarfare", "textures/model/vehicle/ammo/ammo_stone_shot.png");
    }

    @Override
    public void onImpactWorld(World world, float x, float y, float z, MissileBase missile, RayTraceResult hit) {
        if (!world.field_72995_K) {
            int bx = (int)x;
            int by = (int)y + 2;
            int bz = (int)z;
            this.igniteBlock(world, bx, by, bz, 5);
            if (this.ammoWeight >= 15.0f) {
                this.igniteBlock(world, bx - 1, by, bz, 5);
                this.igniteBlock(world, bx + 1, by, bz, 5);
                this.igniteBlock(world, bx, by, bz - 1, 5);
                this.igniteBlock(world, bx, by, bz + 1, 5);
            }
            if (this.ammoWeight >= 30.0f) {
                this.igniteBlock(world, bx - 1, by, bz - 1, 5);
                this.igniteBlock(world, bx - 1, by, bz + 1, 5);
                this.igniteBlock(world, bx + 1, by, bz - 1, 5);
                this.igniteBlock(world, bx + 1, by, bz + 1, 5);
                this.igniteBlock(world, bx - 2, by, bz, 5);
                this.igniteBlock(world, bx + 2, by, bz, 5);
                this.igniteBlock(world, bx, by, bz - 2, 5);
                this.igniteBlock(world, bx, by, bz + 2, 5);
            }
            if (this.ammoWeight >= 45.0f) {
                this.igniteBlock(world, bx - 1, by, bz - 2, 5);
                this.igniteBlock(world, bx + 1, by, bz - 2, 5);
                this.igniteBlock(world, bx - 1, by, bz + 2, 5);
                this.igniteBlock(world, bx + 1, by, bz + 2, 5);
                this.igniteBlock(world, bx - 2, by, bz - 1, 5);
                this.igniteBlock(world, bx - 2, by, bz + 1, 5);
                this.igniteBlock(world, bx + 2, by, bz - 1, 5);
                this.igniteBlock(world, bx + 2, by, bz + 1, 5);
            }
        }
    }

    @Override
    public void onImpactEntity(World world, Entity ent, float x, float y, float z, MissileBase missile) {
        if (!world.field_72995_K) {
            ent.func_70097_a(DamageType.causeEntityMissileDamage(missile.shooterLiving, true, false), (float)this.getEntityDamage());
            ent.func_70015_d(3);
            this.onImpactWorld(world, x, y, z, missile, null);
        }
    }
}

