/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.inventory;

import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleBase;
import net.shadowmage.ancientwarfare.vehicle.missiles.IAmmo;
import net.shadowmage.ancientwarfare.vehicle.registry.AmmoRegistry;

public class AmmoStackHandler
extends ItemStackHandler {
    private VehicleBase vehicle;

    public AmmoStackHandler(VehicleBase vehicle, int size) {
        super(size);
        this.vehicle = vehicle;
    }

    protected void onContentsChanged(int slot) {
        if (!this.vehicle.field_70170_p.field_72995_K) {
            this.vehicle.ammoHelper.updateAmmoCounts();
        }
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return this.isValidAmmo(stack) ? super.insertItem(slot, stack, simulate) : stack;
    }

    private boolean isValidAmmo(ItemStack stack) {
        return AmmoRegistry.getAmmoForStack(stack).map(ammo -> this.vehicle.vehicleType.isAmmoValidForInventory((IAmmo)ammo)).orElse(false);
    }
}

