/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.helpers;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.vehicle.armors.IVehicleArmor;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleBase;
import net.shadowmage.ancientwarfare.vehicle.missiles.DamageType;
import net.shadowmage.ancientwarfare.vehicle.network.PacketUpgradeUpdate;
import net.shadowmage.ancientwarfare.vehicle.registry.ArmorRegistry;
import net.shadowmage.ancientwarfare.vehicle.registry.UpgradeRegistry;
import net.shadowmage.ancientwarfare.vehicle.upgrades.IVehicleUpgradeType;

public class VehicleUpgradeHelper
implements INBTSerializable<NBTTagCompound> {
    private List<IVehicleUpgradeType> upgrades = new ArrayList<IVehicleUpgradeType>();
    private List<IVehicleArmor> installedArmor = new ArrayList<IVehicleArmor>();
    private List<IVehicleUpgradeType> validUpgrades = new ArrayList<IVehicleUpgradeType>();
    private List<IVehicleArmor> validArmorTypes = new ArrayList<IVehicleArmor>();
    private VehicleBase vehicle;

    public VehicleUpgradeHelper(VehicleBase vehicle) {
        this.vehicle = vehicle;
    }

    public void updateUpgrades() {
        if (this.vehicle.field_70170_p.field_72995_K) {
            return;
        }
        this.upgrades = this.vehicle.inventory.getInventoryUpgrades();
        NBTTagCompound tag = new NBTTagCompound();
        this.serializeUpgrades(tag);
        this.installedArmor = this.vehicle.inventory.getInventoryArmor();
        this.serializeInstalledArmors(tag);
        PacketUpgradeUpdate pkt = new PacketUpgradeUpdate(this.vehicle);
        NetworkHandler.sendToAllTracking(this.vehicle, pkt);
        this.updateUpgradeStats();
    }

    private void serializeUpgrades(NBTTagCompound tag) {
        NBTTagList upgradesNbt = new NBTTagList();
        for (String upgrade : this.serializeUpgrades()) {
            upgradesNbt.func_74742_a((NBTBase)new NBTTagString(upgrade));
        }
        tag.func_74782_a("upgrades", (NBTBase)upgradesNbt);
    }

    public String[] serializeUpgrades() {
        int len = this.upgrades.size();
        String[] registryNames = new String[len];
        for (int i = 0; i < this.upgrades.size(); ++i) {
            registryNames[i] = this.upgrades.get(i).getRegistryName().toString();
        }
        return registryNames;
    }

    private void serializeInstalledArmors(NBTTagCompound tag) {
        NBTTagList armorTypes = new NBTTagList();
        for (String armor : this.serializeInstalledArmors()) {
            armorTypes.func_74742_a((NBTBase)new NBTTagString(armor));
        }
        tag.func_74782_a("armors", (NBTBase)armorTypes);
    }

    public String[] serializeInstalledArmors() {
        String[] armors = new String[this.installedArmor.size()];
        for (int i = 0; i < this.installedArmor.size(); ++i) {
            armors[i] = this.installedArmor.get(i).getRegistryName().toString();
        }
        return armors;
    }

    public void updateUpgrades(String[] armorRegistryNames, String[] upgradeRegistryNames) {
        this.deserializeInstalledArmor(armorRegistryNames);
        this.deserializeUpgrades(upgradeRegistryNames);
        this.updateUpgradeStats();
    }

    public List<IVehicleUpgradeType> getUpgrades() {
        return this.upgrades;
    }

    private void deserializeInstalledArmor(NBTTagCompound tag) {
        NBTTagList armorTypes = tag.func_150295_c("armors", 8);
        String[] armorRegistryNames = new String[armorTypes.func_74745_c()];
        for (int i = 0; i < armorRegistryNames.length; ++i) {
            armorRegistryNames[i] = ((NBTTagString)armorTypes.func_179238_g(i)).func_150285_a_();
        }
        this.deserializeInstalledArmor(armorRegistryNames);
    }

    private void deserializeInstalledArmor(String[] armorRegistryNames) {
        this.installedArmor.clear();
        for (String armorRegistryName : armorRegistryNames) {
            ArmorRegistry.getArmorType(new ResourceLocation(armorRegistryName)).ifPresent(armor -> this.installedArmor.add((IVehicleArmor)armor));
        }
    }

    private void deserializeUpgrades(NBTTagCompound tag) {
        NBTTagList upgradeTypes = tag.func_150295_c("upgrades", 8);
        String[] upgradeRegistryNames = new String[upgradeTypes.func_74745_c()];
        for (int i = 0; i < upgradeRegistryNames.length; ++i) {
            upgradeRegistryNames[i] = ((NBTTagString)upgradeTypes.func_179238_g(i)).func_150285_a_();
        }
        this.deserializeUpgrades(upgradeRegistryNames);
    }

    private void deserializeUpgrades(String[] upgradeRegistryNames) {
        this.upgrades.clear();
        for (String upgradeRegistryName : upgradeRegistryNames) {
            UpgradeRegistry.getUpgrade(new ResourceLocation(upgradeRegistryName)).ifPresent(this.upgrades::add);
        }
    }

    public void updateUpgradeStats() {
        this.vehicle.resetCurrentStats();
        for (IVehicleUpgradeType upgrade : this.upgrades) {
            upgrade.applyVehicleEffects(this.vehicle);
        }
        for (IVehicleArmor armor : this.installedArmor) {
            this.vehicle.currentExplosionResist += armor.getExplosiveDamageReduction();
            this.vehicle.currentFireResist += armor.getFireDamageReduction();
            this.vehicle.currentGenericResist += armor.getGeneralDamageReduction();
            this.vehicle.currentWeight += armor.getArmorWeight();
        }
    }

    public void addValidArmor(IVehicleArmor armor) {
        if (!this.validArmorTypes.contains(armor)) {
            this.validArmorTypes.add(armor);
        }
    }

    public void addValidUpgrade(IVehicleUpgradeType upgrade) {
        if (!this.validUpgrades.contains(upgrade)) {
            this.validUpgrades.add(upgrade);
        }
    }

    public float getScaledDamage(DamageSource src, float amt) {
        if (src == DamageType.explosiveMissile || src.func_94541_c()) {
            return amt * (1.0f - this.vehicle.currentExplosionResist * 0.01f);
        }
        if (src == DamageType.fireMissile || src == DamageSource.field_76372_a || src == DamageSource.field_76371_c || src == DamageSource.field_76370_b || src.func_76347_k()) {
            return amt * (1.0f - this.vehicle.currentFireResist * 0.01f);
        }
        return amt * (1.0f - this.vehicle.currentGenericResist * 0.01f);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        this.serializeUpgrades(tag);
        this.serializeInstalledArmors(tag);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        this.deserializeUpgrades(tag);
        this.deserializeInstalledArmor(tag);
    }

    public boolean hasUpgrade(IVehicleUpgradeType upgrade) {
        return this.upgrades.contains(upgrade);
    }
}

