/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.helpers;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.MoverType;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.INBTSerializable;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.Trig;
import net.shadowmage.ancientwarfare.vehicle.config.AWVehicleStatics;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleBase;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleMovementType;
import net.shadowmage.ancientwarfare.vehicle.network.PacketVehicleMove;

public class VehicleMoveHelper
implements INBTSerializable<NBTTagCompound> {
    private static final int VEHICLE_MOVE_UPDATE_FREQUENCY = 3;
    byte forwardInput;
    byte turnInput;
    byte powerInput;
    byte rotationInput;
    double destX;
    double destY;
    double destZ;
    float destYaw;
    float destPitch;
    int moveTicks = 0;
    int rotationTicks = 0;
    int pitchTicks = 0;
    public float forwardMotion = 0.0f;
    protected float verticalMotion = 0.0f;
    protected float turnMotion = 0.0f;
    protected float pitchMotion = 0.0f;
    protected float strafeMotion = 0.0f;
    public float throttle = 0.0f;
    protected float groundDrag = 0.96f;
    protected float groundStop = 0.02f;
    protected float rotationDrag = 0.94f;
    protected float rotationStop = 0.2f;
    protected float rotationSpeed = 0.0f;
    protected float pitchSpeed = 0.0f;
    protected boolean wasOnGround = true;
    protected VehicleBase vehicle;
    protected static List<Block> trampableBlocks = Lists.newArrayList((Object[])new Block[]{Blocks.field_150433_aE, Blocks.field_150330_I, Blocks.field_150329_H, Blocks.field_150328_O, Blocks.field_150327_N, Blocks.field_150338_P, Blocks.field_150337_Q});

    public VehicleMoveHelper(VehicleBase vehicle) {
        this.vehicle = vehicle;
    }

    public float getRotationSpeed() {
        return this.rotationSpeed;
    }

    public void setForwardInput(byte in) {
        this.forwardInput = in;
    }

    public void setStrafeInput(byte in) {
        this.turnInput = in;
    }

    public void updateMoveData(double posX, double posY, double posZ, boolean air, float motion, float yaw, float pitch) {
        this.pitchTicks = 4;
        this.rotationTicks = 4;
        this.moveTicks = 4;
        this.destPitch = pitch;
        this.destYaw = yaw;
        this.destX = posX;
        this.destY = posY;
        this.destZ = posZ;
        if (air) {
            this.throttle = motion;
        } else {
            this.forwardMotion = motion;
        }
    }

    public void handleInputData(byte forwardInput, byte turnInput, byte powerInput, byte rotationInput) {
        this.forwardInput = forwardInput;
        this.turnInput = turnInput;
        this.powerInput = powerInput;
        this.rotationInput = rotationInput;
    }

    public void onUpdate() {
        if (this.vehicle.field_70170_p.field_72995_K) {
            this.onUpdateClient();
        } else {
            if (this.vehicle.func_184179_bs() == null) {
                this.clearInputFromDismount();
            }
            this.onUpdateServer();
            this.vehicle.nav.onMovementUpdate();
        }
    }

    protected void onUpdateClient() {
        this.vehicle.field_70145_X = true;
        this.vehicle.field_70159_w = 0.0;
        this.vehicle.field_70181_x = 0.0;
        this.vehicle.field_70179_y = 0.0;
        this.rotationSpeed = 0.0f;
        this.pitchSpeed = 0.0f;
        if (this.rotationTicks > 0) {
            this.rotationSpeed = (this.destYaw - this.vehicle.field_70177_z) / (float)this.rotationTicks;
            this.vehicle.field_70177_z += this.rotationSpeed;
            --this.rotationTicks;
        }
        if (this.pitchTicks > 0) {
            this.pitchSpeed = (this.destPitch - this.vehicle.field_70125_A) / (float)this.pitchTicks;
            this.vehicle.field_70125_A += this.pitchSpeed;
            --this.pitchTicks;
        }
        if (this.moveTicks > 0) {
            this.vehicle.field_70159_w = this.destX - this.vehicle.field_70165_t;
            this.vehicle.field_70181_x = this.destY - this.vehicle.field_70163_u;
            this.vehicle.field_70179_y = this.destZ - this.vehicle.field_70161_v;
            --this.moveTicks;
        }
        this.vehicle.wheelRotationPrev = this.vehicle.wheelRotation;
        this.vehicle.wheelRotation = this.vehicle.vehicleType.getMovementType() == VehicleMovementType.AIR1 || this.vehicle.vehicleType.getMovementType() == VehicleMovementType.AIR2 ? (this.vehicle.wheelRotation += this.throttle) : (this.vehicle.vehicleType.getMovementType() == VehicleMovementType.WATER || this.vehicle.vehicleType.getMovementType() == VehicleMovementType.WATER2 ? (this.vehicle.wheelRotation += this.forwardMotion * 64.0f) : (this.vehicle.wheelRotation += this.forwardMotion * 60.0f));
        this.vehicle.func_70091_d(MoverType.SELF, this.vehicle.field_70159_w, this.vehicle.field_70181_x, this.vehicle.field_70179_y);
    }

    protected void onUpdateServer() {
        VehicleMovementType move = this.vehicle.vehicleType.getMovementType();
        switch (move) {
            case GROUND: {
                this.applyGroundMotion();
                break;
            }
            case WATER: {
                this.applyWaterMotion();
            }
        }
        if (move == VehicleMovementType.AIR1 || move == VehicleMovementType.AIR2) {
            this.vehicle.field_70143_R = 0.0f;
            if (this.vehicle.func_184179_bs() != null) {
                this.vehicle.func_184179_bs().field_70143_R = 0.0f;
            }
        }
        this.vehicle.field_70159_w = Trig.sinDegrees(this.vehicle.field_70177_z) * -this.forwardMotion;
        this.vehicle.field_70179_y = Trig.cosDegrees(this.vehicle.field_70177_z) * -this.forwardMotion;
        this.vehicle.func_70091_d(MoverType.SELF, this.vehicle.field_70159_w, this.vehicle.field_70181_x, this.vehicle.field_70179_y);
        this.wasOnGround = this.vehicle.field_70122_E;
        if (this.vehicle.field_70123_F) {
            this.forwardMotion *= 0.65f;
        }
        this.tearUpGrass();
        boolean sendUpdate = this.vehicle.field_70159_w != 0.0 || this.vehicle.field_70181_x != 0.0 || this.vehicle.field_70179_y != 0.0 || this.vehicle.field_70177_z != this.vehicle.field_70126_B || this.vehicle.field_70125_A != this.vehicle.field_70127_C;
        sendUpdate = sendUpdate || this.vehicle.func_184179_bs() != null;
        boolean bl = sendUpdate = sendUpdate || this.vehicle.field_70173_aa % 60 == 0;
        if (sendUpdate) {
            boolean air = move == VehicleMovementType.AIR1 || move == VehicleMovementType.AIR2;
            float motion = air ? this.throttle : this.forwardMotion;
            PacketVehicleMove pkt = new PacketVehicleMove(this.vehicle, this.vehicle.field_70165_t, this.vehicle.field_70163_u, this.vehicle.field_70161_v, air, motion, this.vehicle.field_70177_z, this.vehicle.field_70125_A);
            NetworkHandler.sendToAllTracking(this.vehicle, pkt);
        }
    }

    protected void applyGroundMotion() {
        this.applyTurnInput(0.05f);
        this.applyForwardInput(0.0125f, true);
        this.vehicle.field_70181_x -= 0.024525000730901966;
    }

    protected void applyWaterMotion() {
        this.applyTurnInput(0.05f);
        if (this.handleBoatBob(true) < 0) {
            this.forwardMotion *= 0.85f;
            this.strafeMotion *= 0.85f;
        }
        this.applyForwardInput(0.0125f, false);
    }

    protected void applyForwardInput(float inputFactor, boolean slowReverse) {
        if (this.vehicle.currentForwardSpeedMax <= 0.0f) {
            this.forwardMotion = 0.0f;
            return;
        }
        float weightAdjust = 1.0f;
        if (this.vehicle.currentWeight > this.vehicle.baseWeight) {
            weightAdjust = this.vehicle.baseWeight / this.vehicle.currentWeight;
        }
        if (this.forwardInput != 0) {
            boolean reverse = this.forwardInput == -1 && this.forwardMotion > 0.0f || this.forwardInput == 1 && this.forwardMotion < 0.0f;
            float maxSpeed = this.vehicle.currentForwardSpeedMax * weightAdjust;
            float maxReverse = -maxSpeed * (slowReverse ? 0.6f : 1.0f);
            float percent = 1.0f - (this.forwardMotion >= 0.0f ? this.forwardMotion / maxSpeed : this.forwardMotion / maxReverse);
            percent = percent > 0.25f ? 0.25f : percent;
            percent = reverse ? 0.25f : percent;
            float changeFactor = percent * (float)this.forwardInput * inputFactor;
            if (reverse) {
                changeFactor *= 2.0f;
            }
            this.forwardMotion += changeFactor;
            if (this.forwardMotion > maxSpeed) {
                this.forwardMotion = maxSpeed;
            }
            if (this.forwardMotion < maxReverse) {
                this.forwardMotion = maxReverse;
            }
        } else {
            this.forwardMotion *= this.groundDrag;
        }
        if (Math.abs(this.forwardMotion) < this.groundStop && this.forwardInput == 0) {
            this.forwardMotion = 0.0f;
        }
    }

    protected void applyTurnInput(float inputFactor) {
        float weightAdjust = 1.0f;
        if (this.vehicle.currentWeight > this.vehicle.baseWeight) {
            weightAdjust = this.vehicle.baseWeight / this.vehicle.currentWeight;
        }
        if (this.turnInput != 0) {
            boolean reverse = this.turnInput == -1 && this.turnMotion > 0.0f || this.turnInput == 1 && this.turnMotion < 0.0f;
            float maxSpeed = this.vehicle.currentStrafeSpeedMax * weightAdjust;
            float percent = 1.0f - Math.abs(this.turnMotion) / maxSpeed;
            percent = reverse ? 1.0f : percent;
            float changeFactor = percent * (float)(this.turnInput * 2) * inputFactor;
            if (reverse) {
                changeFactor *= 2.0f;
            }
            this.turnMotion += changeFactor;
            if (this.turnMotion > maxSpeed) {
                this.turnMotion = maxSpeed;
            }
            if (this.turnMotion < -maxSpeed) {
                this.turnMotion = -maxSpeed;
            }
        } else {
            this.turnMotion *= this.rotationDrag;
        }
        if (Math.abs(this.turnMotion) < this.rotationStop && this.turnInput == 0) {
            this.turnMotion = 0.0f;
        }
        this.vehicle.field_70177_z -= this.turnMotion;
    }

    protected int handleBoatBob(boolean floats) {
        AxisAlignedBB bb;
        float bitHeight = this.vehicle.field_70131_O * 0.2f;
        int submergedBits = 0;
        for (int i = 0; i < 5 && this.vehicle.field_70170_p.func_72875_a(bb = new AxisAlignedBB(this.vehicle.func_174813_aQ().field_72340_a, this.vehicle.func_174813_aQ().field_72338_b + (double)((float)i * bitHeight), this.vehicle.func_174813_aQ().field_72339_c, this.vehicle.func_174813_aQ().field_72336_d, this.vehicle.func_174813_aQ().field_72338_b + (double)((float)(1 + i) * bitHeight), this.vehicle.func_174813_aQ().field_72334_f), Material.field_151586_h); ++i) {
            ++submergedBits;
        }
        if (!floats && (submergedBits -= 2) > 0) {
            submergedBits = 0;
        }
        if (submergedBits < 0) {
            this.vehicle.field_70181_x -= 0.024525001645088196;
        } else {
            this.vehicle.field_70181_x += (double)((float)submergedBits * 0.02f);
            this.vehicle.field_70181_x *= (double)0.8f;
        }
        return submergedBits;
    }

    protected void tearUpGrass() {
        if (this.vehicle.field_70170_p.field_72995_K || !this.vehicle.field_70122_E || !AWVehicleStatics.generalSettings.vehiclesTearUpGrass) {
            return;
        }
        for (int var24 = 0; var24 < 4; ++var24) {
            int z;
            int y;
            int x = MathHelper.func_76128_c((double)(this.vehicle.field_70165_t + ((double)(var24 % 2) - 0.5) * 0.8));
            BlockPos breakPos = new BlockPos(x, y = MathHelper.func_76128_c((double)this.vehicle.field_70163_u), z = MathHelper.func_76128_c((double)(this.vehicle.field_70161_v + ((double)(var24 / 2) - 0.5) * 0.8)));
            IBlockState state = this.vehicle.field_70170_p.func_180495_p(breakPos);
            if (this.isTrampable(state)) {
                BlockTools.breakBlockAndDrop(this.vehicle.field_70170_p, breakPos);
            }
            if (this.vehicle.field_70170_p.func_180495_p(breakPos.func_177977_b()).func_177230_c() != Blocks.field_150349_c) continue;
            this.vehicle.field_70170_p.func_180501_a(breakPos.func_177977_b(), Blocks.field_150346_d.func_176223_P(), 3);
        }
    }

    private boolean isTrampable(IBlockState state) {
        return state.func_177230_c() instanceof IPlantable || trampableBlocks.contains(state.func_177230_c());
    }

    public void setMoveTo(double x, double y, double z) {
        float yawDiff = Trig.getYawTowardsTarget(this.vehicle.field_70165_t, this.vehicle.field_70161_v, x, z, this.vehicle.field_70177_z);
        byte fMot = 0;
        int sMot = 0;
        if (Math.abs(yawDiff) > 5.0f) {
            sMot = yawDiff < 0.0f ? 1 : -1;
        }
        if (Math.abs(yawDiff) < 10.0f && Trig.getVelocity(x - this.vehicle.field_70165_t, y - this.vehicle.field_70163_u, z - this.vehicle.field_70161_v) >= 0.25f) {
            fMot = 1;
        }
        this.forwardInput = fMot;
        this.turnInput = (byte)sMot;
    }

    public void stopMotion() {
        this.clearInputFromDismount();
        this.vehicle.field_70159_w = 0.0;
        this.vehicle.field_70181_x = 0.0;
        this.vehicle.field_70179_y = 0.0;
        this.turnMotion = 0.0f;
    }

    public void clearInputFromDismount() {
        this.forwardInput = 0;
        this.turnInput = 0;
        this.powerInput = 0;
        this.rotationInput = 0;
        this.throttle = 0.0f;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74774_a("fi", this.forwardInput);
        tag.func_74774_a("si", this.turnInput);
        tag.func_74774_a("pi", this.powerInput);
        tag.func_74774_a("ri", this.rotationInput);
        tag.func_74776_a("tr", this.throttle);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        this.forwardInput = tag.func_74771_c("fi");
        this.turnInput = tag.func_74771_c("si");
        this.powerInput = tag.func_74771_c("pi");
        this.rotationInput = tag.func_74771_c("ri");
        this.throttle = tag.func_74760_g("tr");
    }
}

