/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.util.Trig;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleBase;
import net.shadowmage.ancientwarfare.vehicle.gui.GuiVehicleInventory;

public class GuiVehicleStats
extends GuiContainerBase<DummyContainer> {
    private VehicleBase vehicle;
    private GuiVehicleInventory parent;
    private static final DummyContainer DUMMY_CONTAINER = new DummyContainer((EntityPlayer)Minecraft.func_71410_x().field_71439_g);

    public GuiVehicleStats(GuiVehicleInventory parent, VehicleBase vehicle) {
        super(DUMMY_CONTAINER);
        this.vehicle = vehicle;
        this.parent = parent;
        this.shouldCloseOnVanillaKeys = true;
    }

    public int getXSize() {
        return 256;
    }

    public int getYSize() {
        return 240;
    }

    @Override
    public void initElements() {
        this.addGuiElement(new Label(10, 4, "Vehicle Type: " + this.vehicle.vehicleType.getLocalizedName()));
        this.addGuiElement(new Label(10, 14, "Material Level: " + this.vehicle.vehicleMaterialLevel));
        this.addGuiElement(new Label(10, 24, "Health: " + this.vehicle.getHealth() + "/" + this.vehicle.baseHealth));
        this.addGuiElement(new Label(10, 34, "Weight: " + this.vehicle.currentWeight + "/" + this.vehicle.baseWeight));
        this.addGuiElement(new Label(10, 44, "Speed: " + Trig.getVelocity(this.vehicle.field_70159_w, this.vehicle.field_70181_x, this.vehicle.field_70179_y) * 20.0f + "/" + this.vehicle.currentForwardSpeedMax * 20.0f));
        this.addGuiElement(new Label(10, 54, "Missile Velocity: " + this.vehicle.localLaunchPower + "/" + this.vehicle.currentLaunchSpeedPowerMax));
        this.addGuiElement(new Label(10, 64, "Resists: F: " + this.vehicle.currentFireResist + " E: " + this.vehicle.currentExplosionResist + " G: " + this.vehicle.currentGenericResist));
        this.addGuiElement(new Label(10, 74, "Mountable: " + this.vehicle.isMountable()));
        this.addGuiElement(new Label(10, 84, "Drivable: " + this.vehicle.isDrivable()));
        this.addGuiElement(new Label(10, 94, "Combat Vehicle: " + this.vehicle.isAimable()));
        this.addGuiElement(new Label(10, 104, "Rider Sits: " + this.vehicle.shouldRiderSit()));
        this.addGuiElement(new Label(10, 114, "Rider On Turret: " + this.vehicle.vehicleType.moveRiderWithTurret()));
        this.addGuiElement(new Label(10, 124, "Adjustable Yaw: " + this.vehicle.canAimRotate()));
        this.addGuiElement(new Label(10, 134, "Adjustable Pitch: " + this.vehicle.canAimPitch()));
        this.addGuiElement(new Label(10, 144, "Adjustable Power: " + this.vehicle.canAimPower()));
        this.addGuiElement(new Label(10, 154, "Pitch Min: " + this.vehicle.currentTurretPitchMin));
        this.addGuiElement(new Label(10, 164, "Pitch Max: " + this.vehicle.currentTurretPitchMax));
        this.addGuiElement(new Label(10, 174, "Yaw Min: " + (this.vehicle.localTurretRotationHome - this.vehicle.currentTurretRotationMax)));
        this.addGuiElement(new Label(10, 184, "Yaw Max: " + (this.vehicle.localTurretRotationHome + this.vehicle.currentTurretRotationMax)));
        this.addGuiElement(new Label(10, 194, ""));
        this.addGuiElement(new Label(10, 204, "TeamNum: " + (this.vehicle.func_96124_cp() == null ? "" : this.vehicle.func_96124_cp().func_96661_b())));
        this.addGuiElement(new Label(10, 214, ""));
        this.addGuiElement(new Label(10, 224, ""));
    }

    @Override
    public void setupElements() {
    }

    @Override
    protected boolean onGuiCloseRequested() {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)this.parent);
        return false;
    }

    public static class DummyContainer
    extends ContainerBase {
        public DummyContainer(EntityPlayer player) {
            super(player);
        }
    }
}

