/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.entity.types;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.shadowmage.ancientwarfare.vehicle.config.AWVehicleStatics;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleBase;
import net.shadowmage.ancientwarfare.vehicle.entity.materials.VehicleMaterial;
import net.shadowmage.ancientwarfare.vehicle.entity.types.VehicleType;
import net.shadowmage.ancientwarfare.vehicle.helpers.VehicleFiringVarsHelper;
import net.shadowmage.ancientwarfare.vehicle.registry.ArmorRegistry;
import net.shadowmage.ancientwarfare.vehicle.registry.UpgradeRegistry;

public class VehicleTypeChestCart
extends VehicleType {
    public VehicleTypeChestCart(int typeNum) {
        super(typeNum);
        this.configName = "chest_cart";
        this.vehicleMaterial = VehicleMaterial.materialWood;
        this.materialCount = 3;
        this.baseHealth = AWVehicleStatics.vehicleStats.vehicleChestCartHealth;
        this.validArmors.add(ArmorRegistry.armorStone);
        this.validArmors.add(ArmorRegistry.armorObsidian);
        this.validArmors.add(ArmorRegistry.armorIron);
        this.validUpgrades.add(UpgradeRegistry.speedUpgrade);
        this.width = 2.7f;
        this.height = 1.8f;
        this.mountable = true;
        this.drivable = true;
        this.combatEngine = false;
        this.riderSits = false;
        this.pilotableBySoldiers = false;
        this.riderVerticalOffset = 0.35f;
        this.riderForwardsOffset = 2.85f;
        this.baseForwardSpeed = 0.185f;
        this.baseStrafeSpeed = 1.75f;
        this.ammoBaySize = 0;
        this.upgradeBaySize = 6;
        this.armorBaySize = 6;
        this.storageBaySize = 216;
        this.displayName = "item.vehicleSpawner.17";
        this.displayTooltip.add("item.vehicleSpawner.tooltip.noweapon");
        this.displayTooltip.add("item.vehicleSpawner.tooltip.mobile");
        this.displayTooltip.add("item.vehicleSpawner.tooltip.noturret");
        this.displayTooltip.add("item.vehicleSpawner.tooltip.storage");
    }

    @Override
    public VehicleFiringVarsHelper getFiringVarsHelper(VehicleBase veh) {
        return new ChestCartVarHelper(veh);
    }

    @Override
    public ResourceLocation getTextureForMaterialLevel(int level) {
        switch (level) {
            case 0: {
                return new ResourceLocation("ancientwarfare", "textures/model/vehicle/chest_cart_1.png");
            }
            case 1: {
                return new ResourceLocation("ancientwarfare", "textures/model/vehicle/chest_cart_2.png");
            }
            case 2: {
                return new ResourceLocation("ancientwarfare", "textures/model/vehicle/chest_cart_3.png");
            }
            case 3: {
                return new ResourceLocation("ancientwarfare", "textures/model/vehicle/chest_cart_4.png");
            }
            case 4: {
                return new ResourceLocation("ancientwarfare", "textures/model/vehicle/chest_cart_5.png");
            }
        }
        return new ResourceLocation("ancientwarfare", "textures/model/vehicle/chest_cart_1.png");
    }

    public class ChestCartVarHelper
    extends VehicleFiringVarsHelper {
        public ChestCartVarHelper(VehicleBase vehicle) {
            super(vehicle);
        }

        public NBTTagCompound serializeNBT() {
            return new NBTTagCompound();
        }

        public void deserializeNBT(NBTTagCompound tag) {
        }

        @Override
        public void onFiringUpdate() {
        }

        @Override
        public void onReloadUpdate() {
        }

        @Override
        public void onLaunchingUpdate() {
        }

        @Override
        public void onReloadingFinished() {
        }

        @Override
        public float getVar1() {
            return 0.0f;
        }

        @Override
        public float getVar2() {
            return 0.0f;
        }

        @Override
        public float getVar3() {
            return 0.0f;
        }

        @Override
        public float getVar4() {
            return 0.0f;
        }

        @Override
        public float getVar5() {
            return 0.0f;
        }

        @Override
        public float getVar6() {
            return 0.0f;
        }

        @Override
        public float getVar7() {
            return 0.0f;
        }

        @Override
        public float getVar8() {
            return 0.0f;
        }
    }
}

