/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.entity;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.shadowmage.ancientwarfare.core.owner.IOwnable;
import net.shadowmage.ancientwarfare.core.owner.Owner;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.core.util.MathUtils;
import net.shadowmage.ancientwarfare.core.util.Trig;
import net.shadowmage.ancientwarfare.npc.config.AWNPCStatics;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFactionSiegeEngineer;
import net.shadowmage.ancientwarfare.vehicle.AncientWarfareVehicles;
import net.shadowmage.ancientwarfare.vehicle.VehicleVarHelpers.DummyVehicleHelper;
import net.shadowmage.ancientwarfare.vehicle.armors.IVehicleArmor;
import net.shadowmage.ancientwarfare.vehicle.entity.IMissileHitCallback;
import net.shadowmage.ancientwarfare.vehicle.entity.IPathableEntity;
import net.shadowmage.ancientwarfare.vehicle.entity.IVehicleType;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleMovementType;
import net.shadowmage.ancientwarfare.vehicle.entity.materials.IVehicleMaterial;
import net.shadowmage.ancientwarfare.vehicle.entity.types.VehicleType;
import net.shadowmage.ancientwarfare.vehicle.helpers.VehicleAmmoHelper;
import net.shadowmage.ancientwarfare.vehicle.helpers.VehicleFiringHelper;
import net.shadowmage.ancientwarfare.vehicle.helpers.VehicleFiringVarsHelper;
import net.shadowmage.ancientwarfare.vehicle.helpers.VehicleMoveHelper;
import net.shadowmage.ancientwarfare.vehicle.helpers.VehicleUpgradeHelper;
import net.shadowmage.ancientwarfare.vehicle.inventory.VehicleInventory;
import net.shadowmage.ancientwarfare.vehicle.missiles.IAmmo;
import net.shadowmage.ancientwarfare.vehicle.pathing.Navigator;
import net.shadowmage.ancientwarfare.vehicle.pathing.Node;
import net.shadowmage.ancientwarfare.vehicle.pathing.PathWorldAccessEntity;
import net.shadowmage.ancientwarfare.vehicle.registry.VehicleRegistry;
import net.shadowmage.ancientwarfare.vehicle.upgrades.IVehicleUpgradeType;

public class VehicleBase
extends Entity
implements IEntityAdditionalSpawnData,
IMissileHitCallback,
IPathableEntity,
IOwnable {
    private static final DataParameter<Float> VEHICLE_HEALTH = EntityDataManager.func_187226_a(VehicleBase.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Byte> FORWARD_INPUT = EntityDataManager.func_187226_a(VehicleBase.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> STRAFE_INPUT = EntityDataManager.func_187226_a(VehicleBase.class, (DataSerializer)DataSerializers.field_187191_a);
    public float baseForwardSpeed;
    public float baseStrafeSpeed;
    public float basePitchMin;
    public float basePitchMax;
    private float baseTurretRotationMax;
    private float baseLaunchSpeedMax;
    public float baseHealth = 100.0f;
    private float baseAccuracy = 1.0f;
    public float baseWeight = 1000.0f;
    private int baseReloadTicks = 100;
    private float baseGenericResist = 0.0f;
    private float baseFireResist = 0.0f;
    private float baseExplosionResist = 0.0f;
    private int hurtInvulTicks = 0;
    public float currentForwardSpeedMax = 0.42f;
    public float currentStrafeSpeedMax = 2.0f;
    public int currentReloadTicks = 100;
    public float currentTurretPitchMin = 0.0f;
    public float currentTurretPitchMax = 90.0f;
    public float currentLaunchSpeedPowerMax = 32.321f;
    public float currentGenericResist = 0.0f;
    public float currentFireResist = 0.0f;
    public float currentExplosionResist = 0.0f;
    public float currentWeight = 1000.0f;
    public float currentTurretPitchSpeed = 0.0f;
    public float currentTurretYawSpeed = 0.0f;
    public float currentAccuracy = 1.0f;
    public float currentTurretRotationMax = 45.0f;
    public float localTurretRotationHome = 0.0f;
    public float localTurretRotation = 0.0f;
    public float localTurretDestRot = 0.0f;
    private float localTurretRotInc = 1.0f;
    public float localTurretPitch = 45.0f;
    public float localTurretDestPitch = 45.0f;
    private float localTurretPitchInc = 1.0f;
    public float localLaunchPower = 31.321f;
    public float wheelRotation = 0.0f;
    public float wheelRotationPrev = 0.0f;
    private boolean isSettingUp = false;
    public int hitAnimationTicks = 0;
    private NpcBase assignedRider = null;
    public VehicleAmmoHelper ammoHelper;
    public VehicleUpgradeHelper upgradeHelper;
    public VehicleMoveHelper moveHelper;
    public VehicleFiringHelper firingHelper;
    public VehicleFiringVarsHelper firingVarsHelper;
    public VehicleInventory inventory;
    public Navigator nav;
    public PathWorldAccessEntity worldAccess;
    public IVehicleType vehicleType = VehicleRegistry.CATAPULT_STAND_FIXED;
    public int vehicleMaterialLevel = 0;
    private Owner owner = Owner.EMPTY;
    private int setupTicks = 0;

    public VehicleBase(World par1World) {
        super(par1World);
        this.upgradeHelper = new VehicleUpgradeHelper(this);
        this.moveHelper = new VehicleMoveHelper(this);
        this.ammoHelper = new VehicleAmmoHelper(this);
        this.firingHelper = new VehicleFiringHelper(this);
        this.firingVarsHelper = new DummyVehicleHelper(this);
        this.inventory = new VehicleInventory(this);
        this.worldAccess = new PathWorldAccessEntity(par1World, this);
        this.nav = new Navigator(this);
        this.nav.setStuckCheckTicks(100);
        this.field_70138_W = 1.12f;
        this.field_70144_Y = 0.9f;
        this.field_70122_E = false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(VEHICLE_HEALTH, (Object)Float.valueOf(100.0f));
        this.field_70180_af.func_187214_a(FORWARD_INPUT, (Object)0);
        this.field_70180_af.func_187214_a(STRAFE_INPUT, (Object)0);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return this.vehicleType.getStackForLevel(this.vehicleMaterialLevel);
    }

    public float func_70047_e() {
        return 1.6f;
    }

    public void setHealth(float health) {
        if (health > this.baseHealth) {
            health = this.baseHealth;
        }
        this.field_70180_af.func_187227_b(VEHICLE_HEALTH, (Object)Float.valueOf(health));
    }

    public boolean canTurretTurn() {
        return !MathUtils.epsilonEquals(this.baseTurretRotationMax, 0.0f);
    }

    public float getHealth() {
        return ((Float)this.field_70180_af.func_187225_a(VEHICLE_HEALTH)).floatValue();
    }

    public void setVehicleType(IVehicleType vehicle, int materialLevel) {
        this.vehicleType = vehicle;
        this.vehicleMaterialLevel = materialLevel;
        VehicleFiringVarsHelper help = vehicle.getFiringVarsHelper(this);
        if (help != null) {
            this.firingVarsHelper = help;
        }
        float width = this.vehicleType.getWidth();
        float height = this.vehicleType.getHeight();
        this.func_70105_a(width, height);
        for (IAmmo ammo : this.vehicleType.getValidAmmoTypes()) {
            this.ammoHelper.addUseableAmmo(ammo);
        }
        for (IVehicleUpgradeType up : this.vehicleType.getValidUpgrades()) {
            this.upgradeHelper.addValidUpgrade(up);
        }
        for (IVehicleArmor armor : this.vehicleType.getValidArmors()) {
            this.upgradeHelper.addValidArmor(armor);
        }
        this.inventory.setInventorySizes(vehicle.getUpgradeBaySize(), vehicle.getAmmoBaySize(), vehicle.getArmorBaySize(), vehicle.getStorageBaySize());
        this.updateBaseStats();
        this.resetCurrentStats();
        if (this.localTurretPitch < this.currentTurretPitchMin) {
            this.localTurretPitch = this.currentTurretPitchMin;
        } else if (this.localTurretPitch > this.currentTurretPitchMax) {
            this.localTurretPitch = this.currentTurretPitchMax;
        }
        this.localLaunchPower = this.firingHelper.getAdjustedMaxMissileVelocity();
        if (!this.canAimRotate()) {
            this.localTurretRotation = this.field_70177_z;
        }
        this.nav.setCanGoOnLand(this.vehicleType.getMovementType() == VehicleMovementType.GROUND);
    }

    public void setSetupState(boolean state, int ticks) {
        this.isSettingUp = state;
        this.setupTicks = state ? ticks : 0;
    }

    public void setInitialHealth() {
        this.setHealth(this.baseHealth);
    }

    private void updateBaseStats() {
        IVehicleMaterial material = this.vehicleType.getMaterialType();
        int level = this.vehicleMaterialLevel;
        this.baseForwardSpeed = this.vehicleType.getBaseForwardSpeed() * material.getSpeedForwardFactor(level);
        this.baseStrafeSpeed = this.vehicleType.getBaseStrafeSpeed() * material.getSpeedStrafeFactor(level);
        this.basePitchMin = this.vehicleType.getBasePitchMin();
        this.basePitchMax = this.vehicleType.getBasePitchMax();
        this.baseTurretRotationMax = this.vehicleType.getBaseTurretRotationAmount();
        this.baseLaunchSpeedMax = this.vehicleType.getBaseMissileVelocityMax();
        this.baseHealth = this.vehicleType.getBaseHealth() * material.getHPFactor(level);
        this.baseAccuracy = this.vehicleType.getBaseAccuracy() * material.getAccuracyFactor(level);
        this.baseWeight = this.vehicleType.getBaseWeight() * material.getWeightFactor(level);
        this.baseExplosionResist = 0.0f;
        this.baseFireResist = 0.0f;
        this.baseGenericResist = 0.0f;
        if (this.getHealth() > this.baseHealth) {
            this.setHealth(this.baseHealth);
        }
    }

    public void func_70100_b_(EntityPlayer par1EntityPlayer) {
        super.func_70100_b_(par1EntityPlayer);
        if (!this.field_70170_p.field_72995_K && par1EntityPlayer instanceof EntityPlayerMP && par1EntityPlayer.field_70163_u > this.field_70163_u && ((EntityPlayerMP)par1EntityPlayer).field_70124_G) {
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)par1EntityPlayer;
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    private ItemStack getItemForVehicle() {
        ItemStack stack = this.vehicleType.getStackForLevel(this.vehicleMaterialLevel);
        stack.func_77978_p().func_74775_l("spawnData").func_74776_a("health", this.getHealth());
        return stack;
    }

    private float getHorizontalMissileOffset() {
        return this.vehicleType.getMissileHorizontalOffset();
    }

    private float getVerticalMissileOffset() {
        return this.vehicleType.getMissileVerticalOffset();
    }

    private float getForwardsMissileOffset() {
        return this.vehicleType.getMissileForwardsOffset();
    }

    public boolean isAimable() {
        return !this.isSettingUp && this.vehicleType.isCombatEngine();
    }

    public boolean canAimRotate() {
        return !this.isSettingUp && this.vehicleType.canAdjustYaw();
    }

    public boolean canAimPitch() {
        return !this.isSettingUp && this.vehicleType.canAdjustPitch();
    }

    public boolean canAimPower() {
        return !this.isSettingUp && this.vehicleType.canAdjustPower();
    }

    public boolean isDrivable() {
        return !this.isSettingUp && this.vehicleType.isDrivable();
    }

    public boolean isMountable() {
        return !this.isSettingUp && this.vehicleType.isMountable();
    }

    private float getRiderForwardOffset() {
        return this.vehicleType.getRiderForwardsOffset();
    }

    public float getRiderVerticalOffset() {
        return this.vehicleType.getRiderVerticalOffest();
    }

    private float getRiderHorizontalOffset() {
        return this.vehicleType.getRiderHorizontalOffset();
    }

    public float getEffectiveRange(float verticalOffset) {
        if (this.vehicleType == VehicleRegistry.BATTERING_RAM) {
            return 1.5f;
        }
        float angle = this.currentTurretPitchMin < 45.0f && this.currentTurretPitchMax > 45.0f ? 45.0f : (this.currentTurretPitchMin < 45.0f && this.currentTurretPitchMax < 45.0f ? this.currentTurretPitchMax : this.currentTurretPitchMin);
        return this.getEffectiveRange(verticalOffset, angle, this.firingHelper.getAdjustedMaxMissileVelocity(), 0, this.ammoHelper.getCurrentAmmoType() != null && this.ammoHelper.getCurrentAmmoType().isRocket());
    }

    private float getEffectiveRange(float y, float angle, float velocity, int maxIterations, boolean rocket) {
        float tMinus;
        float tQ;
        float gravity;
        float t;
        float tPlus;
        float motX = Trig.sinDegrees(angle) * velocity * 0.05f;
        float motY = Trig.cosDegrees(angle) * velocity * 0.05f;
        float rocketX = 0.0f;
        float rocketY = 0.0f;
        if (rocket) {
            int rocketBurnTime = (int)(velocity * 3.0f);
            float motX0 = motX / (velocity * 0.05f) * 0.01f;
            float motY0 = motY / (velocity * 0.05f) * 0.01f;
            motX = motX0;
            motY = motY0;
            while (rocketBurnTime > 0) {
                rocketX += motX;
                rocketY += motY;
                --rocketBurnTime;
                motX += motX0;
                motY += motY0;
            }
            y -= rocketY;
        }
        t = (tPlus = (t = (motY *= 20.0f) / (gravity = 9.81f)) + (tQ = MathHelper.func_76129_c((float)(motY * motY / (gravity * gravity) - 2.0f * y / gravity)))) > (tMinus = t - tQ) ? tPlus : tMinus;
        return (motX *= 20.0f) * t + rocketX;
    }

    public Vec3d getMissileOffset() {
        float x1 = this.vehicleType.getTurretPosX();
        float y1 = this.vehicleType.getTurretPosY();
        float z1 = this.vehicleType.getTurretPosZ();
        float angle = 0.0f;
        float len = 0.0f;
        if (x1 != 0.0f || z1 != 0.0f) {
            angle = Trig.toDegrees((float)Math.atan2(z1, x1));
            len = MathHelper.func_76129_c((float)(x1 * x1 + z1 * z1));
            x1 = Trig.cosDegrees(angle += this.field_70177_z) * len;
            z1 = -Trig.sinDegrees(angle) * len;
        }
        float x = this.getHorizontalMissileOffset();
        float y = this.getVerticalMissileOffset();
        float z = this.getForwardsMissileOffset();
        if (x != 0.0f || z != 0.0f || y != 0.0f) {
            angle = Trig.toDegrees((float)Math.atan2(z, x));
            len = MathHelper.func_76129_c((float)(x * x + z * z + y * y));
            x = Trig.cosDegrees(angle += this.localTurretRotation) * Trig.sinDegrees(this.localTurretPitch + this.field_70125_A) * len;
            z = -Trig.sinDegrees(angle) * Trig.sinDegrees(this.localTurretPitch + this.field_70125_A) * len;
            y = Trig.cosDegrees(this.localTurretPitch + this.field_70125_A) * len;
        }
        return new Vec3d((double)(x += x1), (double)(y += y1), (double)(z += z1));
    }

    public void onFiringUpdate() {
        this.firingVarsHelper.onFiringUpdate();
    }

    public void onReloadUpdate() {
        this.firingVarsHelper.onReloadUpdate();
    }

    protected void func_145775_I() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        BlockPos.PooledMutableBlockPos posMin = BlockPos.PooledMutableBlockPos.func_185345_c((double)(axisalignedbb.field_72340_a + 0.001), (double)(axisalignedbb.field_72338_b + 0.001), (double)(axisalignedbb.field_72339_c + 0.001));
        BlockPos.PooledMutableBlockPos posMax = BlockPos.PooledMutableBlockPos.func_185345_c((double)(axisalignedbb.field_72336_d - 0.001), (double)(axisalignedbb.field_72337_e - 0.001), (double)(axisalignedbb.field_72334_f - 0.001));
        BlockPos.PooledMutableBlockPos currentPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        if (this.field_70170_p.func_175707_a((BlockPos)posMin, (BlockPos)posMax)) {
            for (int i = posMin.func_177958_n(); i <= posMax.func_177958_n(); ++i) {
                for (int j = posMin.func_177956_o(); j <= posMax.func_177956_o(); ++j) {
                    for (int k = posMin.func_177952_p(); k <= posMax.func_177952_p(); ++k) {
                        currentPos.func_181079_c(i, j, k);
                        IBlockState iblockstate = this.field_70170_p.func_180495_p((BlockPos)currentPos);
                        try {
                            iblockstate.func_177230_c().func_180634_a(this.field_70170_p, (BlockPos)currentPos, iblockstate, (Entity)this);
                            this.onInsideBlock(iblockstate, (BlockPos)currentPos);
                            continue;
                        }
                        catch (Throwable throwable) {
                            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Colliding entity with block");
                            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being collided with");
                            CrashReportCategory.func_175750_a((CrashReportCategory)crashreportcategory, (BlockPos)currentPos, (IBlockState)iblockstate);
                            throw new ReportedException(crashreport);
                        }
                    }
                }
            }
        }
        posMin.func_185344_t();
        posMax.func_185344_t();
        currentPos.func_185344_t();
    }

    protected void onInsideBlock(IBlockState state, BlockPos pos) {
        if (state.func_177230_c() == Blocks.field_150392_bi) {
            this.field_70170_p.func_175655_b(new BlockPos((Vec3i)pos), true);
        }
    }

    public void onLaunchingUpdate() {
        this.firingVarsHelper.onLaunchingUpdate();
    }

    public void resetCurrentStats() {
        this.currentForwardSpeedMax = this.baseForwardSpeed;
        this.currentStrafeSpeedMax = this.baseStrafeSpeed;
        this.currentTurretPitchMin = this.basePitchMin;
        this.currentTurretPitchMax = this.basePitchMax;
        this.currentTurretRotationMax = this.baseTurretRotationMax;
        this.currentReloadTicks = this.baseReloadTicks;
        this.currentLaunchSpeedPowerMax = this.baseLaunchSpeedMax;
        this.currentExplosionResist = this.baseExplosionResist;
        this.currentFireResist = this.baseFireResist;
        this.currentGenericResist = this.baseGenericResist;
        this.currentWeight = this.baseWeight;
        this.currentAccuracy = this.baseAccuracy;
    }

    public void func_70106_y() {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L && this.getHealth() <= 0.0f) {
            InventoryTools.dropItemsInWorld(this.field_70170_p, (IItemHandler)this.inventory.ammoInventory, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            InventoryTools.dropItemsInWorld(this.field_70170_p, (IItemHandler)this.inventory.armorInventory, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            InventoryTools.dropItemsInWorld(this.field_70170_p, (IItemHandler)this.inventory.upgradeInventory, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            InventoryTools.dropItemsInWorld(this.field_70170_p, (IItemHandler)this.inventory.storageInventory, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        super.func_70106_y();
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.onUpdateClient();
        } else {
            this.onUpdateServer();
        }
        this.updateTurretPitch();
        this.updateTurretRotation();
        this.moveHelper.onUpdate();
        this.firingHelper.onTick();
        this.firingVarsHelper.onTick();
        if (this.hitAnimationTicks > 0) {
            --this.hitAnimationTicks;
        }
        if (this.isSettingUp) {
            --this.setupTicks;
            if (this.setupTicks <= 0) {
                this.isSettingUp = false;
            }
        }
        if (this.hurtInvulTicks > 0) {
            --this.hurtInvulTicks;
        }
        if (this.assignedRider != null && (this.assignedRider.field_70128_L || this.assignedRider.func_184187_bx() != this || !this.assignedRider.func_184218_aH() || this.assignedRider.func_184187_bx() != this || this.func_70068_e((Entity)this.assignedRider) > (double)(AWNPCStatics.npcActionRange * AWNPCStatics.npcActionRange))) {
            this.assignedRider = null;
        }
    }

    private void onUpdateClient() {
        if (this.func_184179_bs() instanceof NpcBase) {
            this.func_184232_k(this.func_184179_bs());
        }
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        if (super.func_184205_a(entity, force)) {
            if (entity instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)entity;
                player.field_71075_bZ.field_75101_c = true;
            }
            return true;
        }
        return false;
    }

    private void onUpdateServer() {
        EntityPlayerMP player;
        if (this.func_184179_bs() instanceof EntityPlayerMP && (player = (EntityPlayerMP)this.func_184179_bs()).func_70093_af()) {
            this.handleDismount((EntityLivingBase)player);
            player.func_70095_a(false);
        }
    }

    private void handleDismount(EntityLivingBase rider) {
        int xMin = MathHelper.func_76128_c((double)(this.field_70165_t - (double)(this.field_70130_N / 2.0f)));
        int zMin = MathHelper.func_76128_c((double)(this.field_70161_v - (double)(this.field_70130_N / 2.0f)));
        int yMin = MathHelper.func_76128_c((double)this.field_70163_u) - 2;
        if (rider instanceof EntityPlayerMP) {
            ((EntityPlayerMP)rider).field_71075_bZ.field_75101_c = false;
        }
        rider.func_184210_p();
        block0: for (int y = yMin; y <= yMin + 3; ++y) {
            for (int x = xMin; x <= xMin + (int)this.field_70130_N; ++x) {
                for (int z = zMin; z <= zMin + (int)this.field_70130_N; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    IBlockState state = this.field_70170_p.func_180495_p(pos);
                    if (!state.isSideSolid((IBlockAccess)this.field_70170_p, pos, EnumFacing.UP) && state.func_185904_a() != Material.field_151586_h || !this.field_70170_p.func_175623_d(pos.func_177984_a()) || !this.field_70170_p.func_175623_d(pos.func_177984_a().func_177984_a())) continue;
                    rider.func_70634_a((double)x + 0.5, (double)(y + 1), (double)z + 0.5);
                    break block0;
                }
            }
        }
    }

    private void updateTurretPitch() {
        float prevPitch = this.localTurretPitch;
        if (!Trig.isAngleBetween(this.localTurretPitch, this.currentTurretPitchMin, this.currentTurretPitchMax)) {
            this.localTurretPitch = this.currentTurretPitchMin;
        }
        if (!Trig.isAngleBetween(this.localTurretDestPitch, this.currentTurretPitchMin, this.currentTurretPitchMax)) {
            this.localTurretDestPitch = this.currentTurretPitchMin;
        }
        if (!this.canAimPitch()) {
            this.localTurretDestPitch = this.localTurretPitch;
        }
        if (!Trig.anglesEqual(this.localTurretPitch, this.localTurretDestPitch)) {
            this.localTurretPitch = Math.abs(Trig.getAngleDiffSigned(this.localTurretDestPitch, this.localTurretPitch)) < this.localTurretPitchInc ? this.localTurretDestPitch : (this.localTurretPitch += Trig.getAngleDiffSigned(this.localTurretPitch, this.localTurretDestPitch) > 0.0f ? this.localTurretPitchInc : -this.localTurretPitchInc);
        }
        this.currentTurretPitchSpeed = prevPitch - this.localTurretPitch;
    }

    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (passenger instanceof NpcFactionSiegeEngineer) {
            this.currentTurretPitchMin = this.vehicleType.getBasePitchMin() - 12.0f;
            this.currentTurretPitchMax = this.vehicleType.getBasePitchMax() + 12.0f;
        }
    }

    protected void func_184225_p(Entity passenger) {
        super.func_184225_p(passenger);
        if (passenger instanceof NpcFactionSiegeEngineer) {
            this.upgradeHelper.updateUpgradeStats();
        }
    }

    private void updateTurretRotation() {
        float prevYaw = this.localTurretRotation;
        this.localTurretRotationHome = Trig.wrapTo360(this.field_70177_z);
        if (!this.canAimRotate()) {
            this.localTurretDestRot = this.localTurretRotation = Trig.wrapTo360(this.field_70177_z);
        }
        if (Math.abs(this.localTurretDestRot - this.localTurretRotation) > this.localTurretRotInc) {
            while (this.localTurretRotation < 0.0f) {
                this.localTurretRotation += 360.0f;
                prevYaw += 360.0f;
            }
            while (this.localTurretRotation >= 360.0f) {
                this.localTurretRotation -= 360.0f;
                prevYaw -= 360.0f;
            }
            this.localTurretDestRot = Trig.wrapTo360(this.localTurretDestRot);
            float curMod = this.localTurretRotation;
            float destMod = this.localTurretDestRot;
            float diff = curMod > destMod ? curMod - destMod : destMod - curMod;
            float turnDir = 0.0f;
            if (curMod > destMod) {
                turnDir = diff < 180.0f ? -1.0f : 1.0f;
            } else if (curMod < destMod) {
                turnDir = diff < 180.0f ? 1.0f : -1.0f;
            }
            this.localTurretRotation += this.localTurretRotInc * turnDir;
        } else {
            this.localTurretRotation = this.localTurretDestRot;
        }
        if (Math.abs(this.localTurretDestRot - this.localTurretRotation) < this.localTurretRotInc) {
            this.localTurretRotation = this.localTurretDestRot;
        }
        this.currentTurretYawSpeed = this.localTurretRotation - prevYaw;
        if (this.currentTurretYawSpeed > 180.0f) {
            this.currentTurretYawSpeed -= 360.0f;
        }
        if (this.currentTurretYawSpeed < -180.0f) {
            this.currentTurretYawSpeed += 360.0f;
        }
    }

    public void updateTurretAngles(float pitch, float rotation) {
        this.localTurretPitch = pitch;
        this.localTurretRotation = rotation;
        this.localTurretDestPitch = this.localTurretPitch;
        this.localTurretDestRot = this.localTurretRotation;
    }

    public void packVehicle() {
        if (!this.field_70170_p.field_72995_K) {
            InventoryTools.dropItemInWorld(this.field_70170_p, this.getItemForVehicle(), this.field_70165_t, this.field_70163_u, this.field_70161_v);
            InventoryTools.dropItemsInWorld(this.field_70170_p, (IItemHandler)this.inventory.ammoInventory, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            InventoryTools.dropItemsInWorld(this.field_70170_p, (IItemHandler)this.inventory.armorInventory, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            InventoryTools.dropItemsInWorld(this.field_70170_p, (IItemHandler)this.inventory.upgradeInventory, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            InventoryTools.dropItemsInWorld(this.field_70170_p, (IItemHandler)this.inventory.storageInventory, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_70106_y();
        }
    }

    public boolean func_70097_a(DamageSource damageSource, float amount) {
        if (!damageSource.func_94541_c()) {
            if (this.hurtInvulTicks > 0) {
                return false;
            }
            this.hurtInvulTicks = 10;
        }
        if (this.field_70170_p.field_72995_K) {
            this.hitAnimationTicks = 20;
            return false;
        }
        super.func_70097_a(damageSource, amount);
        float adjDmg = this.upgradeHelper.getScaledDamage(damageSource, amount);
        this.setHealth(this.getHealth() - adjDmg);
        if (this.getHealth() <= 0.0f) {
            this.func_70106_y();
            return false;
        }
        return true;
    }

    public void func_70108_f(Entity entity) {
        double zDiff;
        double xDiff;
        double entityDistance;
        if (entity != this.func_184179_bs() && !(entity instanceof NpcBase) && (entityDistance = MathHelper.func_76132_a((double)(xDiff = entity.field_70165_t - this.field_70165_t), (double)(zDiff = entity.field_70161_v - this.field_70161_v))) >= (double)0.01f) {
            entityDistance = Math.sqrt(entityDistance);
            xDiff /= entityDistance;
            zDiff /= entityDistance;
            double normalizeToDistance = 1.0 / entityDistance;
            if (normalizeToDistance > 1.0) {
                normalizeToDistance = 1.0;
            }
            xDiff *= normalizeToDistance;
            zDiff *= normalizeToDistance;
            xDiff *= (double)0.05f;
            zDiff *= (double)0.05f;
            this.func_70024_g(-(xDiff *= (double)(1.0f - this.field_70144_Y)), 0.0, -(zDiff *= (double)(1.0f - this.field_70144_Y)));
            entity.func_70024_g(xDiff, 0.0, zDiff);
        }
    }

    public ResourceLocation getTexture() {
        return this.vehicleType.getTextureForMaterialLevel(this.vehicleMaterialLevel);
    }

    public void func_184232_k(Entity passenger) {
        double posX = this.field_70165_t;
        double posY = this.field_70163_u + (double)this.getRiderVerticalOffset();
        double posZ = this.field_70161_v;
        float yaw = this.vehicleType.moveRiderWithTurret() ? this.localTurretRotation : this.field_70177_z;
        posX += (double)(Trig.sinDegrees(yaw) * -this.getRiderForwardOffset());
        posX += (double)(Trig.sinDegrees(yaw + 90.0f) * this.getRiderHorizontalOffset());
        posZ += (double)(Trig.cosDegrees(yaw) * -this.getRiderForwardOffset());
        posZ += (double)(Trig.cosDegrees(yaw + 90.0f) * this.getRiderHorizontalOffset());
        if (this.vehicleType.shouldRiderSit()) {
            passenger.field_70131_O = 1.3f;
        }
        if (passenger instanceof NpcBase) {
            passenger.func_70080_a(posX, posY + passenger.func_70033_W(), posZ, 180.0f - this.localTurretRotation, passenger.field_70125_A);
            passenger.func_181013_g(180.0f - this.localTurretRotation);
        } else {
            passenger.func_70107_b(posX, posY + passenger.func_70033_W(), posZ);
            passenger.field_70177_z -= this.moveHelper.getRotationSpeed();
        }
        if (this.vehicleType.shouldRiderSit()) {
            passenger.func_174826_a(passenger.func_174813_aQ().func_72317_d(0.0, 0.6, 0.0));
        }
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (this.isSettingUp) {
            if (!player.field_70170_p.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString("Vehicle is currently being set-up.  It has " + this.setupTicks + " ticks remaining."));
            }
            return false;
        }
        return this.firingVarsHelper.interact(player);
    }

    public String toString() {
        return String.format("%s::%s @ %.2f, %.2f, %.2f  -- y:%.2f p:%.2f -- m: %.2f, %.2f, %.2f", this.vehicleType.getDisplayName(), this.func_145782_y(), this.field_70165_t, this.field_70163_u, this.field_70161_v, Float.valueOf(this.field_70177_z), Float.valueOf(this.field_70125_A), this.field_70159_w, this.field_70181_x, this.field_70179_y);
    }

    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
    }

    public void func_70024_g(double par1, double par3, double par5) {
        super.func_70024_g(par1, par3, par5);
    }

    public void func_70016_h(double par1, double par3, double par5) {
    }

    public boolean shouldRiderSit() {
        return this.vehicleType.shouldRiderSit();
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public boolean func_70067_L() {
        return true;
    }

    public void writeSpawnData(ByteBuf buffer) {
        PacketBuffer pb = new PacketBuffer(buffer);
        pb.writeFloat(this.getHealth());
        pb.writeInt(this.vehicleType.getGlobalVehicleType());
        pb.writeInt(this.vehicleMaterialLevel);
        pb.func_150786_a(this.upgradeHelper.serializeNBT());
        pb.func_150786_a(this.ammoHelper.serializeNBT());
        pb.func_150786_a(this.moveHelper.serializeNBT());
        pb.func_150786_a(this.firingHelper.serializeNBT());
        pb.func_150786_a((NBTTagCompound)this.firingVarsHelper.serializeNBT());
        pb.writeFloat(this.localLaunchPower);
        pb.writeFloat(this.localTurretPitch);
        pb.writeFloat(this.localTurretRotation);
        pb.writeFloat(this.localTurretDestPitch);
        pb.writeFloat(this.localTurretDestRot);
        this.owner.serializeToBuffer(buffer);
        pb.writeFloat(this.localTurretRotationHome);
        pb.writeBoolean(this.isSettingUp);
        if (this.isSettingUp) {
            pb.writeInt(this.setupTicks);
        }
    }

    public void readSpawnData(ByteBuf additionalData) {
        PacketBuffer pb = new PacketBuffer(additionalData);
        this.setHealth(pb.readFloat());
        IVehicleType type = VehicleType.getVehicleType(pb.readInt());
        this.setVehicleType(type, pb.readInt());
        try {
            this.upgradeHelper.deserializeNBT(pb.func_150793_b());
            this.ammoHelper.deserializeNBT(pb.func_150793_b());
            this.moveHelper.deserializeNBT(pb.func_150793_b());
            this.firingHelper.deserializeNBT(pb.func_150793_b());
            this.firingVarsHelper.deserializeNBT((NBTBase)pb.func_150793_b());
        }
        catch (IOException e) {
            AncientWarfareVehicles.LOG.error((Object)e);
        }
        this.localLaunchPower = pb.readFloat();
        this.localTurretPitch = pb.readFloat();
        this.localTurretRotation = pb.readFloat();
        this.localTurretDestPitch = pb.readFloat();
        this.localTurretDestRot = pb.readFloat();
        this.firingHelper.clientLaunchSpeed = this.localLaunchPower;
        this.firingHelper.clientTurretPitch = this.localTurretPitch;
        this.firingHelper.clientTurretYaw = this.localTurretRotation;
        this.upgradeHelper.updateUpgradeStats();
        this.owner = new Owner(additionalData);
        this.localTurretRotationHome = pb.readFloat();
        this.isSettingUp = pb.readBoolean();
        if (this.isSettingUp) {
            this.setupTicks = pb.readInt();
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    protected void func_70037_a(NBTTagCompound tag) {
        IVehicleType vehType = VehicleType.getVehicleType(tag.func_74762_e("vehType"));
        int level = tag.func_74762_e("matLvl");
        this.setVehicleType(vehType, level);
        this.setHealth(tag.func_74760_g("health"));
        this.localTurretRotationHome = tag.func_74760_g("turHome");
        this.inventory.readFromNBT(tag);
        this.upgradeHelper.deserializeNBT(tag.func_74775_l("upgrades"));
        this.ammoHelper.deserializeNBT(tag.func_74775_l("ammo"));
        this.moveHelper.deserializeNBT(tag.func_74775_l("move"));
        this.firingHelper.deserializeNBT(tag.func_74775_l("fire"));
        this.firingVarsHelper.deserializeNBT((NBTBase)tag.func_74775_l("vars"));
        this.localLaunchPower = tag.func_74760_g("lc");
        this.localTurretPitch = tag.func_74760_g("tp");
        this.localTurretDestPitch = tag.func_74760_g("tpd");
        this.localTurretRotation = tag.func_74760_g("tr");
        this.localTurretDestRot = tag.func_74760_g("trd");
        this.upgradeHelper.updateUpgrades();
        this.ammoHelper.updateAmmoCounts();
        this.owner = Owner.deserializeFromNBT(tag);
        this.isSettingUp = tag.func_74767_n("setup");
        if (this.isSettingUp) {
            this.setupTicks = tag.func_74762_e("sTick");
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    protected void func_70014_b(NBTTagCompound tag) {
        tag.func_74768_a("vehType", this.vehicleType.getGlobalVehicleType());
        tag.func_74768_a("matLvl", this.vehicleMaterialLevel);
        tag.func_74776_a("health", this.getHealth());
        tag.func_74776_a("turHome", this.localTurretRotationHome);
        this.inventory.writeToNBT(tag);
        tag.func_74782_a("upgrades", (NBTBase)this.upgradeHelper.serializeNBT());
        tag.func_74782_a("ammo", (NBTBase)this.ammoHelper.serializeNBT());
        tag.func_74782_a("move", (NBTBase)this.moveHelper.serializeNBT());
        tag.func_74782_a("fire", (NBTBase)this.firingHelper.serializeNBT());
        tag.func_74782_a("vars", this.firingVarsHelper.serializeNBT());
        tag.func_74776_a("lc", this.localLaunchPower);
        tag.func_74776_a("tp", this.localTurretPitch);
        tag.func_74776_a("tpd", this.localTurretDestPitch);
        tag.func_74776_a("tr", this.localTurretRotation);
        tag.func_74776_a("trd", this.localTurretDestRot);
        this.owner.serializeToNBT(tag);
        tag.func_74757_a("setup", this.isSettingUp);
        if (this.isSettingUp) {
            tag.func_74768_a("sTick", this.setupTicks);
        }
    }

    @Override
    public void onMissileImpact(World world, double x, double y, double z) {
        if (this.func_184187_bx() instanceof IMissileHitCallback) {
            ((IMissileHitCallback)this.func_184187_bx()).onMissileImpact(world, x, y, z);
        }
    }

    @Override
    public void onMissileImpactEntity(World world, Entity entity) {
        if (this.func_184187_bx() instanceof IMissileHitCallback) {
            ((IMissileHitCallback)this.func_184187_bx()).onMissileImpactEntity(world, entity);
        }
    }

    @Override
    public void setMoveTo(double x, double y, double z, float moveSpeed) {
        this.moveHelper.setMoveTo(x, y, z);
    }

    @Override
    public boolean isPathableEntityOnLadder() {
        return false;
    }

    @Override
    public Entity getEntity() {
        return this;
    }

    @Override
    public void setPath(List<Node> path) {
        this.nav.forcePath(path);
    }

    public void clearPath() {
        this.nav.clearPath();
    }

    @Override
    public float getDefaultMoveSpeed() {
        return this.currentForwardSpeedMax;
    }

    @Override
    public void onStuckDetected() {
        if (this.func_184179_bs() instanceof NpcBase) {
            ((NpcBase)this.func_184179_bs()).onStuckDetected();
        }
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory.storageInventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void setOwner(EntityPlayer player) {
        this.owner = new Owner(player);
    }

    @Override
    public void setOwner(Owner owner) {
        this.owner = owner;
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    @Override
    public boolean isOwner(EntityPlayer player) {
        return this.owner.isOwnerOrSameTeamOrFriend((Entity)player);
    }

    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        this.func_184188_bt().forEach(e -> e.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v));
        return super.func_189511_e(compound);
    }

    public boolean isAmmoLoaded() {
        return this.vehicleType.getValidAmmoTypes().stream().anyMatch(a -> this.ammoHelper.getCountOf((IAmmo)a) > 0);
    }
}

