/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.container;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.shadowmage.ancientwarfare.vehicle.container.ContainerVehicle;
import net.shadowmage.ancientwarfare.vehicle.item.ItemAmmo;
import net.shadowmage.ancientwarfare.vehicle.item.ItemArmor;
import net.shadowmage.ancientwarfare.vehicle.item.ItemUpgrade;

public class ContainerVehicleInventory
extends ContainerVehicle {
    private Slot[] storageSlots;
    public int storageY = 34;
    public int extrasY;
    public int playerY;
    private int currentTopStorageRow = 0;

    public ContainerVehicleInventory(EntityPlayer openingPlayer, int entityId, int dummy1, int dummy2) {
        super(openingPlayer, entityId, dummy1, dummy2);
        int yPos;
        int xPos;
        int slotNum;
        int x;
        int y;
        int invHeight = (this.vehicle.inventory.storageInventory.getSlots() / 9 + (this.vehicle.inventory.storageInventory.getSlots() % 9 == 0 ? 0 : 1)) * 18;
        invHeight = invHeight > 54 ? 54 : invHeight;
        this.extrasY = this.storageY + (invHeight == 0 ? 0 : 10) + invHeight;
        this.playerY = this.extrasY + 4 + 10 + 36;
        this.addPlayerSlots(8, this.playerY, 4);
        for (y = 0; y < 2; ++y) {
            for (x = 0; x < 3; ++x) {
                slotNum = y * 3 + x;
                if (slotNum >= this.vehicle.inventory.ammoInventory.getSlots()) continue;
                xPos = 8 + x * 18;
                yPos = y * 18 + this.extrasY;
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.vehicle.inventory.ammoInventory, slotNum, xPos, yPos));
            }
        }
        for (y = 0; y < 2; ++y) {
            for (x = 0; x < 3; ++x) {
                slotNum = y * 3 + x;
                if (slotNum >= this.vehicle.inventory.upgradeInventory.getSlots()) continue;
                xPos = 8 + x * 18 + 54 + 5;
                yPos = y * 18 + this.extrasY;
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.vehicle.inventory.upgradeInventory, slotNum, xPos, yPos));
            }
        }
        for (y = 0; y < 2; ++y) {
            for (x = 0; x < 3; ++x) {
                slotNum = y * 3 + x;
                if (slotNum >= this.vehicle.inventory.armorInventory.getSlots()) continue;
                xPos = 8 + x * 18 + 108 + 10;
                yPos = y * 18 + this.extrasY;
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.vehicle.inventory.armorInventory, slotNum, xPos, yPos));
            }
        }
        this.storageSlots = new Slot[this.vehicle.inventory.storageInventory.getSlots()];
        for (y = 0; y < this.vehicle.inventory.storageInventory.getSlots() / 9; ++y) {
            for (x = 0; x < 9; ++x) {
                slotNum = y * 9 + x;
                if (slotNum >= this.vehicle.inventory.storageInventory.getSlots()) continue;
                xPos = 8 + x * 18;
                yPos = y * 18 + this.storageY;
                if (slotNum >= 27) {
                    xPos = -1000;
                    yPos = -1000;
                }
                SlotItemHandler slot = new SlotItemHandler((IItemHandler)this.vehicle.inventory.storageInventory, slotNum, xPos, yPos);
                this.storageSlots[slotNum] = slot;
                this.func_75146_a((Slot)slot);
            }
        }
    }

    public void nextRow() {
        this.setCurrentTopStorageRow(this.currentTopStorageRow + 1);
    }

    public void prevRow() {
        this.setCurrentTopStorageRow(this.currentTopStorageRow - 1);
    }

    private void setCurrentTopStorageRow(int row) {
        if (row < 0 || row >= this.storageSlots.length / 9) {
            return;
        }
        this.currentTopStorageRow = row;
        int curRow = 0;
        for (int y = 0; y < this.vehicle.inventory.storageInventory.getSlots() / 9; ++y) {
            for (int x = 0; x < 9; ++x) {
                int yPos;
                int xPos;
                int slotNum = y * 9 + x;
                if (slotNum >= this.vehicle.inventory.storageInventory.getSlots()) continue;
                if (y < row || y >= row + 3) {
                    xPos = -1000;
                    yPos = -1000;
                } else {
                    xPos = 8 + x * 18;
                    yPos = this.storageY + curRow * 18;
                }
                this.storageSlots[slotNum].field_75223_e = xPos;
                this.storageSlots[slotNum].field_75221_f = yPos;
            }
            if (y < row || y >= row + 3) continue;
            ++curRow;
        }
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer player, int slotClickedIndex) {
        ItemStack slotStackCopy = ItemStack.field_190927_a;
        Slot theSlot = (Slot)this.field_75151_b.get(slotClickedIndex);
        if (theSlot != null && theSlot.func_75216_d()) {
            ItemStack slotStack = theSlot.func_75211_c();
            slotStackCopy = slotStack.func_77946_l();
            int ammoSlots = this.vehicle.inventory.ammoInventory.getSlots();
            int upgradeSlots = this.vehicle.inventory.upgradeInventory.getSlots();
            int armorSlots = this.vehicle.inventory.armorInventory.getSlots();
            int storageSlots = this.vehicle.inventory.storageInventory.getSlots();
            if (slotClickedIndex < 36 ? (slotStackCopy.func_77973_b() instanceof ItemAmmo ? !this.func_75135_a(slotStack, 36, 36 + ammoSlots, false) : (slotStackCopy.func_77973_b() instanceof ItemUpgrade ? !this.func_75135_a(slotStack, 36 + ammoSlots, 36 + ammoSlots + upgradeSlots, false) : (slotStackCopy.func_77973_b() instanceof ItemArmor ? !this.func_75135_a(slotStack, 36 + ammoSlots + upgradeSlots, 36 + ammoSlots + upgradeSlots + armorSlots, false) : !this.func_75135_a(slotStack, 36 + ammoSlots + upgradeSlots + armorSlots, 36 + ammoSlots + upgradeSlots + armorSlots + storageSlots, false)))) : slotClickedIndex >= 36 && slotClickedIndex < 36 + ammoSlots + upgradeSlots + armorSlots + storageSlots && !this.func_75135_a(slotStack, 0, 36, true)) {
                return ItemStack.field_190927_a;
            }
            theSlot.func_75218_e();
            this.vehicle.ammoHelper.updateAmmoCounts();
            this.vehicle.upgradeHelper.updateUpgrades();
            if (slotStack.func_190916_E() == slotStackCopy.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            theSlot.func_190901_a(player, slotStack);
        }
        return slotStackCopy;
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
    }

    @Override
    public boolean func_75145_c(EntityPlayer player) {
        return super.func_75145_c(player) && player != null && (double)player.func_70032_d((Entity)this.vehicle) < 8.0;
    }
}

