/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.VehicleVarHelpers;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.entity.EntityGate;
import net.shadowmage.ancientwarfare.vehicle.config.AWVehicleStatics;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleBase;
import net.shadowmage.ancientwarfare.vehicle.entity.types.VehicleTypeBatteringRam;
import net.shadowmage.ancientwarfare.vehicle.helpers.VehicleFiringVarsHelper;
import net.shadowmage.ancientwarfare.vehicle.init.AWVehicleSounds;
import net.shadowmage.ancientwarfare.vehicle.missiles.DamageType;

public class BatteringRamVarHelper
extends VehicleFiringVarsHelper {
    float logAngle = 0.0f;
    float logSpeed = 0.0f;

    public BatteringRamVarHelper(VehicleBase vehicle) {
        super(vehicle);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74776_a("lA", this.logAngle);
        tag.func_74776_a("lS", this.logSpeed);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        this.logAngle = tag.func_74760_g("lA");
        this.logSpeed = tag.func_74760_g("lS");
    }

    @Override
    public void onFiringUpdate() {
        if (this.logAngle >= 30.0f) {
            this.vehicle.firingHelper.startLaunching();
            this.logSpeed = 0.0f;
        } else {
            this.logAngle += 1.0f;
            this.logSpeed = 1.0f;
        }
    }

    @Override
    public void onReloadUpdate() {
        if (this.logAngle < 0.0f) {
            this.logAngle += 1.0f;
            this.logSpeed = 1.0f;
        } else {
            this.logAngle = 0.0f;
            this.logSpeed = 0.0f;
        }
    }

    @Override
    public void onLaunchingUpdate() {
        if (this.logAngle <= -30.0f) {
            this.vehicle.firingHelper.setFinishedLaunching();
            this.doDamageEffects();
            this.logSpeed = 0.0f;
        } else {
            this.logAngle -= 2.0f;
            this.logSpeed = -2.0f;
        }
    }

    public void doDamageEffects() {
        BlockPos[] effectedPositions;
        if (this.vehicle.field_70170_p.field_72995_K) {
            return;
        }
        for (BlockPos pos : effectedPositions = VehicleTypeBatteringRam.getEffectedPositions(this.vehicle)) {
            Random rand;
            if (pos == null) continue;
            AxisAlignedBB bb = new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1));
            List hitEntities = this.vehicle.field_70170_p.func_72839_b((Entity)this.vehicle, bb);
            if (hitEntities != null) {
                boolean firstGateBlock = true;
                for (Entity ent : hitEntities) {
                    System.out.println("entity: " + ent);
                    ent.func_70097_a(DamageType.batteringDamage, (float)(5 + this.vehicle.vehicleMaterialLevel));
                    if (!(ent instanceof EntityGate)) continue;
                    String gateTypeName = ((EntityGate)ent).gateType.getVariant().toString().toLowerCase();
                    if (gateTypeName.contains("wood") && firstGateBlock) {
                        ent.func_184185_a(AWVehicleSounds.BATTERING_RAM_HIT_WOOD, 3.0f, 1.0f);
                        firstGateBlock = false;
                        continue;
                    }
                    if (!gateTypeName.contains("iron") || !firstGateBlock) continue;
                    System.out.println("sound played");
                    ent.func_184185_a(AWVehicleSounds.BATTERING_RAM_HIT_IRON, 3.0f, 1.0f);
                    firstGateBlock = false;
                }
            }
            if (!AWVehicleStatics.generalSettings.batteringRamBreaksBlocks || !((rand = new Random()).nextDouble() < (double)(AWVehicleStatics.generalSettings.batteringRamBlockBreakPercentageChance / 100))) continue;
            BlockTools.breakBlockAndDrop(this.vehicle.field_70170_p, pos);
        }
    }

    @Override
    public void onReloadingFinished() {
        this.logAngle = 0.0f;
        this.logSpeed = 0.0f;
    }

    @Override
    public float getVar1() {
        return this.logAngle;
    }

    @Override
    public float getVar2() {
        return this.logSpeed;
    }

    @Override
    public float getVar3() {
        return 0.0f;
    }

    @Override
    public float getVar4() {
        return 0.0f;
    }

    @Override
    public float getVar5() {
        return 0.0f;
    }

    @Override
    public float getVar6() {
        return 0.0f;
    }

    @Override
    public float getVar7() {
        return 0.0f;
    }

    @Override
    public float getVar8() {
        return 0.0f;
    }
}

