/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.worldgen.stats;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.worldgen.Territory;
import net.shadowmage.ancientwarfare.structure.worldgen.TerritoryManager;
import net.shadowmage.ancientwarfare.structure.worldgen.stats.PlacementRejectionReason;
import net.shadowmage.ancientwarfare.structure.worldgen.stats.ValidationRejectionReason;

public class WorldGenStatistics {
    private static Map<String, TerritoryRecord> territories = new TreeMap<String, TerritoryRecord>();
    private static Map<String, StructureRecord> structures = new TreeMap<String, StructureRecord>();
    private static boolean collectWorldGenStats = AWStructureStatics.collectWorldGenStatistics;

    private WorldGenStatistics() {
    }

    public static void startCollectingStatistics() {
        collectWorldGenStats = true;
    }

    public static void stopCollectingStatistics() {
        collectWorldGenStats = false;
    }

    public static void clearStatistics() {
        territories.clear();
        structures.clear();
    }

    public static Optional<StructureRecord> getStructure(String structureName) {
        return Optional.ofNullable(structures.get(structureName));
    }

    public static void addTerritoryInfo(String territoryName, String biomeName, float clusterValue) {
        if (!collectWorldGenStats) {
            return;
        }
        if (!territories.containsKey(territoryName)) {
            territories.put(territoryName, new TerritoryRecord(territoryName));
        }
        TerritoryRecord territoryRecord = territories.get(territoryName);
        territoryRecord.addBiomeGen(biomeName);
        territoryRecord.addClustervalue(biomeName, clusterValue);
        territoryRecord.incrementTimesGenerated();
    }

    public static Optional<TerritoryRecord> getTerritory(String territoryName) {
        return Optional.ofNullable(territories.get(territoryName));
    }

    public static Collection<StructureRecord> getStructures() {
        return structures.values();
    }

    public static Collection<TerritoryRecord> getTerritories() {
        return territories.values();
    }

    public static void addStructurePlacementRejection(String structureName, PlacementRejectionReason placementRejectionReason) {
        if (!collectWorldGenStats) {
            return;
        }
        StructureRecord structureRecord = WorldGenStatistics.getStructureRecord(structureName);
        structureRecord.addPlacementRejectionReason(placementRejectionReason);
    }

    public static void addStructureValidationRejection(String structureName, ValidationRejectionReason validationRejectionReason) {
        if (!collectWorldGenStats) {
            return;
        }
        StructureRecord structureRecord = WorldGenStatistics.getStructureRecord(structureName);
        structureRecord.addValidationRejectionReason(validationRejectionReason);
    }

    public static void recordStructureConsideredInRandom(String structureName, int weight, int totalWeight, String biomeName, String territoryName) {
        WorldGenStatistics.getStructureRecord(structureName).incrementTimesConsideredInRandom(biomeName, territoryName, weight == 0 ? 0.0f : (float)weight / (float)totalWeight);
    }

    public static void addStructureGeneratedInfo(String structureName, World world, BlockPos pos) {
        if (!collectWorldGenStats) {
            return;
        }
        StructureRecord structureRecord = WorldGenStatistics.getStructureRecord(structureName);
        structureRecord.incrementTimesGenerated();
        structureRecord.addBiomeGen(world.func_180494_b(pos).getRegistryName().toString());
        structureRecord.addTerritoryGen(TerritoryManager.getTerritory(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4, world).map(Territory::getTerritoryName).orElse(""));
    }

    private static StructureRecord getStructureRecord(String structureName) {
        if (!structures.containsKey(structureName)) {
            structures.put(structureName, new StructureRecord(structureName));
        }
        return structures.get(structureName);
    }

    private static <T> void incrementMapKey(Map<T, Integer> map, T key) {
        WorldGenStatistics.changeMapKeyValue(map, key, 0, v -> v + 1);
    }

    private static <T> void addMapKeyValue(Map<T, Float> map, T key, float value) {
        WorldGenStatistics.changeMapKeyValue(map, key, Float.valueOf(0.0f), v -> Float.valueOf(v.floatValue() + value));
    }

    private static <K, V> void changeMapKeyValue(Map<K, V> map, K key, V defaultValue, Function<V, V> changeValue) {
        map.put(key, changeValue.apply(map.getOrDefault(key, defaultValue)));
    }

    public static class StructureRecord {
        private final String name;
        private int timesGenerated = 0;
        private int timesConsideredInRandom = 0;
        private float totalChance = 0.0f;
        private final Map<String, Integer> biomeGenerations = new TreeMap<String, Integer>();
        private final Map<String, GenerationChance> biomeChances = new TreeMap<String, GenerationChance>();
        private final Map<String, Integer> territoryGenerations = new TreeMap<String, Integer>();
        private final Map<String, GenerationChance> territoryChances = new TreeMap<String, GenerationChance>();
        private final Map<ValidationRejectionReason, Integer> validationRejectionReasons = new TreeMap<ValidationRejectionReason, Integer>();
        private final Map<PlacementRejectionReason, Integer> placementRejectionReasons = new TreeMap<PlacementRejectionReason, Integer>();

        public Map<String, Integer> getBiomeGenerations() {
            return this.biomeGenerations;
        }

        public float getAverageChance() {
            return this.totalChance / (float)this.timesConsideredInRandom;
        }

        public Map<String, GenerationChance> getBiomeChances() {
            return this.biomeChances;
        }

        public Map<String, GenerationChance> getTerritoryChances() {
            return this.territoryChances;
        }

        public Map<String, Integer> getTerritoryGenerations() {
            return this.territoryGenerations;
        }

        public Map<ValidationRejectionReason, Integer> getValidationRejectionReasons() {
            return this.validationRejectionReasons;
        }

        public Map<PlacementRejectionReason, Integer> getPlacementRejectionReasons() {
            return this.placementRejectionReasons;
        }

        StructureRecord(String structureName) {
            this.name = structureName;
        }

        void incrementTimesGenerated() {
            ++this.timesGenerated;
        }

        void incrementTimesConsideredInRandom(String biomeName, String territoryName, float chance) {
            ++this.timesConsideredInRandom;
            this.totalChance += chance;
            WorldGenStatistics.changeMapKeyValue(this.biomeChances, biomeName, new GenerationChance(), v -> v.addChance(chance));
            WorldGenStatistics.changeMapKeyValue(this.territoryChances, territoryName, new GenerationChance(), v -> v.addChance(chance));
        }

        void addBiomeGen(String biomeName) {
            WorldGenStatistics.incrementMapKey(this.biomeGenerations, biomeName);
        }

        void addTerritoryGen(String territoryName) {
            WorldGenStatistics.incrementMapKey(this.territoryGenerations, territoryName);
        }

        void addValidationRejectionReason(ValidationRejectionReason validationRejectionReason) {
            WorldGenStatistics.incrementMapKey(this.validationRejectionReasons, (Object)validationRejectionReason);
        }

        void addPlacementRejectionReason(PlacementRejectionReason placementRejectionReason) {
            WorldGenStatistics.incrementMapKey(this.placementRejectionReasons, (Object)placementRejectionReason);
        }

        public String getName() {
            return this.name;
        }

        public int getTimesGenerated() {
            return this.timesGenerated;
        }

        public int getTimesConsideredInRandom() {
            return this.timesConsideredInRandom;
        }

        public static class GenerationChance {
            private float totalChance = 0.0f;
            private int numberOfGenerations = 0;

            public int getNumberOfGenerations() {
                return this.numberOfGenerations;
            }

            GenerationChance addChance(float chance) {
                this.totalChance += chance;
                ++this.numberOfGenerations;
                return this;
            }

            public float getAverageChance() {
                return this.totalChance / (float)this.numberOfGenerations;
            }
        }
    }

    public static class TerritoryRecord {
        private final String name;
        private int timesGenerated = 0;
        private final Map<String, Integer> biomeGenerations = new TreeMap<String, Integer>();
        private final Map<String, Float> biomeTotalClusterValues = new TreeMap<String, Float>();
        private float totalClusterValue = 0.0f;

        TerritoryRecord(String name) {
            this.name = name;
        }

        void addBiomeGen(String biomeName) {
            WorldGenStatistics.incrementMapKey(this.biomeGenerations, biomeName);
        }

        void incrementTimesGenerated() {
            ++this.timesGenerated;
        }

        public String getName() {
            return this.name;
        }

        public int getTimesGenerated() {
            return this.timesGenerated;
        }

        public Map<String, Integer> getBiomeGenerations() {
            return this.biomeGenerations;
        }

        public float getAverageBiomeClusterValue(String biomeName) {
            return this.biomeTotalClusterValues.get(biomeName).floatValue() / (float)this.biomeGenerations.get(biomeName).intValue();
        }

        void addClustervalue(String biomeName, float clusterValue) {
            WorldGenStatistics.addMapKeyValue(this.biomeTotalClusterValues, biomeName, clusterValue);
            this.totalClusterValue += clusterValue;
        }

        public float getAverageClusterValue() {
            return this.totalClusterValue / (float)this.timesGenerated;
        }
    }
}

