/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.worldgen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.registry.TerritorySettingRegistry;
import net.shadowmage.ancientwarfare.structure.template.WorldGenStructureManager;
import net.shadowmage.ancientwarfare.structure.util.CollectionUtils;
import net.shadowmage.ancientwarfare.structure.worldgen.CapabilityTerritoryData;
import net.shadowmage.ancientwarfare.structure.worldgen.ITerritoryData;
import net.shadowmage.ancientwarfare.structure.worldgen.Territory;
import net.shadowmage.ancientwarfare.structure.worldgen.WorldGenDetailedLogHelper;
import net.shadowmage.ancientwarfare.structure.worldgen.stats.WorldGenStatistics;
import org.apache.logging.log4j.util.Supplier;

public class TerritoryManager {
    private static HashMap<Biome, List<String>> territoryNamesByBiome = new HashMap();
    private static HashMap<String, Set<Biome>> biomesByTerritoryNames = new HashMap();

    private TerritoryManager() {
    }

    public static Optional<Territory> getTerritory(int chunkX, int chunkZ, World world) {
        Chunk chunk = world.func_72964_e(chunkX, chunkZ);
        long chunkPosValue = ChunkPos.func_77272_a((int)chunk.field_76635_g, (int)chunk.field_76647_h);
        ITerritoryData territoryData = (ITerritoryData)world.getCapability(CapabilityTerritoryData.TERRITORY_DATA, null);
        if (territoryData == null) {
            return Optional.empty();
        }
        if (!territoryData.isOwned(chunkPosValue)) {
            new TerritoryGenerator(world).generateTerritory(chunkX, chunkZ, chunkPosValue, territoryData);
        }
        return territoryData.getTerritory(chunkPosValue);
    }

    static BlockPos getChunkCenterPos(int chunkX, int chunkZ) {
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        return new BlockPos(x, 1, z);
    }

    public static void clearTerritoryCache() {
        territoryNamesByBiome.clear();
        biomesByTerritoryNames.clear();
    }

    public static Set<String> getTerritoryNames() {
        return biomesByTerritoryNames.keySet();
    }

    public static Optional<Set<Biome>> getTerritoryBiomes(String territoryName) {
        return Optional.ofNullable(biomesByTerritoryNames.get(territoryName));
    }

    private static int getTerritoryWeight(String territoryName) {
        return (int)((float)(WorldGenStructureManager.INSTANCE.getTerritoryTemplates(territoryName).map(Set::size).orElse(0) + (!territoryName.equals("generic") ? WorldGenStructureManager.INSTANCE.getTerritoryTemplates("generic").map(Set::size).orElse(0) : 0)) * TerritorySettingRegistry.getTerritorySettings(territoryName).getTerritoryWeightMultiplier());
    }

    public static float getTerritoryChanceInBiome(String territoryName, String biomeName) {
        Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(biomeName));
        if (!territoryNamesByBiome.containsKey(biome)) {
            return 0.0f;
        }
        List<String> territoryNames = territoryNamesByBiome.get(biome);
        if (!territoryNames.contains(territoryName)) {
            return 0.0f;
        }
        int weight = TerritoryManager.getTerritoryWeight(territoryName);
        float totalWeight = 0.0f;
        for (String name : territoryNames) {
            totalWeight += (float)TerritoryManager.getTerritoryWeight(name);
        }
        return (float)weight / totalWeight;
    }

    public static void addTerritoryInBiome(String territoryName, String biomeName) {
        Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(biomeName));
        if (biome != null) {
            List territoryNames = territoryNamesByBiome.getOrDefault(biome, new ArrayList());
            if (!territoryNames.contains(territoryName)) {
                territoryNames.add(territoryName);
                territoryNamesByBiome.put(biome, territoryNames);
            }
            Set biomes = biomesByTerritoryNames.getOrDefault(territoryName, new HashSet());
            biomes.add(biome);
            biomesByTerritoryNames.put(territoryName, biomes);
        }
    }

    static BlockPos getTerritoryCenter(Collection<BlockPos> positions) {
        double averageX = 0.0;
        double averageZ = 0.0;
        for (BlockPos pos : positions) {
            averageX += (double)((float)pos.func_177958_n() / (float)positions.size());
            averageZ += (double)((float)pos.func_177952_p() / (float)positions.size());
        }
        BlockPos territoryCenterPos = new BlockPos(averageX, 1.0, averageZ);
        return territoryCenterPos;
    }

    private static class ProcessedChunk {
        private long chunkPosValue;
        private BlockPos centerPos;
        private int chunkX;
        private int chunkZ;

        private ProcessedChunk(long chunkPosValue, BlockPos centerPos, int chunkX, int chunkZ) {
            this.chunkPosValue = chunkPosValue;
            this.centerPos = centerPos;
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
        }

        private long getChunkPosValue() {
            return this.chunkPosValue;
        }

        private BlockPos getCenterPos() {
            return this.centerPos;
        }

        private int getChunkX() {
            return this.chunkX;
        }

        private int getChunkZ() {
            return this.chunkZ;
        }
    }

    private static class TerritoryGenerator {
        private Map<Long, ProcessedChunk> chunksToProcess = new HashMap<Long, ProcessedChunk>();
        private Map<Long, BlockPos> includedChunks = new HashMap<Long, BlockPos>();
        private Set<Long> visitedChunks = new HashSet<Long>();
        private World world;
        private double maxTerritoryCenterDistanceSq = 0.0;

        private TerritoryGenerator(World world) {
            this.world = world;
        }

        private void generateTerritory(int chunkX, int chunkZ, long chunkPosValue, ITerritoryData territoryData) {
            BlockPos firstPos = TerritoryManager.getChunkCenterPos(chunkX, chunkZ);
            Biome biome = this.world.func_180494_b(firstPos);
            if (!territoryNamesByBiome.containsKey(biome)) {
                return;
            }
            Supplier[] supplierArray = new Supplier[3];
            supplierArray[0] = () -> ((BlockPos)firstPos).func_177958_n();
            supplierArray[1] = () -> ((BlockPos)firstPos).func_177952_p();
            supplierArray[2] = () -> biome.getRegistryName().toString();
            WorldGenDetailedLogHelper.log("Generating new territory at x {} z {} in biome \"{}\"", supplierArray);
            List territoryNames = (List)territoryNamesByBiome.get(biome);
            String territoryName = this.getRandomTerritory(territoryNames);
            String territoryId = territoryName + territoryData.getNextTerritoryId(territoryName);
            this.maxTerritoryCenterDistanceSq = TerritorySettingRegistry.getMaxTerritoryCenterDistanceSq(territoryName);
            this.includedChunks.put(chunkPosValue, firstPos);
            this.chunksToProcess.put(chunkPosValue, new ProcessedChunk(chunkPosValue, firstPos, chunkX, chunkZ));
            TerritoryManager.getTerritoryBiomes(territoryName).ifPresent(biomes -> this.processChunks((Set<Biome>)biomes, territoryData));
            if (this.isTooFewChunksForNewTerritory()) {
                territoryId = this.getFirstDifferentTerritoryIdFromNeighbors(chunkX, chunkZ, territoryId, territoryData);
                WorldGenDetailedLogHelper.log("Too few chunks in new territory - connecting to existing territory", new Supplier[0]);
            }
            String finalTerritoryId = territoryId;
            this.includedChunks.forEach((hash, pos) -> territoryData.setOwned((long)hash, finalTerritoryId, territoryName));
            Supplier[] supplierArray2 = new Supplier[2];
            supplierArray2[0] = this.includedChunks::size;
            supplierArray2[1] = () -> finalTerritoryId;
            WorldGenDetailedLogHelper.log("{} chunks included in territory \"{}\"", supplierArray2);
            if (!this.isTooFewChunksForNewTerritory()) {
                WorldGenStatistics.addTerritoryInfo(territoryName, biome.getRegistryName().toString(), (float)this.includedChunks.size() * TerritorySettingRegistry.getTerritorySettings(territoryName).getPerChunkClusterValueMultiplier() * AWStructureStatics.chunkClusterValue);
            }
        }

        private boolean isTooFewChunksForNewTerritory() {
            return this.includedChunks.size() < 3;
        }

        private BlockPos getTerritoryCenter() {
            return TerritoryManager.getTerritoryCenter(this.includedChunks.values());
        }

        private void addChunkToProcess(Set<Biome> biomes, BlockPos territoryCenterPos, ChunkPos chunkPos, ITerritoryData territoryData) {
            long chunkPosValue = ChunkPos.func_77272_a((int)chunkPos.field_77276_a, (int)chunkPos.field_77275_b);
            BlockPos centerPos = TerritoryManager.getChunkCenterPos(chunkPos.field_77276_a, chunkPos.field_77275_b);
            if (territoryData.isOwned(chunkPosValue) || this.visitedChunks.contains(chunkPosValue) || this.chunksToProcess.containsKey(chunkPosValue)) {
                return;
            }
            if (biomes.contains(this.world.func_180494_b(centerPos)) && centerPos.func_177951_i((Vec3i)territoryCenterPos) < 1.1 * this.maxTerritoryCenterDistanceSq) {
                this.chunksToProcess.put(chunkPosValue, new ProcessedChunk(chunkPosValue, centerPos, chunkPos.field_77276_a, chunkPos.field_77275_b));
            }
        }

        private void includeChunk(ProcessedChunk processedChunk) {
            this.includedChunks.put(processedChunk.getChunkPosValue(), processedChunk.getCenterPos());
            this.visitedChunks.add(processedChunk.getChunkPosValue());
            Supplier[] supplierArray = new Supplier[3];
            supplierArray[0] = () -> this.includedChunks.entrySet().size();
            supplierArray[1] = () -> processedChunk.getCenterPos();
            supplierArray[2] = this::getTerritoryCenter;
            WorldGenDetailedLogHelper.log("Chunk #{} {}, territory center: {}", supplierArray);
        }

        private void processChunks(Set<Biome> biomes, ITerritoryData territoryData) {
            while (!this.chunksToProcess.isEmpty()) {
                if (this.includedChunks.isEmpty() && this.chunksToProcess.size() == 1) {
                    ProcessedChunk processedChunk = this.chunksToProcess.values().iterator().next();
                    this.includeChunk(processedChunk);
                    continue;
                }
                this.processClosestChunk(biomes, territoryData);
            }
        }

        private void processClosestChunk(Set<Biome> biomes, ITerritoryData territoryData) {
            ProcessedChunk closestChunkToProcess = null;
            double closestDist = Double.MAX_VALUE;
            BlockPos territoryCenterPos = this.getTerritoryCenter();
            for (ProcessedChunk processedChunk : this.chunksToProcess.values()) {
                double dist = territoryCenterPos.func_177951_i((Vec3i)processedChunk.getCenterPos());
                if (!(dist < closestDist)) continue;
                closestDist = dist;
                closestChunkToProcess = processedChunk;
            }
            if (closestChunkToProcess != null) {
                if (closestDist < this.maxTerritoryCenterDistanceSq) {
                    this.includeChunk(closestChunkToProcess);
                    this.addChunkToProcess(biomes, territoryCenterPos, new ChunkPos(closestChunkToProcess.getChunkX() + 1, closestChunkToProcess.getChunkZ()), territoryData);
                    this.addChunkToProcess(biomes, territoryCenterPos, new ChunkPos(closestChunkToProcess.getChunkX() - 1, closestChunkToProcess.getChunkZ()), territoryData);
                    this.addChunkToProcess(biomes, territoryCenterPos, new ChunkPos(closestChunkToProcess.getChunkX(), closestChunkToProcess.getChunkZ() + 1), territoryData);
                    this.addChunkToProcess(biomes, territoryCenterPos, new ChunkPos(closestChunkToProcess.getChunkX(), closestChunkToProcess.getChunkZ() - 1), territoryData);
                }
                this.chunksToProcess.remove(closestChunkToProcess.getChunkPosValue());
            }
        }

        private Optional<String> getDifferentTerritoryId(int chunkX, int chunkZ, String territoryId, ITerritoryData territoryData) {
            String id;
            Optional<Territory> territory = territoryData.getTerritory(ChunkPos.func_77272_a((int)chunkX, (int)chunkZ));
            if (territory.isPresent() && !(id = territory.get().getTerritoryId()).equals(territoryId)) {
                return Optional.of(id);
            }
            return Optional.empty();
        }

        private String getFirstDifferentTerritoryIdFromNeighbors(int chunkX, int chunkZ, String territoryId, ITerritoryData territoryData) {
            return this.getDifferentTerritoryId(chunkX + 1, chunkZ, territoryId, territoryData).orElse(this.getDifferentTerritoryId(chunkX - 1, chunkZ, territoryId, territoryData).orElse(this.getDifferentTerritoryId(chunkX, chunkZ + 1, territoryId, territoryData).orElse(this.getDifferentTerritoryId(chunkX, chunkZ - 1, territoryId, territoryData).orElse(territoryId))));
        }

        private String getRandomTerritory(List<String> names) {
            return CollectionUtils.getWeightedRandomElement(this.world.field_73012_v, names, x$0 -> TerritoryManager.getTerritoryWeight(x$0), (totalWeight, selected) -> {
                Supplier[] supplierArray = new Supplier[4];
                supplierArray[0] = names::size;
                supplierArray[1] = () -> totalWeight;
                supplierArray[2] = () -> selected;
                supplierArray[3] = () -> selected == null ? "" : Integer.valueOf(TerritoryManager.getTerritoryWeight(selected));
                WorldGenDetailedLogHelper.log("Out of total of {} territories with weight total of {} territory \"{}\" with weight {} was selected", supplierArray);
                WorldGenDetailedLogHelper.log("Following territories and weights were considered: \n{}", () -> {
                    StringJoiner joiner = new StringJoiner(", ");
                    names.forEach(name -> joiner.add(name + ":" + TerritoryManager.getTerritoryWeight(name)));
                    return joiner.toString();
                });
            }).orElse("generic");
        }
    }
}

