/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.worldgen;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.shadowmage.ancientwarfare.core.util.InjectionTools;
import net.shadowmage.ancientwarfare.structure.worldgen.ITerritoryData;
import net.shadowmage.ancientwarfare.structure.worldgen.TerritoryData;

public class CapabilityTerritoryData {
    @CapabilityInject(value=ITerritoryData.class)
    public static Capability<ITerritoryData> TERRITORY_DATA = (Capability)InjectionTools.nullValue();

    private CapabilityTerritoryData() {
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(ITerritoryData.class, (Capability.IStorage)new Capability.IStorage<ITerritoryData>(){

            public NBTBase writeNBT(Capability<ITerritoryData> capability, ITerritoryData instance, EnumFacing side) {
                return instance.serializeNBT();
            }

            public void readNBT(Capability<ITerritoryData> capability, ITerritoryData instance, EnumFacing side, NBTBase nbt) {
                if (!(instance instanceof TerritoryData)) {
                    throw new IllegalArgumentException("Can not deserialize to an instance that isn't the default implementation");
                }
                instance.deserializeNBT((NBTBase)((NBTTagCompound)nbt));
            }
        }, TerritoryData::new);
    }

    public static void onAttach(AttachCapabilitiesEvent<World> event) {
        event.addCapability(new ResourceLocation("ancientwarfarestructure", "territory_data"), (ICapabilityProvider)new TerritoryDataCapabilityProvider());
    }

    public static class TerritoryDataCapabilityProvider
    implements ICapabilitySerializable<NBTTagCompound> {
        private ITerritoryData territoryData = (ITerritoryData)TERRITORY_DATA.getDefaultInstance();

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == TERRITORY_DATA;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == TERRITORY_DATA ? TERRITORY_DATA.cast((Object)this.territoryData) : null);
        }

        public NBTTagCompound serializeNBT() {
            return (NBTTagCompound)TERRITORY_DATA.writeNBT((Object)this.territoryData, null);
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            TERRITORY_DATA.readNBT((Object)this.territoryData, null, (NBTBase)nbt);
        }
    }
}

