/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.util;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;

public class PotionHelper {
    private static final String SHOW_PARTICLES_TAG = "ShowParticles";
    private static final String CURATIVE_ITEMS_TAG = "CurativeItems";

    private PotionHelper() {
    }

    public static NBTTagCompound writeCustomPotionEffectToNBT(PotionEffect potionEffect) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("RegistryName", potionEffect.func_188419_a().getRegistryName().toString());
        nbt.func_74774_a("Amplifier", (byte)potionEffect.func_76458_c());
        nbt.func_74768_a("Duration", potionEffect.func_76459_b());
        nbt.func_74757_a("Ambient", potionEffect.func_82720_e());
        nbt.func_74757_a(SHOW_PARTICLES_TAG, potionEffect.func_188418_e());
        PotionHelper.writeCurativeItems(potionEffect, nbt);
        return nbt;
    }

    private static void writeCurativeItems(PotionEffect potionEffect, NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (ItemStack stack : potionEffect.getCurativeItems()) {
            list.func_74742_a((NBTBase)stack.func_77955_b(new NBTTagCompound()));
        }
        nbt.func_74782_a(CURATIVE_ITEMS_TAG, (NBTBase)list);
    }

    public static Optional<PotionEffect> readCustomPotionEffectFromNBT(NBTTagCompound nbt) {
        String registryName = nbt.func_74779_i("RegistryName");
        Potion potion = Potion.func_180142_b((String)registryName);
        if (potion == null) {
            return Optional.empty();
        }
        byte j = nbt.func_74771_c("Amplifier");
        int k = nbt.func_74762_e("Duration");
        boolean flag = nbt.func_74767_n("Ambient");
        boolean flag1 = true;
        if (nbt.func_150297_b(SHOW_PARTICLES_TAG, 1)) {
            flag1 = nbt.func_74767_n(SHOW_PARTICLES_TAG);
        }
        return Optional.of(PotionHelper.readCurativeItems(new PotionEffect(potion, k, (int)(j < 0 ? (byte)0 : j), flag, flag1), nbt));
    }

    private static PotionEffect readCurativeItems(PotionEffect effect, NBTTagCompound nbt) {
        if (nbt.func_150297_b(CURATIVE_ITEMS_TAG, 9)) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            NBTTagList list = nbt.func_150295_c(CURATIVE_ITEMS_TAG, 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                items.add(new ItemStack(list.func_150305_b(i)));
            }
            effect.setCurativeItems(items);
        }
        return effect;
    }
}

