/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.town;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.shadowmage.ancientwarfare.core.util.CompatUtils;
import net.shadowmage.ancientwarfare.core.util.parsing.JsonHelper;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;
import net.shadowmage.ancientwarfare.structure.town.TownTemplate;
import org.apache.commons.lang3.math.NumberUtils;

public class TownTemplateParser {
    private static final Map<String, BiConsumer<String, TownTemplate>> headerVariableSetters = new ImmutableMap.Builder().put((Object)"name", (value, template) -> template.setTownTypeName((String)value)).put((Object)"minsize", (value, template) -> template.setMinSize(Integer.parseInt(value))).put((Object)"maxsize", (value, template) -> template.setMaxSize(Integer.parseInt(value))).put((Object)"buildingexpansion", (value, template) -> template.setTownBuildingWidthExpansion(Integer.parseInt(value))).put((Object)"selectionweight", (value, template) -> template.setSelectionWeight(Integer.parseInt(value))).put((Object)"clustervalue", (value, template) -> template.setClusterValue(Integer.parseInt(value))).put((Object)"townblocksize", (value, template) -> template.setTownBlockSize(Integer.parseInt(value))).put((Object)"townplotsize", (value, template) -> template.setTownPlotSize(Integer.parseInt(value))).put((Object)"wallstyle", (value, template) -> template.setWallStyle(Integer.parseInt(value))).put((Object)"wallsize", (value, template) -> template.setWallSize(Integer.parseInt(value))).put((Object)"exteriorsize", (value, template) -> template.setExteriorSize(Integer.parseInt(value))).put((Object)"exteriorplotsize", (value, template) -> template.setExteriorPlotSize(Integer.parseInt(value))).put((Object)"interioremptyplotchance", (value, template) -> template.setInteriorEmtpyPlotChance(Integer.parseInt(value))).put((Object)"randomvillagersperchunk", (value, template) -> template.setRandomVillagersPerChunk(Float.parseFloat(value))).put((Object)"preventnaturalhostilespawns", (value, template) -> template.setPreventNaturalHostileSpawns(Boolean.parseBoolean(value))).put((Object)"roadblocks", (value, template) -> {
        String[] roadFillBlocks = value.split("\\|");
        JsonParser parser = new JsonParser();
        for (String roadFillBlock : roadFillBlocks) {
            try {
                template.addRoadFillBlock(JsonHelper.getBlockState(parser.parse(roadFillBlock)));
            }
            catch (JsonSyntaxException | MissingResourceException ex) {
                AncientWarfareStructure.LOG.error("Error parsing roadBlock JSON \"{}\": ", (Object)roadFillBlock, (Object)ex);
            }
        }
    }).put((Object)"biomewhitelist", (value, template) -> template.setBiomeWhiteList(Boolean.parseBoolean(value))).put((Object)"biomelist", (value, template) -> template.setBiomeList(TownTemplateParser.parseBiomeList(value))).put((Object)"dimensionwhitelist", (value, template) -> template.setDimensionWhiteList(Boolean.parseBoolean(value))).put((Object)"dimensionlist", (value, template) -> template.setDimensionList(TownTemplateParser.parseDimensionList(value))).put((Object)"lamp", (value, template) -> template.setLamp(new TownTemplate.TownStructureEntry((String)value, 1))).put((Object)"biomereplacement", (value, template) -> template.setBiomeReplacement(new ResourceLocation(value))).put((Object)"territoryname", (value, template) -> template.setTerritoryName((String)value)).build();

    private TownTemplateParser() {
    }

    public static Optional<TownTemplate> parseTemplate(List<String> lines) {
        String line;
        TownTemplate template = new TownTemplate();
        Iterator<String> it = lines.iterator();
        while (it.hasNext() && (line = it.next()) != null) {
            if ((line = line.toLowerCase(Locale.ENGLISH)).startsWith("header:")) {
                if (TownTemplateParser.parseHeader(it, template)) continue;
                return Optional.empty();
            }
            if (line.startsWith("walls:")) {
                TownTemplateParser.parseWalls(it, template);
                continue;
            }
            if (line.startsWith("wallpatterns:")) {
                TownTemplateParser.parseWallPatterns(it, template);
                continue;
            }
            if (line.startsWith("uniquestructures:")) {
                TownTemplateParser.parseUniqueStructures(it, template);
                continue;
            }
            if (line.startsWith("mainstructures:")) {
                TownTemplateParser.parseMainStructures(it, template);
                continue;
            }
            if (line.startsWith("housestructures:")) {
                TownTemplateParser.parseHouseStructures(it, template);
                continue;
            }
            if (line.startsWith("cosmeticstructures:")) {
                TownTemplateParser.parseCosmetics(it, template);
                continue;
            }
            if (!line.startsWith("exteriorstructures:")) continue;
            TownTemplateParser.parseExteriorStructures(it, template);
        }
        if (template.isValid()) {
            return Optional.of(template);
        }
        return Optional.empty();
    }

    private static boolean parseHeader(Iterator<String> it, TownTemplate template) {
        String[] variableAndValue;
        String variableName;
        String line;
        while (it.hasNext() && (line = it.next()) != null && !(variableName = (variableAndValue = line.split("="))[0].toLowerCase()).startsWith(":endheader")) {
            if (variableName.equals("mods") && variableAndValue.length > 1) {
                if (CompatUtils.areModsLoaded(variableAndValue[1].split(","))) continue;
                return false;
            }
            if (!headerVariableSetters.containsKey(variableName) || variableAndValue.length <= 1) continue;
            headerVariableSetters.get(variableName).accept(variableAndValue[1], template);
        }
        if (template.getRoadFillBlocks().isEmpty()) {
            template.addRoadFillBlock(Blocks.field_150351_n.func_176223_P());
        }
        return true;
    }

    private static void parseUniqueStructures(Iterator<String> it, TownTemplate template) {
        String line;
        while (it.hasNext() && (line = it.next()) != null && !line.toLowerCase(Locale.ENGLISH).startsWith(":enduniquestructures")) {
            TownTemplate.TownStructureEntry e = TownTemplateParser.parseStructureName(line);
            template.getUniqueStructureEntries().add(e);
        }
    }

    private static void parseMainStructures(Iterator<String> it, TownTemplate template) {
        String line;
        while (it.hasNext() && (line = it.next()) != null && !line.toLowerCase(Locale.ENGLISH).startsWith(":endmainstructures")) {
            TownTemplate.TownStructureEntry e = TownTemplateParser.parseStructureName(line);
            template.getMainStructureEntries().add(e);
        }
    }

    private static void parseHouseStructures(Iterator<String> it, TownTemplate template) {
        String line;
        while (it.hasNext() && (line = it.next()) != null && !line.toLowerCase(Locale.ENGLISH).startsWith(":endhousestructures")) {
            TownTemplate.TownStructureEntry e = TownTemplateParser.parseStructureWeight(line);
            template.getHouseStructureEntries().add(e);
        }
    }

    private static void parseCosmetics(Iterator<String> it, TownTemplate template) {
        String line;
        while (it.hasNext() && (line = it.next()) != null && !line.toLowerCase(Locale.ENGLISH).startsWith(":endcosmeticstructures")) {
            TownTemplate.TownStructureEntry e = TownTemplateParser.parseStructureWeight(line);
            template.getCosmeticEntries().add(e);
        }
    }

    private static void parseExteriorStructures(Iterator<String> it, TownTemplate template) {
        String line;
        while (it.hasNext() && (line = it.next()) != null && !line.toLowerCase(Locale.ENGLISH).startsWith(":endexteriorstructures")) {
            TownTemplate.TownStructureEntry e = TownTemplateParser.parseStructureWeight(line);
            template.getExteriorStructureEntries().add(e);
        }
    }

    private static void parseWalls(Iterator<String> it, TownTemplate template) {
        String line;
        while (it.hasNext() && (line = it.next()) != null && !line.toLowerCase(Locale.ENGLISH).startsWith(":endwalls")) {
            TownTemplate.TownWallEntry e = TownTemplateParser.parseWall(line);
            template.addWall(e);
        }
    }

    private static void parseWallPatterns(Iterator<String> it, TownTemplate template) {
        String line;
        while (it.hasNext() && (line = it.next()) != null && !line.toLowerCase(Locale.ENGLISH).startsWith(":endwallpaterns")) {
            String[] bits = line.split(":", -1);
            int size = NumberUtils.toInt((String)bits[0]);
            int[] pattern = TownTemplateParser.parseWallPattern(bits[1]);
            template.addWallPattern(size, pattern);
        }
    }

    private static List<String> parseBiomeList(String line) {
        String[] bits = line.split(",", -1);
        if (bits.length <= 0) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>();
        for (String bit : bits) {
            names.add(bit.toLowerCase(Locale.ENGLISH));
        }
        return names;
    }

    private static List<Integer> parseDimensionList(String line) {
        String[] bits = line.split(",", -1);
        if (bits.length <= 0) {
            return Collections.emptyList();
        }
        ArrayList<Integer> dims = new ArrayList<Integer>();
        for (String bit : bits) {
            dims.add(NumberUtils.toInt((String)bit.toLowerCase(Locale.ENGLISH)));
        }
        return dims;
    }

    private static TownTemplate.TownStructureEntry parseStructureName(String line) {
        String[] bits = line.split(":", -1);
        return new TownTemplate.TownStructureEntry(bits[0], 0);
    }

    private static TownTemplate.TownStructureEntry parseStructureWeight(String line) {
        String[] bits = line.split(":", -1);
        return new TownTemplate.TownStructureEntry(bits[0], NumberUtils.toInt((String)bits[1]));
    }

    private static TownTemplate.TownWallEntry parseWall(String line) {
        String[] bits = line.split(":", -1);
        return new TownTemplate.TownWallEntry(bits[0], bits[1], NumberUtils.toInt((String)bits[2]), NumberUtils.toInt((String)bits[3]));
    }

    private static int[] parseWallPattern(String line) {
        String[] bits = line.split("-", -1);
        int[] pattern = new int[bits.length];
        for (int i = 0; i < bits.length; ++i) {
            pattern[i] = NumberUtils.toInt((String)bits[i]);
        }
        return pattern;
    }
}

