/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.town;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateManager;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.town.Direction;
import net.shadowmage.ancientwarfare.structure.town.TownBoundingArea;
import net.shadowmage.ancientwarfare.structure.town.TownGeneratorBorders;
import net.shadowmage.ancientwarfare.structure.town.TownGeneratorStructures;
import net.shadowmage.ancientwarfare.structure.town.TownGeneratorWalls;
import net.shadowmage.ancientwarfare.structure.town.TownPartBlock;
import net.shadowmage.ancientwarfare.structure.town.TownPartQuadrant;
import net.shadowmage.ancientwarfare.structure.town.TownTemplate;
import net.shadowmage.ancientwarfare.structure.worldgen.WorldGenTickHandler;

public class TownGenerator {
    public final TownTemplate template;
    public final World world;
    public final Random rng;
    public final PseudoNonRepeatingIntRandom nonRepeatingRng;
    final StructureBB maximalBounds;
    final StructureBB exteriorBounds;
    final StructureBB wallsBounds;
    final StructureBB townBounds;
    final TownPartQuadrant[] quadrants = new TownPartQuadrant[4];
    final TownPartQuadrant[] externalQuadrants = new TownPartQuadrant[8];
    final List<StructureTemplate> uniqueTemplatesToGenerate = new ArrayList<StructureTemplate>();
    final List<StructureTemplate> mainTemplatesToGenerate = new ArrayList<StructureTemplate>();
    final List<StructureTemplate> houseTemplatesToGenerate = new ArrayList<StructureTemplate>();
    final List<StructureTemplate> cosmeticTemplatesToGenerate = new ArrayList<StructureTemplate>();
    final List<StructureTemplate> exteriorTemplatesToGenerate = new ArrayList<StructureTemplate>();
    final List<BlockPos> structureDoors = new ArrayList<BlockPos>();

    TownGenerator(World world, TownBoundingArea area, TownTemplate template) {
        this.world = world;
        this.template = template;
        long seed = area.getCenterX() << 16 | area.getCenterZ();
        this.rng = new Random(seed);
        this.nonRepeatingRng = new PseudoNonRepeatingIntRandom(seed);
        int y1 = area.getSurfaceY() + 1;
        int y2 = y1 + 20;
        area.wallSize = template.getWallSize();
        area.exteriorSize = template.getExteriorSize();
        this.maximalBounds = new StructureBB(area.getBlockMinX(), y1, area.getBlockMinZ(), area.getBlockMaxX(), y2, area.getBlockMaxZ());
        this.exteriorBounds = new StructureBB(area.getExteriorMinX(), y1, area.getExteriorMinZ(), area.getExteriorMaxX(), y2, area.getExteriorMaxZ());
        this.wallsBounds = new StructureBB(area.getWallMinX(), y1, area.getWallMinZ(), area.getWallMaxX(), y2, area.getWallMaxZ());
        this.townBounds = new StructureBB(area.getTownMinX(), y1, area.getTownMinZ(), area.getTownMaxX(), y2, area.getTownMaxZ());
    }

    public void generate() {
        AncientWarfareStructure.LOG.info("Generating town at: {} : {}", (Object)this.townBounds.getCenterX(), (Object)this.townBounds.getCenterZ());
        this.determineStructuresToGenerate();
        this.changeBiome(this.exteriorBounds);
        TownGeneratorBorders.generateBorders(this.world, this.exteriorBounds);
        TownGeneratorBorders.levelTownArea(this.world, this.exteriorBounds);
        this.generateGrid();
        TownGeneratorWalls.generateWalls(this.world, this, this.template, this.rng);
        WorldGenTickHandler.INSTANCE.addStructureGenCallback(new WorldGenTickHandler.StructureTicket(){

            @Override
            public void call() {
                TownGenerator.this.generateRoads();
                TownGeneratorStructures.generateStructures(TownGenerator.this);
            }

            @Override
            public int getBlocksToGenerate() {
                return 100;
            }
        });
    }

    private void changeBiome(StructureBB bb) {
        this.template.getBiomeReplacement().ifPresent(biomeRegistryName -> {
            if (!ForgeRegistries.BIOMES.containsKey(biomeRegistryName)) {
                return;
            }
            Biome replacementBiome = (Biome)ForgeRegistries.BIOMES.getValue(biomeRegistryName);
            BlockPos minPos = bb.min;
            BlockPos maxPos = new BlockPos(bb.max.func_177958_n(), bb.min.func_177956_o(), bb.max.func_177952_p());
            BlockPos.func_177980_a((BlockPos)minPos, (BlockPos)maxPos).forEach(pos -> WorldTools.changeBiome(this.world, pos, replacementBiome));
        });
    }

    void generateVillagers() {
        float villagers = this.template.getRandomVillagersPerChunk();
        if (villagers > 0.0f) {
            int wholeVillagersPerChunk = 0;
            while (villagers > 1.0f) {
                ++wholeVillagersPerChunk;
                villagers -= 1.0f;
            }
            int x = this.townBounds.min.func_177958_n();
            int y = this.townBounds.min.func_177956_o();
            int z = this.townBounds.min.func_177952_p();
            for (int bx = x; bx < x + this.townBounds.getXSize(); bx += 16) {
                for (int bz = z; bz < z + this.townBounds.getZSize(); bz += 16) {
                    for (int i = 0; i < wholeVillagersPerChunk; ++i) {
                        this.spawnVillager(bx, y, bz);
                    }
                    if (!(this.rng.nextFloat() < villagers)) continue;
                    this.spawnVillager(bx, y, bz);
                }
            }
        }
    }

    private void spawnVillager(int minX, int y, int minZ) {
        BlockPos pos = new BlockPos(minX, y, minZ);
        EntityVillager villager = new EntityVillager(this.world);
        villager.func_180482_a(this.world.func_175649_E(pos), null);
        for (int i = 0; i < 10; ++i) {
            int z;
            int x = minX + this.rng.nextInt(16);
            pos = new BlockPos(x, y, z = minZ + this.rng.nextInt(16));
            if (!this.world.func_175623_d(pos) || !this.world.func_175623_d(pos.func_177984_a()) || !this.world.isSideSolid(pos.func_177977_b(), EnumFacing.UP)) continue;
            villager.func_70107_b((double)x + 0.5, (double)y, (double)z + 0.5);
            this.world.func_72838_d((Entity)villager);
            return;
        }
    }

    private void determineStructuresToGenerate() {
        for (TownTemplate.TownStructureEntry e : this.template.getUniqueStructureEntries()) {
            StructureTemplateManager.getTemplate(e.templateName).ifPresent(this.uniqueTemplatesToGenerate::add);
        }
        for (TownTemplate.TownStructureEntry e : this.template.getMainStructureEntries()) {
            StructureTemplateManager.getTemplate(e.templateName).ifPresent(this.mainTemplatesToGenerate::add);
        }
        for (TownTemplate.TownStructureEntry e : this.template.getHouseStructureEntries()) {
            StructureTemplateManager.getTemplate(e.templateName).ifPresent(t -> {
                for (int i = 0; i < e.min; ++i) {
                    this.houseTemplatesToGenerate.add((StructureTemplate)t);
                }
            });
        }
        for (TownTemplate.TownStructureEntry e : this.template.getCosmeticEntries()) {
            StructureTemplateManager.getTemplate(e.templateName).ifPresent(t -> {
                for (int i = 0; i < e.min; ++i) {
                    this.cosmeticTemplatesToGenerate.add((StructureTemplate)t);
                }
            });
        }
        for (TownTemplate.TownStructureEntry e : this.template.getExteriorStructureEntries()) {
            StructureTemplateManager.getTemplate(e.templateName).ifPresent(t -> {
                for (int i = 0; i < e.min; ++i) {
                    this.exteriorTemplatesToGenerate.add((StructureTemplate)t);
                }
            });
        }
    }

    private void generateGrid() {
        int centerX = this.maximalBounds.getCenterX();
        int centerZ = this.maximalBounds.getCenterZ();
        int y1 = this.townBounds.min.func_177956_o();
        int y2 = this.townBounds.max.func_177956_o();
        boolean[] roadBorders = new boolean[]{true, false, false, true};
        StructureBB bb = new StructureBB(new BlockPos(this.townBounds.min.func_177958_n(), y1, this.townBounds.min.func_177952_p()), new BlockPos(centerX - 2, y2, centerZ - 2));
        TownPartQuadrant tq = new TownPartQuadrant(Direction.WEST, Direction.NORTH, bb, roadBorders, this);
        tq.subdivide(this.template.getTownBlockSize(), this.template.getTownPlotSize(), true);
        this.quadrants[0] = tq;
        roadBorders = new boolean[]{true, true, false, false};
        bb = new StructureBB(new BlockPos(centerX + 1, y1, this.townBounds.min.func_177952_p()), new BlockPos(this.townBounds.max.func_177958_n(), y2, centerZ - 2));
        tq = new TownPartQuadrant(Direction.EAST, Direction.NORTH, bb, roadBorders, this);
        tq.subdivide(this.template.getTownBlockSize(), this.template.getTownPlotSize(), true);
        this.quadrants[1] = tq;
        roadBorders = new boolean[]{false, true, true, false};
        bb = new StructureBB(new BlockPos(centerX + 1, y1, centerZ + 1), new BlockPos(this.townBounds.max.func_177958_n(), y2, this.townBounds.max.func_177952_p()));
        tq = new TownPartQuadrant(Direction.EAST, Direction.SOUTH, bb, roadBorders, this);
        tq.subdivide(this.template.getTownBlockSize(), this.template.getTownPlotSize(), true);
        this.quadrants[2] = tq;
        roadBorders = new boolean[]{false, false, true, true};
        bb = new StructureBB(new BlockPos(this.townBounds.min.func_177958_n(), y1, centerZ + 1), new BlockPos(centerX - 2, y2, this.townBounds.max.func_177952_p()));
        tq = new TownPartQuadrant(Direction.WEST, Direction.SOUTH, bb, roadBorders, this);
        tq.subdivide(this.template.getTownBlockSize(), this.template.getTownPlotSize(), true);
        this.quadrants[3] = tq;
        if (this.template.getExteriorSize() > 0) {
            this.generateExteriorGrid();
        }
    }

    private void generateExteriorGrid() {
        int centerX = this.maximalBounds.getCenterX();
        int centerZ = this.maximalBounds.getCenterZ();
        int eSize = this.template.getExteriorSize() * 16;
        int pSize = this.template.getTownPlotSize();
        int minY = this.maximalBounds.min.func_177956_o();
        int maxY = this.maximalBounds.max.func_177956_o();
        int minX = this.exteriorBounds.min.func_177958_n();
        int minZ = this.exteriorBounds.min.func_177952_p();
        int maxX = centerX - 3;
        int maxZ = this.wallsBounds.min.func_177952_p() - 1;
        boolean[] roadBorders = new boolean[]{false, false, false, false};
        StructureBB bb = new StructureBB(new BlockPos(minX, minY, minZ), new BlockPos(maxX, maxY, maxZ));
        this.externalQuadrants[0] = new TownPartQuadrant(Direction.WEST, Direction.NORTH, bb, roadBorders, this);
        minX = centerX + 2;
        minZ = this.exteriorBounds.min.func_177952_p();
        maxX = this.exteriorBounds.max.func_177958_n();
        maxZ = this.wallsBounds.min.func_177952_p() - 1;
        bb = new StructureBB(new BlockPos(minX, minY, minZ), new BlockPos(maxX, maxY, maxZ));
        this.externalQuadrants[1] = new TownPartQuadrant(Direction.EAST, Direction.NORTH, bb, roadBorders, this);
        minX = this.exteriorBounds.min.func_177958_n();
        minZ = this.wallsBounds.min.func_177952_p();
        maxX = this.wallsBounds.min.func_177958_n() - 1;
        maxZ = centerZ - 3;
        bb = new StructureBB(new BlockPos(minX, minY, minZ), new BlockPos(maxX, maxY, maxZ));
        this.externalQuadrants[2] = new TownPartQuadrant(Direction.WEST, Direction.NORTH, bb, roadBorders, this);
        minX = this.wallsBounds.max.func_177958_n() + 1;
        minZ = this.wallsBounds.min.func_177952_p();
        maxX = this.exteriorBounds.max.func_177958_n();
        maxZ = centerZ - 3;
        bb = new StructureBB(new BlockPos(minX, minY, minZ), new BlockPos(maxX, maxY, maxZ));
        this.externalQuadrants[3] = new TownPartQuadrant(Direction.EAST, Direction.NORTH, bb, roadBorders, this);
        minX = this.exteriorBounds.min.func_177958_n();
        minZ = centerZ + 2;
        maxX = this.wallsBounds.min.func_177958_n() - 1;
        maxZ = this.wallsBounds.max.func_177952_p();
        bb = new StructureBB(new BlockPos(minX, minY, minZ), new BlockPos(maxX, maxY, maxZ));
        this.externalQuadrants[4] = new TownPartQuadrant(Direction.WEST, Direction.NORTH, bb, roadBorders, this);
        minX = this.wallsBounds.max.func_177958_n() + 1;
        minZ = centerZ + 2;
        maxX = this.exteriorBounds.max.func_177958_n();
        maxZ = this.wallsBounds.max.func_177952_p();
        bb = new StructureBB(new BlockPos(minX, minY, minZ), new BlockPos(maxX, maxY, maxZ));
        this.externalQuadrants[5] = new TownPartQuadrant(Direction.EAST, Direction.NORTH, bb, roadBorders, this);
        minX = this.exteriorBounds.min.func_177958_n();
        minZ = this.wallsBounds.max.func_177952_p() + 1;
        maxX = centerX - 3;
        maxZ = this.exteriorBounds.max.func_177952_p();
        bb = new StructureBB(new BlockPos(minX, minY, minZ), new BlockPos(maxX, maxY, maxZ));
        this.externalQuadrants[6] = new TownPartQuadrant(Direction.WEST, Direction.SOUTH, bb, roadBorders, this);
        minX = centerX + 2;
        minZ = this.wallsBounds.max.func_177952_p() + 1;
        maxX = this.exteriorBounds.max.func_177958_n();
        maxZ = this.exteriorBounds.max.func_177952_p();
        bb = new StructureBB(new BlockPos(minX, minY, minZ), new BlockPos(maxX, maxY, maxZ));
        this.externalQuadrants[7] = new TownPartQuadrant(Direction.EAST, Direction.SOUTH, bb, roadBorders, this);
        for (TownPartQuadrant tq1 : this.externalQuadrants) {
            tq1.subdivide(eSize, pSize, false);
        }
    }

    private void generateRoads() {
        for (TownPartQuadrant tq : this.quadrants) {
            this.generateRoads(tq);
        }
        this.generateAdditionalRoads();
    }

    private void generateRoads(TownPartQuadrant tq) {
        int minX = tq.bb.min.func_177958_n();
        int maxX = tq.bb.max.func_177958_n();
        if (tq.hasRoadBorder(Direction.WEST)) {
            --minX;
        }
        if (tq.hasRoadBorder(Direction.EAST)) {
            ++maxX;
        }
        for (int x = minX; x <= maxX; ++x) {
            if (tq.hasRoadBorder(Direction.NORTH)) {
                this.genRoadBlock(x, tq.bb.min.func_177956_o() - 1, tq.bb.min.func_177952_p() - 1);
            }
            if (!tq.hasRoadBorder(Direction.SOUTH)) continue;
            this.genRoadBlock(x, tq.bb.min.func_177956_o() - 1, tq.bb.max.func_177952_p() + 1);
        }
        int minZ = tq.bb.min.func_177952_p();
        int maxZ = tq.bb.max.func_177952_p();
        if (tq.hasRoadBorder(Direction.NORTH)) {
            --minZ;
        }
        if (tq.hasRoadBorder(Direction.SOUTH)) {
            ++maxZ;
        }
        for (int z = minZ; z <= maxZ; ++z) {
            if (tq.hasRoadBorder(Direction.WEST)) {
                this.genRoadBlock(tq.bb.min.func_177958_n() - 1, tq.bb.min.func_177956_o() - 1, z);
            }
            if (!tq.hasRoadBorder(Direction.EAST)) continue;
            this.genRoadBlock(tq.bb.max.func_177958_n() + 1, tq.bb.min.func_177956_o() - 1, z);
        }
        for (TownPartBlock tb : tq.blocks) {
            this.generateRoads(tb);
        }
    }

    private void generateRoads(TownPartBlock tb) {
        int minX = tb.bb.min.func_177958_n();
        int maxX = tb.bb.max.func_177958_n();
        if (tb.hasRoadBorder(Direction.WEST)) {
            --minX;
        }
        if (tb.hasRoadBorder(Direction.EAST)) {
            ++maxX;
        }
        for (int x = minX; x <= maxX; ++x) {
            if (tb.hasRoadBorder(Direction.NORTH)) {
                this.genRoadBlock(x, tb.bb.min.func_177956_o() - 1, tb.bb.min.func_177952_p() - 1);
            }
            if (!tb.hasRoadBorder(Direction.SOUTH)) continue;
            this.genRoadBlock(x, tb.bb.min.func_177956_o() - 1, tb.bb.max.func_177952_p() + 1);
        }
        int minZ = tb.bb.min.func_177952_p();
        int maxZ = tb.bb.max.func_177952_p();
        if (tb.hasRoadBorder(Direction.NORTH)) {
            --minZ;
        }
        if (tb.hasRoadBorder(Direction.SOUTH)) {
            ++maxZ;
        }
        for (int z = minZ; z <= maxZ; ++z) {
            if (tb.hasRoadBorder(Direction.WEST)) {
                this.genRoadBlock(tb.bb.min.func_177958_n() - 1, tb.bb.min.func_177956_o() - 1, z);
            }
            if (!tb.hasRoadBorder(Direction.EAST)) continue;
            this.genRoadBlock(tb.bb.max.func_177958_n() + 1, tb.bb.min.func_177956_o() - 1, z);
        }
    }

    private void generateAdditionalRoads() {
        int z;
        int x;
        int y = this.maximalBounds.min.func_177956_o() - 1;
        int minX = this.maximalBounds.getCenterX() - 2;
        int maxX = minX + 3;
        int minZ = this.exteriorBounds.min.func_177952_p();
        int maxZ = this.townBounds.min.func_177952_p() - 1;
        for (x = minX; x <= maxX; ++x) {
            for (z = minZ; z <= maxZ; ++z) {
                this.genRoadBlock(x, y, z);
            }
        }
        minX = this.townBounds.max.func_177958_n() + 1;
        minZ = this.maximalBounds.getCenterZ() - 2;
        maxX = this.exteriorBounds.max.func_177958_n();
        maxZ = minZ + 3;
        for (x = minX; x <= maxX; ++x) {
            for (z = minZ; z <= maxZ; ++z) {
                this.genRoadBlock(x, y, z);
            }
        }
        minX = this.maximalBounds.getCenterX() - 2;
        minZ = this.townBounds.max.func_177952_p() + 1;
        maxX = minX + 3;
        maxZ = this.exteriorBounds.max.func_177952_p();
        for (x = minX; x <= maxX; ++x) {
            for (z = minZ; z <= maxZ; ++z) {
                this.genRoadBlock(x, y, z);
            }
        }
        minX = this.exteriorBounds.min.func_177958_n();
        minZ = this.maximalBounds.getCenterZ() - 2;
        maxX = this.townBounds.min.func_177958_n() - 1;
        maxZ = minZ + 3;
        for (x = minX; x <= maxX; ++x) {
            for (z = minZ; z <= maxZ; ++z) {
                this.genRoadBlock(x, y, z);
            }
        }
    }

    private void genRoadBlock(int x, int y, int z) {
        List<IBlockState> roadBlocks = this.template.getRoadFillBlocks();
        IBlockState roadBlock = roadBlocks.size() == 1 ? roadBlocks.get(0) : roadBlocks.get(this.world.field_73012_v.nextInt(roadBlocks.size()));
        BlockPos pos = new BlockPos(x, y, z);
        this.world.func_180501_a(pos, roadBlock, 3);
        this.world.func_180501_a(pos.func_177977_b(), Blocks.field_150347_e.func_176223_P(), 3);
    }

    private static class PseudoNonRepeatingIntRandom
    extends Random {
        private int lastInt = -1;

        public PseudoNonRepeatingIntRandom(long seed) {
            super(seed);
        }

        @Override
        public int nextInt(int bound) {
            int ret = super.nextInt(bound);
            int retries = 0;
            while (bound > 1 && ret == this.lastInt && retries++ < 10) {
                ret = super.nextInt(bound);
            }
            this.lastInt = ret;
            return ret;
        }
    }
}

