/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.town;

public class TownBoundingArea {
    private static final int borderSize = 8;
    int chunkMinX;
    int chunkMaxX;
    int chunkMinZ;
    int chunkMaxZ;
    int minY;
    int maxY;
    int wallSize = 3;
    int exteriorSize = 0;

    public TownBoundingArea() {
    }

    public TownBoundingArea(int chunkMinX, int chunkMinZ, int chunkMaxX, int chunkMaxZ, int minY, int maxY) {
        this.chunkMinX = chunkMinX;
        this.chunkMinZ = chunkMinZ;
        this.chunkMaxX = chunkMaxX;
        this.chunkMaxZ = chunkMaxZ;
        this.minY = minY;
        this.maxY = maxY;
    }

    public int getChunkWidth() {
        return this.chunkMaxX - this.chunkMinX + 1;
    }

    public int getChunkLength() {
        return this.chunkMaxZ - this.chunkMinZ + 1;
    }

    public int getChunkMinX() {
        return this.chunkMinX;
    }

    public int getChunkMaxX() {
        return this.chunkMaxX;
    }

    public int getChunkMinZ() {
        return this.chunkMinZ;
    }

    public int getChunkMaxZ() {
        return this.chunkMaxZ;
    }

    public int getBlockMinX() {
        return this.chunkMinX * 16;
    }

    public int getBlockMaxX() {
        return this.chunkMaxX * 16 + 15;
    }

    public int getBlockMinZ() {
        return this.chunkMinZ * 16;
    }

    public int getBlockMaxZ() {
        return this.chunkMaxZ * 16 + 15;
    }

    public int getBlockWidth() {
        return this.getBlockMaxX() - this.getBlockMinX() + 1;
    }

    public int getBlockLength() {
        return this.getBlockMaxZ() - this.getBlockMinZ() + 1;
    }

    public int getExteriorMinX() {
        return this.getBlockMinX() - 1 + 8;
    }

    public int getExteriorMaxX() {
        return this.getBlockMaxX() - 1 - 8;
    }

    public int getExteriorMinZ() {
        return this.getBlockMinZ() - 1 + 8;
    }

    public int getExteriorMaxZ() {
        return this.getBlockMaxZ() - 1 - 8;
    }

    public int getWallMinX() {
        return this.getExteriorMinX() + this.exteriorSize * 16;
    }

    public int getWallMaxX() {
        return this.getExteriorMaxX() - this.exteriorSize * 16;
    }

    public int getWallMinZ() {
        return this.getExteriorMinZ() + this.exteriorSize * 16;
    }

    public int getWallMaxZ() {
        return this.getExteriorMaxZ() - this.exteriorSize * 16;
    }

    public int getTownMinX() {
        return this.getWallMinX() + this.wallSize;
    }

    public int getTownMaxX() {
        return this.getWallMaxX() - this.wallSize;
    }

    public int getTownMinZ() {
        return this.getWallMinZ() + this.wallSize;
    }

    public int getTownMaxZ() {
        return this.getWallMaxZ() - this.wallSize;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getSurfaceY() {
        return this.minY + 3;
    }

    public int getCenterX() {
        return (this.getBlockMinX() + this.getBlockMaxX()) / 2;
    }

    public int getCenterZ() {
        return (this.getBlockMinZ() + this.getBlockMaxZ()) / 2;
    }

    public int getTownWidth() {
        return this.getTownMaxX() - this.getTownMinX() + 1;
    }

    public int getTownLength() {
        return this.getTownMaxZ() - this.getTownMinZ() + 1;
    }

    public String toString() {
        int minX = this.getBlockMinX();
        int maxX = this.getBlockMaxX();
        int minZ = this.getBlockMinZ();
        int maxZ = this.getBlockMaxZ();
        return "TownArea: " + minX + "  :" + minZ + " :: " + maxX + " : " + maxZ + " size: " + this.getBlockWidth() + " : " + this.getBlockLength();
    }

    public void setSurfaceY(int surfaceY) {
        int diff = surfaceY - this.getSurfaceY();
        this.minY += diff;
        this.maxY += diff;
    }
}

