/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.tile;

import java.util.Set;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.shadowmage.ancientwarfare.core.render.property.CoreProperties;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.block.BlockTotemPart;
import net.shadowmage.ancientwarfare.structure.tile.TileMulti;

public class TileTotemPart
extends TileMulti {
    private static final String VARIANT_TAG = "variant";
    private BlockTotemPart.Variant variant = BlockTotemPart.Variant.BASE;
    private BlockTotemPart.Variant dropVariant = BlockTotemPart.Variant.BASE;

    public void setVariant(BlockTotemPart.Variant variant) {
        this.variant = variant;
        this.dropVariant = variant;
    }

    public BlockTotemPart.Variant getVariant() {
        return this.variant;
    }

    @Override
    public void setMainBlockPos(BlockPos mainBlockPos) {
        super.setMainBlockPos(mainBlockPos);
        this.getMainBlockPos().flatMap(mainPos -> WorldTools.getTile((IBlockAccess)this.field_145850_b, mainPos, TileTotemPart.class)).ifPresent(te -> {
            this.dropVariant = te.getVariant();
        });
    }

    @Override
    protected void readNBT(NBTTagCompound compound) {
        super.readNBT(compound);
        this.variant = BlockTotemPart.Variant.fromId(compound.func_74771_c(VARIANT_TAG));
        this.getMainBlockPos().flatMap(mainPos -> WorldTools.getTile((IBlockAccess)this.field_145850_b, mainPos, TileTotemPart.class)).ifPresent(te -> {
            this.dropVariant = te.getVariant();
        });
    }

    @Override
    protected void writeNBT(NBTTagCompound compound) {
        super.writeNBT(compound);
        compound.func_74774_a(VARIANT_TAG, (byte)this.variant.getId());
    }

    @Override
    public Set<BlockPos> getAdditionalPositions(IBlockState state) {
        return this.getVariant().getAdditionalPartPositions(this.field_174879_c, (EnumFacing)state.func_177229_b((IProperty)CoreProperties.FACING));
    }

    public BlockTotemPart.Variant getDropVariant() {
        return this.dropVariant;
    }
}

