/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.tile;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.util.INBTSerializable;
import net.shadowmage.ancientwarfare.core.interfaces.ISinger;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.tile.TileUpdatable;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;
import net.shadowmage.ancientwarfare.structure.init.AWStructureBlocks;
import net.shadowmage.ancientwarfare.structure.network.PacketSoundBlockPlayerSpecValues;
import net.shadowmage.ancientwarfare.structure.util.BlockSongPlayData;

public class TileSoundBlock
extends TileUpdatable
implements ISinger,
ITickable {
    private static final long MIN_TIME_BETWEEN_ENTRY_PLAYS = 1200L;
    private int currentDelay;
    private int tuneIndex = -1;
    private int playerCheckDelay;
    private BlockSongPlayData tuneData;
    private IBlockState disguiseState;
    private boolean stoppedForAll = false;
    private Map<UUID, PersistentValues> playerSpecificValues = new HashMap<UUID, PersistentValues>();

    public TileSoundBlock() {
        this.tuneData = new BlockSongPlayData();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K || this.isStopped() || this.validateAndGetPlaying() || !this.tuneData.getTimeOfDay().takesPlaceNow(this.field_145850_b)) {
            return;
        }
        if (this.tuneData.getPlayOnPlayerEntry()) {
            this.processPlayerEntry();
        } else {
            if (this.tuneData.getWhenInRange() && !this.isPlayerInRange()) {
                return;
            }
            if (--this.currentDelay <= 0) {
                this.startSong();
                if (this.tuneData.getLimitedRepetitions() && this.incNumberOfTimesRepeated() >= this.tuneData.getRepetitions()) {
                    this.setStopped();
                }
            }
        }
    }

    private int incNumberOfTimesRepeated() {
        PersistentValues values = this.getOrCreatePlayerSpecificValues();
        values.numberOfTimesRepeated++;
        this.syncValuesToServer(values);
        return values.numberOfTimesRepeated;
    }

    private void setStopped() {
        if (this.field_145850_b.field_72995_K) {
            PersistentValues values = this.getOrCreatePlayerSpecificValues();
            values.stopped = true;
            this.syncValuesToServer(values);
        }
    }

    private void syncValuesToServer(PersistentValues values) {
        NetworkHandler.sendToServer(new PacketSoundBlockPlayerSpecValues(this.field_174879_c, values));
    }

    private boolean isStopped() {
        return this.stoppedForAll || this.field_145850_b.field_72995_K && this.getPlayerSpecificValues().map(values -> ((PersistentValues)values).stopped).orElse(false) != false;
    }

    private PersistentValues getOrCreatePlayerSpecificValues() {
        return AncientWarfareStructure.proxy.getPlayer().map(player -> {
            if (!this.playerSpecificValues.containsKey(player.func_110124_au())) {
                this.playerSpecificValues.put(player.func_110124_au(), new PersistentValues());
            }
            return this.playerSpecificValues.get(player.func_110124_au());
        }).orElse(new PersistentValues());
    }

    private Optional<PersistentValues> getPlayerSpecificValues() {
        return AncientWarfareStructure.proxy.getPlayer().map(player -> Optional.ofNullable(this.playerSpecificValues.get(player.func_110124_au()))).orElse(Optional.empty());
    }

    public void turnOffByProtectionFlag() {
        if (this.tuneData.getProtectionFlagTurnOff()) {
            this.stoppedForAll = true;
            this.func_70296_d();
            BlockTools.notifyBlockUpdate(this);
        }
    }

    private void processPlayerEntry() {
        if (this.playerCheckDelay-- <= 0) {
            this.playerCheckDelay = 20;
            if (this.isPlayerInRange()) {
                if (this.getLastTimePlayerNear() < 0L || this.field_145850_b.func_82737_E() - this.getLastTimePlayerNear() > 1200L) {
                    this.startSong();
                    if (this.tuneData.getPlayOnce()) {
                        this.setStopped();
                    } else {
                        this.setLastTimePlayerNear();
                    }
                } else {
                    this.setLastTimePlayerNear();
                }
                this.func_70296_d();
            }
        }
    }

    private void setLastTimePlayerNear() {
        PersistentValues values = this.getOrCreatePlayerSpecificValues();
        values.lastTimePlayerNear = this.field_145850_b.func_82737_E();
        this.syncValuesToServer(values);
    }

    private long getLastTimePlayerNear() {
        return this.getPlayerSpecificValues().map(PersistentValues::getLastTimePlayerNear).orElse(Long.MAX_VALUE);
    }

    private boolean isPlayerInRange() {
        return AncientWarfareStructure.proxy.getClientPlayerDistanceTo(this.field_174879_c) <= (double)this.tuneData.getPlayerRange();
    }

    private void startSong() {
        if (this.tuneData.size() == 0) {
            return;
        }
        if (this.tuneData.getIsRandom()) {
            this.tuneIndex = 0;
            if (this.tuneData.size() > 0) {
                this.tuneIndex = this.field_145850_b.field_73012_v.nextInt(this.tuneData.size());
                this.tuneData.get(this.tuneIndex).getSound().ifPresent(s -> AncientWarfareStructure.proxy.setSoundAt(this.field_174879_c, (SoundEvent)s, (float)this.tuneData.getSoundRange() / 16.0f));
            }
        } else {
            this.tuneIndex = this.tuneIndex + 1 < this.tuneData.size() ? this.tuneIndex + 1 : 0;
            this.tuneData.get(this.tuneIndex).getSound().ifPresent(s -> AncientWarfareStructure.proxy.setSoundAt(this.field_174879_c, (SoundEvent)s, (float)this.tuneData.getSoundRange() / 16.0f));
        }
        AncientWarfareStructure.proxy.playSoundAt(this.field_174879_c);
    }

    @Override
    protected void writeUpdateNBT(NBTTagCompound tag) {
        super.writeUpdateNBT(tag);
        this.func_189515_b(tag);
    }

    @Override
    protected void handleUpdateNBT(NBTTagCompound tag) {
        super.handleUpdateNBT(tag);
        this.func_145839_a(tag);
        if (this.isStopped() && AncientWarfareStructure.proxy.isSoundPlayingAt(this.field_174879_c)) {
            AncientWarfareStructure.proxy.stopSoundAt(this.field_174879_c);
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        String id;
        super.func_145839_a(tag);
        this.tuneData.readFromNBT(tag.func_74775_l("tuneData"));
        this.tuneIndex = tag.func_74762_e("tuneIndex");
        if (tag.func_74764_b("range")) {
            this.tuneData.setPlayerRange(tag.func_74762_e("range"));
        }
        if (!(id = tag.func_74779_i("block")).isEmpty()) {
            this.disguiseState = Block.func_149684_b((String)id).func_176203_a(tag.func_74762_e("meta"));
        }
        this.stoppedForAll = tag.func_74767_n("stoppedForAll");
        this.readPlayerSpecificValues(tag);
    }

    private void readPlayerSpecificValues(NBTTagCompound tag) {
        this.playerSpecificValues.clear();
        NBTTagList list = tag.func_150295_c("playerSpecificValues", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound pair = list.func_150305_b(i);
            PersistentValues values = new PersistentValues();
            values.deserializeNBT(pair.func_74775_l("values"));
            this.playerSpecificValues.put(pair.func_186857_a("playerId"), values);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("tuneData", (NBTBase)this.tuneData.writeToNBT(new NBTTagCompound()));
        tag.func_74768_a("tuneIndex", this.tuneIndex);
        if (this.disguiseState != null) {
            tag.func_74778_a("block", this.disguiseState.func_177230_c().getRegistryName().toString());
            tag.func_74768_a("meta", this.disguiseState.func_177230_c().func_176201_c(this.disguiseState));
        }
        tag.func_74757_a("stoppedForAll", this.stoppedForAll);
        this.writePlayerSpecificValues(tag);
        return tag;
    }

    private void writePlayerSpecificValues(NBTTagCompound tag) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<UUID, PersistentValues> entry : this.playerSpecificValues.entrySet()) {
            NBTTagCompound pair = new NBTTagCompound();
            pair.func_186854_a("playerId", entry.getKey());
            pair.func_74782_a("values", (NBTBase)entry.getValue().serializeNBT());
            list.func_74742_a((NBTBase)pair);
        }
        tag.func_74782_a("playerSpecificValues", (NBTBase)list);
    }

    @Override
    public BlockSongPlayData getSongs() {
        return this.tuneData;
    }

    public IBlockState getDisguiseState() {
        return this.disguiseState;
    }

    public void setDisguiseState(ItemStack itemStack) {
        Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
        if (block != AWStructureBlocks.SOUND_BLOCK && block.func_149686_d(null) && block.func_149662_c(null)) {
            this.disguiseState = block.func_176203_a(itemStack.func_77960_j());
            BlockTools.notifyBlockUpdate(this);
            this.field_145850_b.func_175722_b(this.field_174879_c, this.field_145854_h, true);
            this.func_70296_d();
        }
    }

    private boolean validateAndGetPlaying() {
        if (!AncientWarfareStructure.proxy.hasSoundAt(this.field_174879_c)) {
            return false;
        }
        boolean isPlaying = AncientWarfareStructure.proxy.isSoundPlayingAt(this.field_174879_c);
        if (!isPlaying) {
            this.resetCurrentTune();
        }
        return isPlaying;
    }

    private void resetCurrentTune() {
        this.tuneIndex = -1;
        AncientWarfareStructure.proxy.resetSoundAt(this.field_174879_c);
        if (!this.tuneData.getPlayOnPlayerEntry()) {
            int diff = Math.abs(this.tuneData.getMaxDelay() - this.tuneData.getMinDelay()) * 20;
            this.currentDelay = this.tuneData.getMinDelay() * 20 + (diff > 0 ? this.field_145850_b.field_73012_v.nextInt(diff) : 0);
        }
    }

    public void func_145843_s() {
        AncientWarfareStructure.proxy.stopSoundAt(this.field_174879_c);
        super.func_145843_s();
    }

    public void updatePlayerSpecValues(UUID playerId, boolean stopped, long lastTimePlayerNear, int numberOfTimesRepeated) {
        if (!this.playerSpecificValues.containsKey(playerId)) {
            this.playerSpecificValues.put(playerId, new PersistentValues());
        }
        PersistentValues values = this.playerSpecificValues.get(playerId);
        values.stopped = stopped;
        values.lastTimePlayerNear = lastTimePlayerNear;
        values.numberOfTimesRepeated = numberOfTimesRepeated;
        this.func_70296_d();
    }

    public void resetStateValues() {
        this.stoppedForAll = false;
        this.playerSpecificValues.clear();
        BlockTools.notifyBlockUpdate(this);
    }

    public class PersistentValues
    implements INBTSerializable<NBTTagCompound> {
        private long lastTimePlayerNear = -1L;
        private boolean stopped = false;
        private int numberOfTimesRepeated = 0;

        public boolean isStopped() {
            return this.stopped;
        }

        public int getNumberOfTimesRepeated() {
            return this.numberOfTimesRepeated;
        }

        public long getLastTimePlayerNear() {
            return this.lastTimePlayerNear;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74772_a("lastTimePlayerNear", this.lastTimePlayerNear);
            tag.func_74757_a("stopped", this.stopped);
            tag.func_74768_a("numberOfTimesRepeated", this.numberOfTimesRepeated);
            return tag;
        }

        public void deserializeNBT(NBTTagCompound tag) {
            this.lastTimePlayerNear = tag.func_74763_f("lastTimePlayerNear");
            this.stopped = tag.func_74767_n("stopped");
            this.numberOfTimesRepeated = tag.func_74762_e("numberOfTimesRepeated");
        }
    }
}

