/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.tile;

import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.tile.IBlockBreakHandler;
import net.shadowmage.ancientwarfare.core.tile.TileUpdatable;
import net.shadowmage.ancientwarfare.core.util.WorldTools;

public abstract class TileMulti
extends TileUpdatable
implements IBlockBreakHandler {
    private static final String MAIN_BLOCK_POS_TAG = "mainBlockPos";
    private BlockPos mainBlockPos = null;

    public final void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readNBT(compound);
    }

    protected void readNBT(NBTTagCompound compound) {
        if (compound.func_74764_b(MAIN_BLOCK_POS_TAG)) {
            this.mainBlockPos = BlockPos.func_177969_a((long)compound.func_74763_f(MAIN_BLOCK_POS_TAG));
        }
    }

    public final NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        this.writeNBT(compound);
        return compound;
    }

    protected void writeNBT(NBTTagCompound compound) {
        if (this.mainBlockPos != null) {
            compound.func_74772_a(MAIN_BLOCK_POS_TAG, this.mainBlockPos.func_177986_g());
        }
    }

    @Override
    protected final void writeUpdateNBT(NBTTagCompound tag) {
        super.writeUpdateNBT(tag);
        this.writeNBT(tag);
    }

    @Override
    protected final void handleUpdateNBT(NBTTagCompound tag) {
        super.handleUpdateNBT(tag);
        this.readNBT(tag);
    }

    public void setMainBlockPos(BlockPos mainBlockPos) {
        this.mainBlockPos = mainBlockPos;
    }

    public Optional<BlockPos> getMainBlockPos() {
        return Optional.ofNullable(this.mainBlockPos);
    }

    @Override
    public void onBlockBroken(IBlockState state) {
        Optional<BlockPos> mainPos = this.getMainBlockPos();
        if (mainPos.isPresent() && !mainPos.get().equals((Object)this.field_174879_c)) {
            IBlockState mainState = this.field_145850_b.func_180495_p(mainPos.get());
            if (mainState.func_177230_c() != Blocks.field_150350_a) {
                WorldTools.getTile((IBlockAccess)this.field_145850_b, mainPos.get(), TileMulti.class).ifPresent(tileMulti -> tileMulti.onBlockBroken(mainState));
                this.field_145850_b.func_175698_g(mainPos.get());
            }
            return;
        }
        this.getAdditionalPositions(state).forEach(position -> this.field_145850_b.func_175698_g(position));
    }

    public abstract Set<BlockPos> getAdditionalPositions(IBlockState var1);

    protected <T, U extends TileMulti> T getValueFromMain(Class<U> teClass, Function<U, T> getValue, T value, Supplier<T> getDefaultValue) {
        Optional<BlockPos> mainPos = this.getMainBlockPos();
        if (!mainPos.isPresent() || mainPos.get().equals((Object)this.field_174879_c)) {
            return value;
        }
        return WorldTools.getTile((IBlockAccess)this.field_145850_b, mainPos.get(), teClass).map(getValue).orElse(getDefaultValue.get());
    }

    public void setPlacementDirection(World world, BlockPos pos, IBlockState state, EnumFacing horizontalFacing, float rotationYaw) {
    }

    public void setMainPosOnAdditionalBlocks() {
        this.getAdditionalPositions(this.field_145850_b.func_180495_p(this.field_174879_c)).forEach(additionalPos -> WorldTools.getTile((IBlockAccess)this.field_145850_b, additionalPos, TileMulti.class).ifPresent(teAdditional -> teAdditional.setMainBlockPos(this.field_174879_c)));
    }
}

