/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.tile;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.EntityTools;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.block.BlockCoffin;
import net.shadowmage.ancientwarfare.structure.tile.ISpecialLootContainer;
import net.shadowmage.ancientwarfare.structure.tile.LootSettings;
import net.shadowmage.ancientwarfare.structure.tile.TileMulti;
import net.shadowmage.ancientwarfare.structure.util.LootHelper;

public abstract class TileCoffin
extends TileMulti
implements ITickable,
ISpecialLootContainer {
    protected BlockCoffin.CoffinDirection direction = BlockCoffin.CoffinDirection.NORTH;
    private boolean opening = false;
    private boolean open = false;
    private float prevLidAngle = 0.0f;
    private float lidAngle = 0.0f;
    private int openTime = 0;
    private LootSettings lootSettings = new LootSettings();
    private static final float OPEN_ANGLE = 15.0f;

    public abstract BlockCoffin.IVariant getVariant();

    @Override
    public void setPlacementDirection(World world, BlockPos pos, IBlockState state, EnumFacing horizontalFacing, float rotationYaw) {
        this.setDirection(BlockCoffin.CoffinDirection.fromFacing(horizontalFacing));
    }

    @Override
    protected void readNBT(NBTTagCompound compound) {
        super.readNBT(compound);
        this.direction = BlockCoffin.CoffinDirection.fromName(compound.func_74779_i("direction"));
        this.opening = compound.func_74767_n("opening");
        this.open = compound.func_74767_n("open");
        if (this.open) {
            this.prevLidAngle = 15.0f;
            this.lidAngle = 15.0f;
        }
        this.lootSettings = LootSettings.deserializeNBT(compound.func_74775_l("lootSettings"));
    }

    @Override
    protected void writeNBT(NBTTagCompound compound) {
        super.writeNBT(compound);
        compound.func_74778_a("direction", this.direction.func_176610_l());
        compound.func_74757_a("opening", this.opening);
        compound.func_74757_a("open", this.open);
        compound.func_74782_a("lootSettings", (NBTBase)this.lootSettings.serializeNBT());
    }

    public void setDirection(BlockCoffin.CoffinDirection direction) {
        this.direction = direction;
    }

    public BlockCoffin.CoffinDirection getDirection() {
        return this.direction;
    }

    public void open() {
        Optional<BlockPos> mainPos = this.getMainBlockPos();
        if (!mainPos.isPresent() || mainPos.get().equals((Object)this.field_174879_c)) {
            if (!this.open && !this.opening) {
                this.playSound();
                this.opening = true;
                BlockTools.notifyBlockUpdate(this);
            }
            return;
        }
        WorldTools.getTile((IBlockAccess)this.field_145850_b, mainPos.get(), TileCoffin.class).ifPresent(TileCoffin::open);
    }

    protected abstract void playSound();

    private void dropLoot(@Nullable EntityPlayer player) {
        if (this.field_145850_b.field_72995_K || this.isOpen()) {
            return;
        }
        Optional<BlockPos> mainPos = this.getMainBlockPos();
        if (!mainPos.isPresent() || mainPos.get().equals((Object)this.field_174879_c)) {
            LootHelper.dropLoot(this, player);
            return;
        }
        WorldTools.getTile((IBlockAccess)this.field_145850_b, mainPos.get(), TileCoffin.class).ifPresent(te -> te.dropLoot(player));
    }

    private boolean isOpen() {
        return this.getValueFromMain(TileCoffin.class, TileCoffin::isOpen, this.open, () -> true);
    }

    @Override
    public void onBlockBroken(IBlockState state) {
        this.dropLoot(EntityTools.findClosestPlayer(this.field_145850_b, this.field_174879_c, 100));
        super.onBlockBroken(state);
    }

    public void func_73660_a() {
        if (this.opening && !this.open) {
            this.prevLidAngle = this.lidAngle;
            ++this.openTime;
            float halfAngle = 7.5f;
            float halfTime = (float)this.getTotalOpenTime() / 2.0f;
            if ((float)this.openTime > halfTime) {
                float ratio = (float)(this.getTotalOpenTime() - this.openTime) / halfTime;
                this.lidAngle = 15.0f - halfAngle * ratio * ratio;
            } else {
                float ratio = (float)this.openTime / halfTime;
                this.lidAngle = halfAngle * ratio * ratio;
            }
            if (this.lidAngle >= 15.0f) {
                this.dropLoot(EntityTools.findClosestPlayer(this.field_145850_b, this.field_174879_c, 100));
                this.prevLidAngle = this.lidAngle;
                this.open = true;
            }
        }
    }

    protected abstract int getTotalOpenTime();

    public float getPrevLidAngle() {
        return this.prevLidAngle;
    }

    public float getLidAngle() {
        return this.lidAngle;
    }

    @Override
    public void setLootSettings(LootSettings settings) {
        this.lootSettings = settings;
    }

    @Override
    public LootSettings getLootSettings() {
        return this.getValueFromMain(TileCoffin.class, TileCoffin::getLootSettings, this.lootSettings, LootSettings::new);
    }
}

