/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.tile;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.shadowmage.ancientwarfare.core.util.EntityTools;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFaction;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFactionArcher;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFactionLeader;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFactionMounted;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFactionPriest;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFactionSiegeEngineer;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFactionSoldier;
import net.shadowmage.ancientwarfare.npc.faction.FactionTracker;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.init.AWStructureBlocks;
import net.shadowmage.ancientwarfare.structure.util.CapabilityRespawnData;
import net.shadowmage.ancientwarfare.structure.util.IRespawnData;

public class SpawnerSettings {
    private static final String RESPOND_TO_REDSTONE_TAG = "respondToRedstone";
    private static final String REDSTONE_MODE_TAG = "redstoneMode";
    private static final String PREV_REDSTONE_STATE_TAG = "prevRedstoneState";
    private static final String MIN_DELAY_TAG = "minDelay";
    private static final String MAX_DELAY_TAG = "maxDelay";
    private static final String SPAWN_DELAY_TAG = "spawnDelay";
    private static final String PLAYER_RANGE_TAG = "playerRange";
    private static final String MOB_RANGE_TAG = "mobRange";
    private static final String SPAWN_RANGE_TAG = "spawnRange";
    private static final String MAX_NEARBY_MONSTERS_TAG = "maxNearbyMonsters";
    private static final String XP_TO_DROP_TAG = "xpToDrop";
    private static final String LIGHT_SENSITIVE_TAG = "lightSensitive";
    private static final String TRANSPARENT_TAG = "transparent";
    private static final String DEBUG_MODE_TAG = "debugMode";
    private static final String SPAWN_GROUPS_TAG = "spawnGroups";
    private static final String INVENTORY_TAG = "inventory";
    private static final String HOSTILE_TAG = "hostile";
    private static final String FACTION_NAME_TAG = "factionName";
    private static final String SPAWN_Y_OFFSET_TAG = "spawnYOffset";
    private List<EntitySpawnGroup> spawnGroups = new ArrayList<EntitySpawnGroup>();
    private ItemStackHandler inventory = new ItemStackHandler(9);
    private boolean debugMode;
    private boolean transparent;
    private boolean respondToRedstone;
    private boolean redstoneMode;
    private boolean prevRedstoneState;
    private int playerRange;
    private int mobRange;
    private int range = 4;
    private int maxDelay = 400;
    private int minDelay = 200;
    private int spawnDelay = this.maxDelay;
    private int maxNearbyMonsters;
    private boolean lightSensitive;
    private int xpToDrop;
    private int spawnYOffset = 0;
    private boolean isOneShotSpawner;
    private String factionName = "";
    float blockHardness = 2.0f;
    private World world;
    private BlockPos pos;
    private static final Set<Class<? extends Entity>> HOSTILE_NPC_CLASS_TYPES = ImmutableSet.of(NpcFactionLeader.class, NpcFactionPriest.class, NpcFactionArcher.class, NpcFactionSiegeEngineer.class, NpcFactionMounted.class, NpcFactionSoldier.class, (Object[])new Class[0]);

    public boolean hasWorld() {
        return this.world != null;
    }

    public static SpawnerSettings getDefaultSettings() {
        SpawnerSettings settings = new SpawnerSettings();
        settings.playerRange = 16;
        settings.mobRange = 4;
        settings.maxNearbyMonsters = 8;
        EntitySpawnGroup group = new EntitySpawnGroup(settings);
        group.addSpawnSetting(new EntitySpawnSettings(group));
        settings.addSpawnGroup(group);
        return settings;
    }

    void setWorld(World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
    }

    void onUpdate() {
        if (!this.respondToRedstone) {
            this.updateNormalMode();
        } else if (this.redstoneMode) {
            this.updateRedstoneModePulse();
        } else {
            this.updateRedstoneModeToggle();
        }
        if (this.spawnGroups.isEmpty()) {
            this.world.func_175698_g(this.pos);
        }
    }

    private void updateRedstoneModeToggle() {
        boolean bl = this.prevRedstoneState = this.world.func_175687_A(this.pos) > 0 || this.world.func_175676_y(this.pos) > 0;
        if (this.respondToRedstone && !this.redstoneMode && !this.prevRedstoneState) {
            return;
        }
        this.updateNormalMode();
    }

    private void updateRedstoneModePulse() {
        boolean powered;
        boolean bl = powered = this.world.func_175687_A(this.pos) > 0 || this.world.func_175676_y(this.pos) > 0;
        if (!this.prevRedstoneState && powered) {
            this.spawnEntities();
        }
        this.prevRedstoneState = powered;
    }

    private void updateNormalMode() {
        if (this.spawnDelay > 0) {
            --this.spawnDelay;
        }
        if (this.spawnDelay <= 0) {
            int delayRange = this.maxDelay - this.minDelay;
            this.spawnDelay = this.minDelay + (delayRange <= 0 ? 0 : this.world.field_73012_v.nextInt(delayRange));
            this.spawnEntities();
        }
    }

    private void spawnEntities() {
        if (this.checkSpawnConditions()) {
            return;
        }
        int totalWeight = 0;
        for (EntitySpawnGroup group : this.spawnGroups) {
            totalWeight += group.groupWeight;
        }
        int rand = totalWeight == 0 ? 0 : this.world.field_73012_v.nextInt(totalWeight);
        int check = 0;
        EntitySpawnGroup toSpawn = null;
        int index = 0;
        for (EntitySpawnGroup group : this.spawnGroups) {
            if (rand < (check += group.groupWeight)) {
                toSpawn = group;
                break;
            }
            ++index;
        }
        if (toSpawn != null) {
            toSpawn.spawnEntities(this.world, this.pos, index, this.spawnYOffset, this.range);
            if (toSpawn.shouldRemove()) {
                this.spawnGroups.remove(toSpawn);
            }
        }
    }

    private boolean checkSpawnConditions() {
        if (this.checkLight()) {
            return true;
        }
        if (!this.checkPlayerConditions()) {
            return true;
        }
        return this.checkNearbyMobs();
    }

    private boolean checkLight() {
        if (this.lightSensitive) {
            int light = this.world.func_180495_p(this.pos).getLightValue((IBlockAccess)this.world, this.pos);
            return light >= 8;
        }
        return false;
    }

    private boolean checkNearbyMobs() {
        int nearbyCount;
        if (this.maxNearbyMonsters > 0 && this.mobRange > 0 && (nearbyCount = this.world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.pos, this.pos.func_177982_a(1, 1, 1)).func_72314_b((double)this.mobRange, (double)this.mobRange, (double)this.mobRange)).size()) >= this.maxNearbyMonsters) {
            AncientWarfareStructure.LOG.debug("skipping spawning because of too many nearby entities");
            return true;
        }
        return false;
    }

    private boolean checkPlayerConditions() {
        if (this.playerRange > 0) {
            List<EntityPlayer> nearbyPlayers = this.getPlayersWithinAABB();
            if (nearbyPlayers.isEmpty()) {
                return false;
            }
            for (EntityPlayer player : nearbyPlayers) {
                if (!this.debugMode && (player.func_184812_l_() || player.func_175149_v()) || this.isContinuousSpawnerOfFriendlyFaction(player)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isContinuousSpawnerOfFriendlyFaction(EntityPlayer player) {
        return !this.isOneShotSpawner && !this.factionName.isEmpty() && !FactionTracker.INSTANCE.isHostileToPlayer(this.world, player.func_110124_au(), player.func_70005_c_(), this.factionName);
    }

    private List<EntityPlayer> getPlayersWithinAABB() {
        ArrayList<EntityPlayer> players = new ArrayList<EntityPlayer>();
        for (EntityPlayer player : this.world.field_73010_i) {
            if (!player.func_174813_aQ().func_72326_a(new AxisAlignedBB(this.pos, this.pos.func_177982_a(1, 1, 1)).func_72314_b((double)this.playerRange, (double)this.playerRange, (double)this.playerRange))) continue;
            players.add(player);
        }
        return players;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74757_a(RESPOND_TO_REDSTONE_TAG, this.respondToRedstone);
        if (this.respondToRedstone) {
            tag.func_74757_a(REDSTONE_MODE_TAG, this.redstoneMode);
            tag.func_74757_a(PREV_REDSTONE_STATE_TAG, this.prevRedstoneState);
        }
        tag.func_74768_a(MIN_DELAY_TAG, this.minDelay);
        tag.func_74768_a(MAX_DELAY_TAG, this.maxDelay);
        tag.func_74768_a(SPAWN_DELAY_TAG, this.spawnDelay);
        tag.func_74768_a(PLAYER_RANGE_TAG, this.playerRange);
        tag.func_74768_a(MOB_RANGE_TAG, this.mobRange);
        tag.func_74768_a(SPAWN_RANGE_TAG, this.range);
        tag.func_74768_a(MAX_NEARBY_MONSTERS_TAG, this.maxNearbyMonsters);
        tag.func_74768_a(XP_TO_DROP_TAG, this.xpToDrop);
        tag.func_74757_a(LIGHT_SENSITIVE_TAG, this.lightSensitive);
        tag.func_74757_a(TRANSPARENT_TAG, this.transparent);
        tag.func_74757_a(DEBUG_MODE_TAG, this.debugMode);
        NBTTagList groupList = new NBTTagList();
        for (EntitySpawnGroup group : this.spawnGroups) {
            NBTTagCompound groupTag = new NBTTagCompound();
            group.writeToNBT(groupTag);
            groupList.func_74742_a((NBTBase)groupTag);
        }
        tag.func_74782_a(SPAWN_GROUPS_TAG, (NBTBase)groupList);
        tag.func_74782_a(INVENTORY_TAG, (NBTBase)this.inventory.serializeNBT());
        tag.func_74768_a(SPAWN_Y_OFFSET_TAG, this.spawnYOffset);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.spawnGroups.clear();
        this.respondToRedstone = tag.func_74767_n(RESPOND_TO_REDSTONE_TAG);
        if (this.respondToRedstone) {
            this.redstoneMode = tag.func_74767_n(REDSTONE_MODE_TAG);
            this.prevRedstoneState = tag.func_74767_n(PREV_REDSTONE_STATE_TAG);
        }
        this.minDelay = Math.max(tag.func_74762_e(MIN_DELAY_TAG), 10);
        this.maxDelay = Math.max(tag.func_74762_e(MAX_DELAY_TAG), 10);
        this.spawnDelay = tag.func_74762_e(SPAWN_DELAY_TAG);
        this.playerRange = tag.func_74762_e(PLAYER_RANGE_TAG);
        this.mobRange = tag.func_74762_e(MOB_RANGE_TAG);
        this.range = tag.func_74762_e(SPAWN_RANGE_TAG);
        this.maxNearbyMonsters = tag.func_74762_e(MAX_NEARBY_MONSTERS_TAG);
        this.xpToDrop = tag.func_74762_e(XP_TO_DROP_TAG);
        this.lightSensitive = tag.func_74767_n(LIGHT_SENSITIVE_TAG);
        this.transparent = tag.func_74767_n(TRANSPARENT_TAG);
        this.debugMode = tag.func_74767_n(DEBUG_MODE_TAG);
        NBTTagList groupList = tag.func_150295_c(SPAWN_GROUPS_TAG, 10);
        for (int i = 0; i < groupList.func_74745_c(); ++i) {
            EntitySpawnGroup group = new EntitySpawnGroup(this);
            group.readFromNBT(groupList.func_150305_b(i));
            this.spawnGroups.add(group);
        }
        if (tag.func_74764_b(INVENTORY_TAG)) {
            this.inventory.deserializeNBT(tag.func_74775_l(INVENTORY_TAG));
        }
        if (tag.func_74764_b(SPAWN_Y_OFFSET_TAG)) {
            this.spawnYOffset = tag.func_74762_e(SPAWN_Y_OFFSET_TAG);
        }
        this.updateSpawnProperties();
    }

    void updateSpawnProperties() {
        if (this.world == null || this.world.field_72995_K) {
            return;
        }
        this.isOneShotSpawner = false;
        this.factionName = "";
        if (this.spawnGroups.size() == 1 && this.spawnGroups.get(0).entitiesToSpawn.size() == 1) {
            Entity entity;
            EntitySpawnSettings entitySettings = (EntitySpawnSettings)this.spawnGroups.get(0).entitiesToSpawn.get(0);
            if (entitySettings.maxToSpawn == 1 && entitySettings.minToSpawn == 1 && entitySettings.remainingSpawnCount == 1) {
                this.isOneShotSpawner = true;
            }
            this.factionName = (entity = EntityList.func_188429_b((ResourceLocation)entitySettings.entityId, (World)this.world)) instanceof NpcFaction ? entitySettings.customTag.func_74779_i(FACTION_NAME_TAG) : "";
        }
    }

    public void addSpawnGroup(EntitySpawnGroup group) {
        this.spawnGroups.add(group);
    }

    public List<EntitySpawnGroup> getSpawnGroups() {
        return this.spawnGroups;
    }

    public final boolean isLightSensitive() {
        return this.lightSensitive;
    }

    public final void toggleLightSensitive() {
        this.lightSensitive = !this.lightSensitive;
    }

    public final boolean isRespondToRedstone() {
        return this.respondToRedstone;
    }

    public final void toggleRespondToRedstone() {
        this.respondToRedstone = !this.respondToRedstone;
    }

    public final boolean getRedstoneMode() {
        return this.redstoneMode;
    }

    public final void toggleRedstoneMode() {
        this.redstoneMode = !this.redstoneMode;
    }

    public final int getPlayerRange() {
        return this.playerRange;
    }

    public final void setPlayerRange(int playerRange) {
        this.playerRange = playerRange;
    }

    public final int getMobRange() {
        return this.mobRange;
    }

    public final void setMobRange(int mobRange) {
        this.mobRange = mobRange;
    }

    public final int getSpawnRange() {
        return this.range;
    }

    public final void setSpawnRange(int range) {
        this.range = range;
    }

    public final int getMaxDelay() {
        return this.maxDelay;
    }

    public final void setMaxDelay(int maxDelay) {
        if (this.minDelay > maxDelay) {
            this.minDelay = maxDelay;
        }
        this.maxDelay = maxDelay;
    }

    public final int getMinDelay() {
        return this.minDelay;
    }

    public final void setMinDelay(int minDelay) {
        if (minDelay > this.maxDelay) {
            this.maxDelay = minDelay;
        }
        this.minDelay = minDelay;
    }

    public final int getSpawnDelay() {
        return this.spawnDelay;
    }

    public final void setSpawnDelay(int spawnDelay) {
        if (spawnDelay > this.maxDelay) {
            this.maxDelay = spawnDelay;
        }
        if (spawnDelay < this.minDelay) {
            this.minDelay = spawnDelay;
        }
        this.spawnDelay = spawnDelay;
    }

    public final int getMaxNearbyMonsters() {
        return this.maxNearbyMonsters;
    }

    public final void setMaxNearbyMonsters(int maxNearbyMonsters) {
        this.maxNearbyMonsters = maxNearbyMonsters;
    }

    public final void setXpToDrop(int xp) {
        this.xpToDrop = xp;
    }

    public final void setBlockHardness(float hardness) {
        this.blockHardness = hardness;
    }

    public final int getXpToDrop() {
        return this.xpToDrop;
    }

    public final float getBlockHardness() {
        return this.blockHardness;
    }

    public final IItemHandler getInventory() {
        return this.inventory;
    }

    public final boolean isDebugMode() {
        return this.debugMode;
    }

    public final void toggleDebugMode() {
        this.debugMode = !this.debugMode;
    }

    public final boolean isTransparent() {
        return this.transparent;
    }

    public final void toggleTransparent() {
        this.transparent = !this.transparent;
    }

    public void setPos(BlockPos posIn) {
        this.pos = posIn;
    }

    public int getSpawnYOffset() {
        return this.spawnYOffset;
    }

    public void setSpawnYOffset(int spawnYOffset) {
        this.spawnYOffset = spawnYOffset;
    }

    public static boolean spawnsHostileNpcs(SpawnerSettings spawnerSettings) {
        return spawnerSettings.spawnsEntity(spawnerSettings::isHostileNpc);
    }

    private boolean isHostileNpc(Class<? extends Entity> entityClass) {
        return HOSTILE_NPC_CLASS_TYPES.stream().anyMatch(entityClass::isAssignableFrom);
    }

    private boolean spawnsEntity(Predicate<Class<? extends Entity>> isEntityOfType) {
        List<EntitySpawnGroup> groups = this.getSpawnGroups();
        if (groups.isEmpty()) {
            return false;
        }
        EntitySpawnGroup firstGroup = groups.get(0);
        List<EntitySpawnSettings> spawnEntities = firstGroup.getEntitiesToSpawn();
        if (spawnEntities.isEmpty()) {
            return false;
        }
        EntityEntry entityEntry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(spawnEntities.get(0).getEntityId());
        return entityEntry != null && isEntityOfType.test(entityEntry.getEntityClass());
    }

    public static final class EntitySpawnSettings {
        private static final String ENTITY_ID_TAG = "entityId";
        private static final String CUSTOM_TAG = "customTag";
        private static final String MIN_TO_SPAWN_TAG = "minToSpawn";
        private static final String MAX_TO_SPAWN_TAG = "maxToSpawn";
        private static final String REMAINING_SPAWN_COUNT_TAG = "remainingSpawnCount";
        private static final String CUSTOM_NAME_TAG = "CustomName";
        private ResourceLocation entityId = new ResourceLocation("pig");
        private NBTTagCompound customTag;
        private int minToSpawn = 2;
        private int maxToSpawn = 4;
        int remainingSpawnCount = -1;
        private boolean hostile = true;
        private EntitySpawnGroup group;
        private static final Method CAN_DESPAWN = ObfuscationReflectionHelper.findMethod(EntityLiving.class, (String)"func_70692_ba", Boolean.TYPE, (Class[])new Class[0]);

        public EntitySpawnSettings(EntitySpawnGroup group) {
            this.group = group;
        }

        private EntitySpawnGroup getParentSettings() {
            return this.group;
        }

        public final void writeToNBT(NBTTagCompound tag) {
            tag.func_74757_a(SpawnerSettings.HOSTILE_TAG, this.hostile);
            tag.func_74778_a(ENTITY_ID_TAG, this.entityId.toString());
            if (this.customTag != null) {
                tag.func_74782_a(CUSTOM_TAG, (NBTBase)this.customTag);
            }
            tag.func_74768_a(MIN_TO_SPAWN_TAG, this.minToSpawn);
            tag.func_74768_a(MAX_TO_SPAWN_TAG, this.maxToSpawn);
            tag.func_74768_a(REMAINING_SPAWN_COUNT_TAG, this.remainingSpawnCount);
        }

        public final void readFromNBT(NBTTagCompound tag) {
            this.hostile = !tag.func_74764_b(SpawnerSettings.HOSTILE_TAG) || tag.func_74767_n(SpawnerSettings.HOSTILE_TAG);
            this.remainingSpawnCount = tag.func_74762_e(REMAINING_SPAWN_COUNT_TAG);
            this.setEntityToSpawn(new ResourceLocation(tag.func_74779_i(ENTITY_ID_TAG)));
            if (tag.func_74764_b(CUSTOM_TAG)) {
                this.customTag = tag.func_74775_l(CUSTOM_TAG);
            }
            this.minToSpawn = tag.func_74762_e(MIN_TO_SPAWN_TAG);
            this.maxToSpawn = tag.func_74762_e(MAX_TO_SPAWN_TAG);
        }

        public final void setEntityToSpawn(Entity entity) {
            this.hostile = !(entity instanceof EntityAgeable);
            ResourceLocation registryName = EntityRegistry.getEntry(entity.getClass()).getRegistryName();
            this.setEntityToSpawn(registryName);
        }

        public final void setEntityToSpawn(ResourceLocation entityId) {
            this.entityId = entityId;
            if (!ForgeRegistries.ENTITIES.containsKey(this.entityId)) {
                if (this.hostile) {
                    AncientWarfareStructure.LOG.debug("{} is not a valid entityId.  Spawner default to Zombie.", (Object)entityId);
                    this.entityId = new ResourceLocation("zombie");
                } else {
                    this.remainingSpawnCount = 0;
                }
            }
            if (AWStructureStatics.excludedSpawnerEntities.contains(this.entityId.toString())) {
                if (this.hostile) {
                    AncientWarfareStructure.LOG.warn("{} has been set as an invalid entity for spawners!  Spawner default to Zombie.", (Object)entityId);
                    this.entityId = new ResourceLocation("zombie");
                } else {
                    this.remainingSpawnCount = 0;
                }
            }
        }

        public final void setCustomSpawnTag(@Nullable NBTTagCompound tag) {
            this.customTag = tag;
        }

        public final void setSpawnCountMin(int min) {
            this.minToSpawn = min;
        }

        public final void setSpawnCountMax(int max) {
            this.maxToSpawn = Math.max(this.minToSpawn, max);
        }

        public final void setSpawnLimitTotal(int total) {
            this.remainingSpawnCount = total;
        }

        private boolean shouldRemove() {
            return this.remainingSpawnCount == 0;
        }

        public final ResourceLocation getEntityId() {
            return this.entityId;
        }

        public final String getEntityName() {
            if (this.customTag != null && this.customTag.func_74764_b(SpawnerSettings.FACTION_NAME_TAG)) {
                return EntityTools.getUnlocName(this.entityId).replace("faction", this.getCustomTag().func_74779_i(SpawnerSettings.FACTION_NAME_TAG));
            }
            return EntityTools.getUnlocName(this.entityId);
        }

        public final Optional<String> getCustomName() {
            if (this.customTag != null && this.customTag.func_74764_b(CUSTOM_NAME_TAG)) {
                return Optional.of(this.customTag.func_74779_i(CUSTOM_NAME_TAG));
            }
            return Optional.empty();
        }

        public final int getSpawnMin() {
            return this.minToSpawn;
        }

        public final int getSpawnMax() {
            return this.maxToSpawn;
        }

        public final int getSpawnTotal() {
            return this.remainingSpawnCount;
        }

        public final NBTTagCompound getCustomTag() {
            return this.customTag;
        }

        private int getNumToSpawn(Random rand) {
            int randRange = this.maxToSpawn - this.minToSpawn;
            int toSpawn = randRange <= 0 ? this.minToSpawn : this.minToSpawn + rand.nextInt(randRange);
            if (this.remainingSpawnCount >= 0 && toSpawn > this.remainingSpawnCount) {
                toSpawn = this.remainingSpawnCount;
            }
            return toSpawn;
        }

        private void spawnEntities(World world, BlockPos spawnPos, int range) {
            int toSpawn = this.getNumToSpawn(world.field_73012_v);
            for (int i = 0; i < toSpawn; ++i) {
                Entity e = EntityList.func_188429_b((ResourceLocation)this.entityId, (World)world);
                if (e == null) {
                    return;
                }
                boolean doSpawn = this.findAndSetSpawnLocation(world, spawnPos, range, e);
                if (!doSpawn) continue;
                this.spawnEntityAt(e, world);
                if (this.remainingSpawnCount <= 0) continue;
                --this.remainingSpawnCount;
            }
        }

        private boolean findAndSetSpawnLocation(World world, BlockPos spawnPos, int range, Entity e) {
            for (int spawnTry = 0; spawnTry < range + 5; ++spawnTry) {
                int x = spawnPos.func_177958_n() - range + world.field_73012_v.nextInt(range * 2 + 1);
                int z = spawnPos.func_177952_p() - range + world.field_73012_v.nextInt(range * 2 + 1);
                for (int y = spawnPos.func_177956_o() - range; y <= spawnPos.func_177956_o() + range; ++y) {
                    e.func_70012_b((double)x + 0.5, (double)y, (double)z + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                    if (range != 0 && !this.checkEntityIsNotColliding(e)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean checkEntityIsNotColliding(Entity e) {
            return e.field_70170_p.func_184144_a(e, e.func_174813_aQ()).isEmpty() && e.field_70170_p.func_72917_a(e.func_174813_aQ(), e);
        }

        private boolean canDespawn(Entity e) {
            if (!(e instanceof EntityLiving)) {
                return true;
            }
            try {
                return (Boolean)CAN_DESPAWN.invoke((Object)e, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                AncientWarfareStructure.LOG.error("Error calling canDespawn on entity: ", (Throwable)ex);
                return true;
            }
        }

        private void spawnEntityAt(Entity e, World world) {
            if (e instanceof EntityLiving) {
                ((EntityLiving)e).func_180482_a(world.func_175649_E(e.func_180425_c()), null);
                ((EntityLiving)e).func_70656_aK();
            }
            this.setDataFromTag(e);
            e.func_184216_O().add("noSpawnPrevention");
            world.func_72838_d(e);
            this.setDataFromTag(e);
            if (e instanceof NpcFaction) {
                ((NpcFaction)e).setCanDespawn();
            }
            if (this.getParentSettings().getParentSettings().isOneShotSpawner && this.canDespawn(e)) {
                this.setRespawnData(e);
            }
        }

        private void setRespawnData(Entity e) {
            if (e.hasCapability(CapabilityRespawnData.RESPAWN_DATA_CAPABILITY, null)) {
                IRespawnData respawnData = (IRespawnData)e.getCapability(CapabilityRespawnData.RESPAWN_DATA_CAPABILITY, null);
                respawnData.setRespawnPos(e.func_180425_c());
                respawnData.setSpawnerSettings(this.getParentSettings().getParentSettings().writeToNBT(new NBTTagCompound()));
                respawnData.setSpawnTime(e.field_70170_p.func_82737_E());
            }
        }

        private void setDataFromTag(Entity e) {
            if (this.customTag != null) {
                NBTTagCompound temp = new NBTTagCompound();
                e.func_189511_e(temp);
                Set keys = this.customTag.func_150296_c();
                for (String key : keys) {
                    temp.func_74782_a(key, this.customTag.func_74781_a(key));
                }
                e.func_70020_e(temp);
                if (e instanceof NpcFaction && this.customTag.func_74764_b(SpawnerSettings.FACTION_NAME_TAG)) {
                    ((NpcFaction)e).setFactionNameAndDefaults(this.customTag.func_74779_i(SpawnerSettings.FACTION_NAME_TAG));
                }
            }
        }
    }

    public static final class EntitySpawnGroup {
        private int groupWeight = 1;
        private List<EntitySpawnSettings> entitiesToSpawn = new ArrayList<EntitySpawnSettings>();
        private SpawnerSettings settings;

        public EntitySpawnGroup(SpawnerSettings settings) {
            this.settings = settings;
        }

        public SpawnerSettings getParentSettings() {
            return this.settings;
        }

        public void setWeight(int weight) {
            this.groupWeight = weight <= 0 ? 1 : weight;
        }

        public void addSpawnSetting(EntitySpawnSettings setting) {
            this.entitiesToSpawn.add(setting);
        }

        private void spawnEntities(World world, BlockPos spawnPos, int grpIndex, int yOffset, int range) {
            EntitySpawnSettings entitySpawnSettings;
            spawnPos = spawnPos.func_177982_a(0, yOffset, 0);
            Iterator<EntitySpawnSettings> it = this.entitiesToSpawn.iterator();
            int index = 0;
            while (it.hasNext() && (entitySpawnSettings = it.next()) != null) {
                entitySpawnSettings.spawnEntities(world, spawnPos, range);
                if (entitySpawnSettings.shouldRemove()) {
                    it.remove();
                }
                int a1 = 0;
                int b2 = entitySpawnSettings.remainingSpawnCount;
                int a = a1 << 16 | grpIndex & 0xFFFF;
                int b = index << 16 | b2 & 0xFFFF;
                world.func_175641_c(spawnPos, AWStructureBlocks.ADVANCED_SPAWNER, a, b);
                ++index;
            }
        }

        private boolean shouldRemove() {
            return this.entitiesToSpawn.isEmpty();
        }

        public List<EntitySpawnSettings> getEntitiesToSpawn() {
            return this.entitiesToSpawn;
        }

        public int getWeight() {
            return this.groupWeight;
        }

        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74768_a("groupWeight", this.groupWeight);
            NBTTagList settingsList = new NBTTagList();
            for (EntitySpawnSettings setting : this.entitiesToSpawn) {
                NBTTagCompound settingTag = new NBTTagCompound();
                setting.writeToNBT(settingTag);
                settingsList.func_74742_a((NBTBase)settingTag);
            }
            tag.func_74782_a("settingsList", (NBTBase)settingsList);
        }

        public void readFromNBT(NBTTagCompound tag) {
            this.groupWeight = tag.func_74762_e("groupWeight");
            NBTTagList settingsList = tag.func_150295_c("settingsList", 10);
            for (int i = 0; i < settingsList.func_74745_c(); ++i) {
                EntitySpawnSettings setting = new EntitySpawnSettings(this);
                setting.readFromNBT(settingsList.func_150305_b(i));
                if (setting.shouldRemove()) continue;
                this.entitiesToSpawn.add(setting);
            }
        }
    }
}

