/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.tile;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.item.ItemStructureScanner;
import net.shadowmage.ancientwarfare.structure.tile.TileStructureScanner;

public class ScannerTracker {
    private static Map<String, Tuple<Integer, BlockPos>> scannerPositions = new HashMap<String, Tuple<Integer, BlockPos>>();
    private static ScannerExporter scannerExporter = new ScannerExporter();

    private ScannerTracker() {
    }

    public static void registerScanner(TileStructureScanner scanner) {
        ItemStack scannerStack = scanner.getScannerInventory().getStackInSlot(0);
        String name = ItemStructureScanner.getStructureName(scannerStack);
        if (!name.isEmpty() && !scannerPositions.containsKey(name)) {
            scannerPositions.put(name, (Tuple<Integer, BlockPos>)new Tuple((Object)scanner.func_145831_w().field_73011_w.getDimension(), (Object)scanner.func_174877_v()));
        }
    }

    public static Set<String> getTrackedScannerNames() {
        return scannerPositions.keySet();
    }

    public static Tuple<Integer, BlockPos> getScannerPosByName(String name) {
        return scannerPositions.get(name);
    }

    public static void teleportAboveScannerBlock(EntityPlayer player, Tuple<Integer, BlockPos> pos) {
        if (player.func_130014_f_().field_73011_w.getDimension() == ((Integer)pos.func_76341_a()).intValue()) {
            BlockPos aboveScanner = ((BlockPos)pos.func_76340_b()).func_177984_a();
            player.func_70634_a((double)aboveScanner.func_177958_n() + 0.5, (double)aboveScanner.func_177956_o(), (double)aboveScanner.func_177952_p() + 0.5);
        }
    }

    public static void reexportAll(EntityPlayer player, boolean reloadMainSettings) {
        scannerExporter.startExport(player, reloadMainSettings);
    }

    private static class ScannerExporter {
        private boolean exportFinished = true;
        private boolean teleported = false;
        private int timeout = 0;
        private Set<Tuple<Integer, BlockPos>> scanners;
        private Iterator<Tuple<Integer, BlockPos>> exportIterator;
        private Tuple<Integer, BlockPos> currentPos;
        private EntityPlayer player;
        private boolean reloadMainSettings;
        private int current = 0;

        private ScannerExporter() {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        public void startExport(EntityPlayer player, boolean reloadMainSettings) {
            this.player = player;
            this.reloadMainSettings = reloadMainSettings;
            this.exportFinished = false;
            this.teleported = false;
            this.timeout = 40;
            this.current = 0;
            this.scanners = new HashSet(scannerPositions.values());
            this.exportIterator = this.scanners.iterator();
        }

        @SubscribeEvent
        public void serverTick(TickEvent.ServerTickEvent evt) {
            if (!this.exportFinished && evt.phase == TickEvent.Phase.END) {
                if (!this.teleported) {
                    if (!this.updatePos()) {
                        return;
                    }
                    ScannerTracker.teleportAboveScannerBlock(this.player, this.currentPos);
                    this.teleported = true;
                }
                if (this.timeout <= 0) {
                    WorldTools.getTile((IBlockAccess)this.player.func_130014_f_(), (BlockPos)this.currentPos.func_76340_b(), TileStructureScanner.class).ifPresent(te -> {
                        if (this.reloadMainSettings) {
                            te.reloadMainSettings();
                        }
                        te.export();
                        te.getScanner().ifPresent(s -> this.player.func_145747_a((ITextComponent)new TextComponentString("Exported template for " + ItemStructureScanner.getStructureName(s))));
                        this.player.func_146105_b((ITextComponent)new TextComponentString(this.current + " of " + this.scanners.size() + " templates exported"), true);
                    });
                    this.timeout = 40;
                    this.teleported = false;
                } else {
                    --this.timeout;
                }
            }
        }

        private boolean updatePos() {
            if (!this.exportIterator.hasNext()) {
                this.exportFinished = true;
                return false;
            }
            this.currentPos = this.exportIterator.next();
            ++this.current;
            while (((Integer)this.currentPos.func_76341_a()).intValue() != this.player.func_130014_f_().field_73011_w.getDimension()) {
                if (!this.exportIterator.hasNext()) {
                    this.exportFinished = true;
                    return false;
                }
                this.currentPos = this.exportIterator.next();
                ++this.current;
            }
            return true;
        }
    }
}

