/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.tile;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.shadowmage.ancientwarfare.structure.tile.ISpecialLootContainer;
import net.shadowmage.ancientwarfare.structure.util.PotionHelper;

public class LootSettings {
    private boolean hasLoot = false;
    private ResourceLocation lootTableName = null;
    private int lootRolls = 1;
    private boolean splashPotion = false;
    private List<PotionEffect> effects = new ArrayList<PotionEffect>();
    private boolean spawnEntity = false;
    private ResourceLocation entity = null;
    private NBTTagCompound entityNBT = new NBTTagCompound();
    private boolean hasMessage = false;
    private String playerMessage = "";

    public NBTTagCompound serializeNBT() {
        NBTTagCompound ret = new NBTTagCompound();
        ret.func_74757_a("hasLoot", this.hasLoot);
        if (this.lootTableName != null) {
            ret.func_74778_a("lootTableName", this.lootTableName.toString());
            ret.func_74768_a("lootRolls", this.lootRolls);
        }
        ret.func_74757_a("splashPotion", this.splashPotion);
        if (!this.effects.isEmpty()) {
            NBTTagList effectList = new NBTTagList();
            for (PotionEffect potioneffect : this.effects) {
                effectList.func_74742_a((NBTBase)PotionHelper.writeCustomPotionEffectToNBT(potioneffect));
            }
            ret.func_74782_a("effects", (NBTBase)effectList);
        }
        ret.func_74757_a("spawnEntity", this.spawnEntity);
        if (this.entity != null) {
            ret.func_74778_a("entity", this.entity.toString());
            if (!this.entityNBT.func_82582_d()) {
                ret.func_74782_a("entityNBT", (NBTBase)this.entityNBT);
            }
        }
        ret.func_74757_a("hasMessage", this.hasMessage);
        if (!this.playerMessage.isEmpty()) {
            ret.func_74778_a("playerMessage", this.playerMessage);
        }
        return ret;
    }

    public static LootSettings deserializeNBT(NBTTagCompound nbt) {
        LootSettings lootSettings = new LootSettings();
        lootSettings.hasLoot = nbt.func_74767_n("hasLoot");
        lootSettings.lootTableName = new ResourceLocation(nbt.func_74779_i("lootTableName"));
        lootSettings.lootRolls = nbt.func_74762_e("lootRolls");
        lootSettings.splashPotion = nbt.func_74767_n("splashPotion");
        NBTTagList effectList = nbt.func_150295_c("effects", 10);
        for (int i = 0; i < effectList.func_74745_c(); ++i) {
            PotionHelper.readCustomPotionEffectFromNBT(effectList.func_150305_b(i)).ifPresent(lootSettings.effects::add);
        }
        lootSettings.spawnEntity = nbt.func_74767_n("spawnEntity");
        lootSettings.entity = new ResourceLocation(nbt.func_74779_i("entity"));
        lootSettings.entityNBT = nbt.func_74775_l("entityNBT");
        lootSettings.hasMessage = nbt.func_74767_n("hasMessage");
        lootSettings.playerMessage = nbt.func_74779_i("playerMessage");
        return lootSettings;
    }

    public void transferToContainer(ISpecialLootContainer container) {
        LootSettings applicableSettings = new LootSettings();
        if (this.hasLoot()) {
            applicableSettings.setHasLoot(true);
            applicableSettings.setLootTableName(this.lootTableName);
            applicableSettings.setLootRolls(this.lootRolls);
        }
        if (this.splashPotion) {
            applicableSettings.setSplashPotion(true);
            applicableSettings.setEffects(this.effects);
        }
        if (this.spawnEntity) {
            applicableSettings.setSpawnEntity(true);
            applicableSettings.setEntity(this.entity);
            applicableSettings.setEntityNBT(this.entityNBT);
        }
        if (this.hasMessage) {
            applicableSettings.setHasMessage(true);
            applicableSettings.setPlayerMessage(this.playerMessage);
        }
        container.setLootSettings(applicableSettings);
    }

    public LootSettings transferFromContainer(ISpecialLootContainer te) {
        LootSettings lootSettings = te.getLootSettings();
        if (lootSettings.hasLoot) {
            this.hasLoot = true;
            this.lootTableName = lootSettings.lootTableName;
            this.lootRolls = lootSettings.lootRolls;
        } else {
            this.hasLoot = false;
        }
        if (lootSettings.splashPotion) {
            this.splashPotion = true;
            this.effects = lootSettings.effects;
        } else {
            this.splashPotion = false;
        }
        if (lootSettings.spawnEntity) {
            this.spawnEntity = true;
            this.entity = lootSettings.entity;
            this.entityNBT = lootSettings.entityNBT;
        } else {
            this.spawnEntity = false;
        }
        if (lootSettings.hasMessage) {
            this.hasMessage = true;
            this.playerMessage = lootSettings.playerMessage;
        }
        return this;
    }

    public boolean hasLoot() {
        return this.hasLoot;
    }

    public boolean hasMessage() {
        return this.hasMessage;
    }

    public Optional<ResourceLocation> getLootTableName() {
        return Optional.ofNullable(this.lootTableName);
    }

    public void removeLoot() {
        this.hasLoot = false;
        this.lootTableName = null;
        this.lootRolls = 1;
    }

    public int getLootRolls() {
        return this.lootRolls;
    }

    public void setLootTableName(ResourceLocation lootTableName) {
        this.lootTableName = lootTableName;
    }

    public void setLootRolls(int lootRolls) {
        this.lootRolls = lootRolls;
    }

    public void setHasLoot(boolean hasLoot) {
        this.hasLoot = hasLoot;
    }

    public boolean getHasLoot() {
        return this.hasLoot;
    }

    public void setSplashPotion(boolean splashPotion) {
        this.splashPotion = splashPotion;
    }

    public boolean getSplashPotion() {
        return this.splashPotion;
    }

    public void setSpawnEntity(boolean spawnEntity) {
        this.spawnEntity = spawnEntity;
    }

    public void setEffects(List<PotionEffect> effects) {
        this.effects = effects;
    }

    public void setEntity(ResourceLocation entity) {
        this.entity = entity;
    }

    public void setHasMessage(boolean hasMessage) {
        this.hasMessage = hasMessage;
    }

    public void setPlayerMessage(String playerMessage) {
        this.playerMessage = playerMessage;
    }

    public void setEntityNBT(NBTTagCompound entityNBT) {
        this.entityNBT = entityNBT;
    }

    public List<PotionEffect> getEffects() {
        return this.effects;
    }

    public boolean getSpawnEntity() {
        return this.spawnEntity;
    }

    public NBTTagCompound getEntityNBT() {
        return this.entityNBT;
    }

    public ResourceLocation getEntity() {
        return this.entity;
    }

    public String getPlayerMessage() {
        return this.playerMessage;
    }

    public boolean hasLootToSpawn() {
        return this.spawnEntity || this.splashPotion || this.hasLoot || this.hasMessage;
    }
}

