/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.entityrules;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import net.minecraft.entity.EntityHanging;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;
import net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.entityrules.TemplateRuleEntity;

public class TemplateRuleEntityHanging
extends TemplateRuleEntity<EntityHanging> {
    public static final String PLUGIN_NAME = "vanillaHangingEntity";
    private EnumFacing direction;
    private BlockPos hangingOffset;
    private static final Method UPDATE_BB = ObfuscationReflectionHelper.findMethod(EntityHanging.class, (String)"func_174856_o", Void.TYPE, (Class[])new Class[0]);

    public TemplateRuleEntityHanging(World world, EntityHanging entity, int turns, int x, int y, int z) {
        super(world, entity, turns, x, y, z);
        BlockPos hangingOffset = entity.func_174857_n().func_177982_a(-x, -y, -z);
        this.hangingOffset = BlockTools.rotateHorizontal(hangingOffset, turns);
        this.direction = EnumFacing.field_176754_o[(Optional.ofNullable(entity.field_174860_b).map(EnumFacing::func_176736_b).orElse(0) + turns) % 4];
    }

    public TemplateRuleEntityHanging() {
    }

    @Override
    protected NBTTagCompound getEntityNBT(BlockPos pos, int turns) {
        NBTTagCompound tag = super.getEntityNBT(pos, turns);
        EnumFacing rotateDirection = EnumFacing.field_176754_o[(this.direction.func_176736_b() + turns) % 4];
        tag.func_74774_a("Facing", (byte)rotateDirection.func_176736_b());
        return tag;
    }

    @Override
    protected void updateEntityOnPlacement(int turns, BlockPos pos, EntityHanging e) {
        super.updateEntityOnPlacement(turns, pos, e);
        e.field_174861_a = pos.func_177971_a((Vec3i)BlockTools.rotateHorizontal(this.hangingOffset, turns));
        TemplateRuleEntityHanging.updateBoundingBox(e);
    }

    @Override
    public void writeRuleData(NBTTagCompound tag) {
        super.writeRuleData(tag);
        tag.func_74774_a("direction", (byte)this.direction.func_176736_b());
        tag.func_74772_a("hangingOffset", this.hangingOffset.func_177986_g());
    }

    @Override
    public void parseRule(NBTTagCompound tag) {
        super.parseRule(tag);
        this.direction = EnumFacing.field_176754_o[tag.func_74771_c("direction") % 4];
        this.hangingOffset = BlockPos.func_177969_a((long)tag.func_74763_f("hangingOffset"));
    }

    @Override
    public String getPluginName() {
        return PLUGIN_NAME;
    }

    private static void updateBoundingBox(EntityHanging entityHanging) {
        try {
            UPDATE_BB.invoke((Object)entityHanging, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            AncientWarfareStructure.LOG.error("Unable to update entity hanging's bounding box", (Throwable)e);
        }
    }
}

