/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.blockrules;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.api.IStructureBuilder;
import net.shadowmage.ancientwarfare.structure.block.BlockMulti;
import net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.blockrules.TemplateRuleBlockTile;
import net.shadowmage.ancientwarfare.structure.tile.TileMulti;

public abstract class TemplateRuleMulti<T extends TileMulti>
extends TemplateRuleBlockTile<T> {
    private final Class<T> teClass;
    private boolean mainBlock = false;

    public TemplateRuleMulti(World world, BlockPos pos, IBlockState state, int turns, Class<T> teClass) {
        super(world, pos, state, turns);
        this.teClass = teClass;
        Optional<TileMulti> te = WorldTools.getTile((IBlockAccess)world, pos, TileMulti.class);
        if (!te.isPresent()) {
            return;
        }
        TileMulti tileMulti = te.get();
        this.mainBlock = !tileMulti.getMainBlockPos().isPresent();
    }

    public TemplateRuleMulti(Class<T> teClass) {
        this.teClass = teClass;
    }

    @Override
    public void handlePlacement(World world, int turns, BlockPos pos, IStructureBuilder builder) {
        if (this.mainBlock) {
            super.handlePlacement(world, turns, pos, builder);
            WorldTools.getTile((IBlockAccess)world, pos, this.teClass).ifPresent(te -> {
                te.getAdditionalPositions(this.state).forEach(additionalPos -> world.func_175656_a(additionalPos, world.func_180495_p(pos).func_177230_c().func_176223_P().func_177226_a((IProperty)BlockMulti.INVISIBLE, (Comparable)Boolean.valueOf(true))));
                te.setMainPosOnAdditionalBlocks();
            });
        }
    }

    @Override
    @Nullable
    public TileEntity getTileEntity(int turns) {
        return super.getTileEntity(turns);
    }

    @Override
    public boolean shouldPlaceOnBuildPass(World world, int turns, BlockPos pos, int buildPass) {
        return buildPass == 0;
    }

    @Override
    public String getPluginName() {
        return "blockTile";
    }

    @Override
    public boolean shouldReuseRule(World world, IBlockState state, int turns, BlockPos pos) {
        return false;
    }

    @Override
    public void writeRuleData(NBTTagCompound tag) {
        super.writeRuleData(tag);
        if (this.mainBlock) {
            tag.func_74757_a("mainBlock", this.mainBlock);
        }
    }

    @Override
    public void parseRule(NBTTagCompound tag) {
        super.parseRule(tag);
        this.mainBlock = tag.func_74767_n("mainBlock");
    }
}

