/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.blockrules;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.api.IStructureBuilder;
import net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.blockrules.RuleWorld;
import net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.blockrules.TemplateRuleVanillaBlocks;

public class TemplateRuleFlowerPot
extends TemplateRuleVanillaBlocks {
    public static final String PLUGIN_NAME = "vanillaFlowerPot";
    private static final String ITEM_NAME_TAG = "itemName";
    private Item item = Items.field_190931_a;
    private int itemMeta = 0;
    private TileEntityFlowerPot tileCache;

    public TemplateRuleFlowerPot(World world, BlockPos pos, IBlockState state, int turns) {
        super(world, pos, state, turns);
        WorldTools.getTile((IBlockAccess)world, pos, TileEntityFlowerPot.class).ifPresent(t -> {
            Item flowerItem = t.func_145965_a();
            this.itemMeta = t.func_145966_b();
            if (flowerItem != null) {
                this.item = flowerItem;
            }
        });
    }

    public TemplateRuleFlowerPot() {
    }

    @Override
    protected Optional<ItemStack> getStack() {
        return Optional.of(new ItemStack(Items.field_151162_bE));
    }

    @Override
    public List<ItemStack> getResources() {
        ArrayList<ItemStack> resources = new ArrayList<ItemStack>(super.getResources());
        if (this.item != Items.field_190931_a) {
            resources.add(new ItemStack(this.item, 1, this.itemMeta));
        }
        return resources;
    }

    @Override
    public boolean shouldReuseRule(World world, IBlockState state, int turns, BlockPos pos) {
        return false;
    }

    @Override
    public void handlePlacement(World world, int turns, BlockPos pos, IStructureBuilder builder) {
        super.handlePlacement(world, turns, pos, builder);
        if (this.item != Items.field_190931_a) {
            WorldTools.getTile((IBlockAccess)world, pos, TileEntityFlowerPot.class).ifPresent(t -> t.func_190614_a(new ItemStack(this.item, 1, this.itemMeta)));
        }
    }

    @Override
    public void writeRuleData(NBTTagCompound tag) {
        super.writeRuleData(tag);
        if (this.item != Items.field_190931_a) {
            tag.func_74778_a(ITEM_NAME_TAG, this.item.getRegistryName().toString());
        }
        tag.func_74768_a("itemMeta", this.itemMeta);
    }

    @Override
    public void parseRule(NBTTagCompound tag) {
        ResourceLocation registryName;
        super.parseRule(tag);
        if (tag.func_74764_b(ITEM_NAME_TAG) && ForgeRegistries.ITEMS.containsKey(registryName = new ResourceLocation(tag.func_74779_i(ITEM_NAME_TAG)))) {
            this.item = (Item)ForgeRegistries.ITEMS.getValue(registryName);
        }
        this.itemMeta = tag.func_74762_e("itemMeta");
    }

    @Override
    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    @Nullable
    public TileEntity getTileEntity(int turns) {
        if (this.tileCache == null) {
            this.tileCache = new TileEntityFlowerPot();
            this.tileCache.func_190614_a(new ItemStack(this.item, 1, this.itemMeta));
            this.tileCache.func_145834_a((World)new RuleWorld(this.getState(turns)));
        }
        return this.tileCache;
    }
}

