/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.blockrules;

import javax.annotation.Nullable;
import net.minecraft.block.BlockStandingSign;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.api.IStructureBuilder;
import net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.blockrules.RuleWorld;
import net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.blockrules.TemplateRuleVanillaBlocks;

public class TemplateRuleBlockSign
extends TemplateRuleVanillaBlocks {
    public static final String PLUGIN_NAME = "vanillaSign";
    private ITextComponent[] signContents;
    private int rotation = 0;
    private Tuple<Integer, TileEntitySign> tileCache;

    public TemplateRuleBlockSign(World world, BlockPos pos, IBlockState state, int turns) {
        super(world, pos, state, turns);
        WorldTools.getTile((IBlockAccess)world, pos, TileEntitySign.class).ifPresent(t -> {
            this.signContents = new ITextComponent[4];
            for (int i = 0; i < 4; ++i) {
                this.signContents[i] = t.field_145915_a[i] == null ? new TextComponentString("") : t.field_145915_a[i];
            }
        });
        if (state.func_177230_c() == Blocks.field_150472_an) {
            this.rotation = ((Integer)state.func_177229_b((IProperty)BlockStandingSign.field_176413_a) + turns * 4) % 16;
        }
    }

    public TemplateRuleBlockSign() {
    }

    @Override
    public void handlePlacement(World world, int turns, BlockPos pos, IStructureBuilder builder) {
        if (builder.placeBlock(pos, this.getState(turns), this.buildPass)) {
            WorldTools.getTile((IBlockAccess)world, pos, TileEntitySign.class).ifPresent(t -> System.arraycopy(this.signContents, 0, t.field_145915_a, 0, this.signContents.length));
            BlockTools.notifyBlockUpdate(world, pos);
        }
    }

    @Override
    public boolean shouldReuseRule(World world, IBlockState state, int turns, BlockPos pos) {
        return false;
    }

    @Override
    public void writeRuleData(NBTTagCompound tag) {
        super.writeRuleData(tag);
        for (int i = 0; i < 4; ++i) {
            tag.func_74778_a("signContents" + i, this.signContents[i].func_150254_d());
        }
        tag.func_74768_a("rotation", this.rotation);
    }

    @Override
    public void parseRule(NBTTagCompound tag) {
        super.parseRule(tag);
        this.signContents = new ITextComponent[4];
        for (int i = 0; i < 4; ++i) {
            this.signContents[i] = new TextComponentString(tag.func_74779_i("signContents" + i));
        }
        this.rotation = tag.func_74762_e("rotation");
    }

    @Override
    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    @Nullable
    public TileEntity getTileEntity(int turns) {
        if (this.tileCache == null || (Integer)this.tileCache.func_76341_a() != turns) {
            TileEntitySign te = new TileEntitySign();
            System.arraycopy(this.signContents, 0, te.field_145915_a, 0, this.signContents.length);
            te.func_145834_a((World)new RuleWorld(this.getState(turns)));
            this.tileCache = new Tuple((Object)turns, (Object)te);
        }
        return (TileEntity)this.tileCache.func_76340_b();
    }

    @Override
    public boolean isDynamicallyRendered(int turns) {
        return true;
    }

    @Override
    public IBlockState getState(int turns) {
        IBlockState state = super.getState(turns);
        if (state.func_177230_c() == Blocks.field_150472_an) {
            state = state.func_177226_a((IProperty)BlockStandingSign.field_176413_a, (Comparable)Integer.valueOf((this.rotation + turns * 4) % 16));
        }
        return state;
    }
}

