/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.blockrules;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockBed;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBed;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.api.IStructureBuilder;
import net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.blockrules.RuleWorld;
import net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.blockrules.TemplateRuleVanillaBlocks;

public class TemplateRuleBed
extends TemplateRuleVanillaBlocks {
    public static final String PLUGIN_NAME = "bed";
    private EnumDyeColor color = EnumDyeColor.RED;
    private Tuple<Integer, TileEntityBed> tileCache = null;

    public TemplateRuleBed(World world, BlockPos pos, IBlockState state, int turns) {
        super(world, pos, state, turns);
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileEntityBed) {
            this.color = ((TileEntityBed)tileentity).func_193048_a();
        }
    }

    public TemplateRuleBed() {
    }

    @Override
    protected Optional<ItemStack> getStack() {
        return Optional.of(new ItemStack(Items.field_151104_aV, 1, this.color.func_176765_a()));
    }

    @Override
    public List<ItemStack> getResources() {
        if (this.state.func_177229_b((IProperty)BlockBed.field_176472_a) == BlockBed.EnumPartType.FOOT) {
            return super.getResources();
        }
        return Collections.emptyList();
    }

    @Override
    public boolean placeInSurvival() {
        return true;
    }

    @Override
    public void handlePlacement(World world, int turns, BlockPos pos, IStructureBuilder builder) {
        super.handlePlacement(world, turns, pos, builder);
        WorldTools.getTile((IBlockAccess)world, pos, TileEntityBed.class).ifPresent(te -> te.func_193052_a(this.color));
    }

    @Override
    public boolean shouldReuseRule(World world, IBlockState state, int turns, BlockPos pos) {
        EnumDyeColor blockColor = WorldTools.getTile((IBlockAccess)world, pos, TileEntityBed.class).map(TileEntityBed::func_193048_a).orElse(EnumDyeColor.RED);
        return this.color == blockColor && super.shouldReuseRule(world, state, turns, pos);
    }

    @Override
    public void writeRuleData(NBTTagCompound tag) {
        super.writeRuleData(tag);
        tag.func_74768_a("bedColor", this.color.func_176765_a());
    }

    @Override
    public void parseRule(NBTTagCompound tag) {
        super.parseRule(tag);
        this.color = EnumDyeColor.func_176764_b((int)tag.func_74762_e("bedColor"));
    }

    @Override
    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    @Nullable
    public TileEntity getTileEntity(int turns) {
        if (this.tileCache == null || (Integer)this.tileCache.func_76341_a() != turns) {
            TileEntityBed te = new TileEntityBed();
            te.func_193052_a(this.color);
            te.func_145834_a((World)new RuleWorld(this.getState(turns)));
            this.tileCache = new Tuple((Object)turns, (Object)te);
        }
        return (TileEntity)this.tileCache.func_76340_b();
    }

    @Override
    public boolean isDynamicallyRendered(int turns) {
        return true;
    }
}

