/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.load;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.util.math.Vec3i;
import net.shadowmage.ancientwarfare.core.util.CompatUtils;
import net.shadowmage.ancientwarfare.core.util.StringTools;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;
import net.shadowmage.ancientwarfare.structure.api.TemplateParsingException;
import net.shadowmage.ancientwarfare.structure.api.TemplateRuleBlock;
import net.shadowmage.ancientwarfare.structure.api.TemplateRuleEntityBase;
import net.shadowmage.ancientwarfare.structure.template.StructurePluginManager;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidator;
import net.shadowmage.ancientwarfare.structure.template.datafixes.FixResult;

public class TemplateParser {
    public static final TemplateParser INSTANCE = new TemplateParser();

    private TemplateParser() {
    }

    Optional<FixResult<StructureTemplate>> parseTemplate(String fileName, List<String> templateLines) {
        try {
            return this.parseTemplateLines(fileName, templateLines);
        }
        catch (TemplateParsingException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private Optional<FixResult<StructureTemplate>> parseTemplateLines(String fileName, List<String> lines) throws TemplateParsingException {
        Iterator<String> it = lines.iterator();
        StructureValidator validation = null;
        ArrayList<String> groupedLines = new ArrayList<String>();
        String name = "";
        StructureTemplate.Version version = StructureTemplate.Version.NONE;
        Vec3i size = new Vec3i(0, 0, 0);
        Vec3i offset = new Vec3i(0, 0, 0);
        short[] templateData = null;
        boolean[] initData = new boolean[4];
        HashMap<Integer, TemplateRuleBlock> parsedRules = new HashMap<Integer, TemplateRuleBlock>();
        HashMap<Integer, TemplateRuleEntityBase> parsedEntities = new HashMap<Integer, TemplateRuleEntityBase>();
        FixResult.Builder<StructureTemplate> resultBuilder = new FixResult.Builder<StructureTemplate>();
        String[] modDependencies = new String[]{};
        while (it.hasNext()) {
            Object e1;
            StringBuilder data;
            String line = it.next();
            if (line.startsWith("#") || line.equals("")) continue;
            if (line.startsWith("header:")) {
                while (it.hasNext() && !(line = it.next()).startsWith(":endheader")) {
                    if (line.startsWith("version=")) {
                        initData[0] = true;
                        version = new StructureTemplate.Version(StringTools.safeParseString("=", line));
                    }
                    if (line.startsWith("name=")) {
                        name = StringTools.safeParseString("=", line);
                        initData[1] = true;
                    }
                    if (line.startsWith("mods=") && !CompatUtils.areModsLoaded(modDependencies = StringTools.safeParseString("=", line).split(","))) {
                        AncientWarfareStructure.LOG.info("Template {} not loaded because it depends on mod that isn't loaded.", (Object)fileName);
                        return Optional.empty();
                    }
                    if (line.startsWith("size=")) {
                        int[] sizes = StringTools.safeParseIntArray("=", line);
                        size = new Vec3i(sizes[0], sizes[1], sizes[2]);
                        initData[2] = true;
                    }
                    if (!line.startsWith("offset=")) continue;
                    int[] offsets = StringTools.safeParseIntArray("=", line);
                    offset = new Vec3i(offsets[0], offsets[1], offsets[2]);
                    initData[3] = true;
                }
                for (int i = 0; i < 4; ++i) {
                    if (initData[i]) continue;
                    throw new TemplateParsingException("Could not parse template for " + fileName + " -- template was missing header or header data.");
                }
                templateData = new short[size.func_177958_n() * size.func_177956_o() * size.func_177952_p()];
            }
            if (line.startsWith("validation:")) {
                while (it.hasNext() && !(line = it.next()).startsWith(":endvalidation")) {
                    groupedLines.add(line);
                }
                validation = StructureValidator.parseValidator(groupedLines);
                groupedLines.clear();
            }
            if (line.startsWith("rule:")) {
                groupedLines.add(line);
                while (it.hasNext()) {
                    line = it.next();
                    groupedLines.add(line);
                    if (!line.startsWith(":endrule")) continue;
                }
                try {
                    TemplateRuleBlock parsedRule = (TemplateRuleBlock)resultBuilder.updateAndGetData(StructurePluginManager.getRule(version, groupedLines, "rule"));
                    parsedRules.put(parsedRule.ruleNumber, parsedRule);
                }
                catch (TemplateParsingException.TemplateRuleParsingException e) {
                    data = new StringBuilder(e.getMessage() + "\n");
                    for (String line1 : groupedLines) {
                        data.append(line1).append("\n");
                    }
                    e1 = new TemplateParsingException.TemplateRuleParsingException(data.toString(), e);
                    AncientWarfareStructure.LOG.error("Caught exception parsing template rule for structure: " + name, (Object)((Throwable)e1).getMessage());
                }
                groupedLines.clear();
            }
            if (line.startsWith("entity:")) {
                groupedLines.add(line);
                while (it.hasNext()) {
                    line = it.next();
                    groupedLines.add(line);
                    if (!line.startsWith(":endentity")) continue;
                }
                try {
                    TemplateRuleEntityBase entityRule = (TemplateRuleEntityBase)resultBuilder.updateAndGetData(StructurePluginManager.getRule(version, groupedLines, "entity"));
                    parsedEntities.put(entityRule.ruleNumber, entityRule);
                }
                catch (TemplateParsingException.TemplateRuleParsingException e) {
                    data = new StringBuilder(e.getMessage() + "\n");
                    for (String line1 : groupedLines) {
                        data.append(line1).append("\n");
                    }
                    e1 = new TemplateParsingException.TemplateRuleParsingException(data.toString(), e);
                    AncientWarfareStructure.LOG.error("Caught exception parsing template rule for structure: " + name, (Object)((Throwable)e1).getMessage());
                }
                groupedLines.clear();
            }
            if (!line.startsWith("layer:")) continue;
            groupedLines.add(line);
            while (it.hasNext()) {
                line = it.next();
                groupedLines.add(line);
                if (!line.startsWith(":endlayer")) continue;
            }
            this.parseLayer(groupedLines, size, templateData);
            groupedLines.clear();
        }
        return Optional.of(resultBuilder.build(this.constructTemplate(name, modDependencies, version, size, offset, templateData, parsedRules, parsedEntities, validation)));
    }

    private StructureTemplate constructTemplate(String name, String[] modDependencies, StructureTemplate.Version version, Vec3i size, Vec3i offset, short[] templateData, Map<Integer, TemplateRuleBlock> rules, Map<Integer, TemplateRuleEntityBase> entityRules, StructureValidator validation) {
        StructureTemplate template = new StructureTemplate(name, Arrays.stream(modDependencies).collect(Collectors.toSet()), version, size, offset);
        template.setBlockRules(rules);
        template.setEntityRules(entityRules);
        template.setTemplateData(templateData);
        template.setValidationSettings(validation);
        return template;
    }

    private void parseLayer(List<String> templateLines, Vec3i size, short[] templateData) {
        int minLayer = 0;
        int maxLayer = 0;
        ArrayList<String> rowLines = new ArrayList<String>();
        for (String st : templateLines) {
            if (st.startsWith(":endlayer")) continue;
            if (st.startsWith("layer:")) {
                String[] layerIds = st.split(":")[1].split("-");
                minLayer = Integer.parseInt(layerIds[0].trim());
                maxLayer = layerIds.length > 1 ? Integer.parseInt(layerIds[1].trim()) : minLayer;
                continue;
            }
            rowLines.add(st);
        }
        this.parseLayer(size, templateData, minLayer, maxLayer, rowLines);
    }

    private void parseLayer(Vec3i size, short[] templateData, int minLayer, int maxLayer, List<String> rowLines) {
        List<short[]> rows = this.parseLayerRows(rowLines);
        for (int layerId = minLayer; layerId <= maxLayer; ++layerId) {
            int z = 0;
            for (short[] data : rows) {
                for (int x = 0; x < size.func_177958_n() && x < data.length; ++x) {
                    templateData[StructureTemplate.getIndex((Vec3i)new Vec3i((int)x, (int)layerId, (int)z), (Vec3i)size)] = data[x];
                }
                ++z;
            }
        }
    }

    private List<short[]> parseLayerRows(List<String> rowLines) {
        ArrayList<short[]> rows = new ArrayList<short[]>();
        for (String rowLine : rowLines) {
            short[] blocks;
            String[] rowParts = rowLine.split("x");
            int repeat = 1;
            if (rowParts.length > 1) {
                repeat = Integer.parseInt(rowParts[0]);
                blocks = this.parseBlocks(rowParts[1]);
            } else {
                blocks = this.parseBlocks(rowParts[0]);
            }
            for (int i = 0; i < repeat; ++i) {
                rows.add(blocks);
            }
        }
        return rows;
    }

    private short[] parseBlocks(String row) {
        String[] blockParts;
        ArrayList<Short> blocks = new ArrayList<Short>();
        for (String blockPart : blockParts = row.split(",")) {
            String[] blockDef = blockPart.split("\\|");
            int repeat = 1;
            if (blockDef.length > 1) {
                repeat = Integer.parseInt(blockDef[1]);
            }
            short id = Short.parseShort(blockDef[0]);
            for (int i = 0; i < repeat; ++i) {
                blocks.add(id);
            }
        }
        short[] ret = new short[blocks.size()];
        int i = 0;
        Iterator iterator = blocks.iterator();
        while (iterator.hasNext()) {
            short block = (Short)iterator.next();
            ret[i++] = block;
        }
        return ret;
    }
}

