/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.datafixes.fixers.json;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class Json {
    private Json() {
    }

    public static String getJsonData(JsonObject json) {
        return "JSON:{" + json.getJsonString() + "}";
    }

    public static Optional<JsonObject> parseJson(String data) {
        if (Json.isSerializedJSON(data)) {
            JsonParser parser = new JsonParser(data.substring(6, data.length() - 1));
            try {
                return Optional.of(parser.process());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    static boolean isSerializedJSON(String data) {
        return data.startsWith("JSON:{") && data.endsWith("}");
    }

    public static final class JsonValue
    extends JsonAbstract {
        private String value;

        public JsonValue(String value) {
            this.value = value;
        }

        public String getStringValue() {
            return this.value;
        }

        public void setStringValue(String value) {
            this.value = value;
        }

        public long getIntegerValue() {
            try {
                return Long.parseLong(this.value);
            }
            catch (NumberFormatException e) {
                return 0L;
            }
        }

        public double getFloatValue() {
            try {
                return Double.parseDouble(this.value);
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }

        public String toString() {
            return this.value;
        }

        @Override
        protected String getJsonString() {
            String val = this.value.replace("\"", "\\\"");
            return "\"" + val + "\"";
        }
    }

    public static final class JsonArray
    extends JsonAbstract {
        private List<JsonAbstract> values = new ArrayList<JsonAbstract>();

        public void add(JsonAbstract value) {
            this.values.add(value);
        }

        public int size() {
            return this.values.size();
        }

        public JsonValue getValue(int index) {
            JsonAbstract a = this.values.get(index);
            return a instanceof JsonValue ? (JsonValue)a : null;
        }

        public JsonObject getObject(int index) {
            JsonAbstract a = this.values.get(index);
            return a instanceof JsonObject ? (JsonObject)a : null;
        }

        @Override
        protected String getJsonString() {
            JsonAbstract value;
            StringBuilder data = new StringBuilder("[");
            Iterator<JsonAbstract> it = this.values.iterator();
            while (it.hasNext() && (value = it.next()) != null) {
                data.append(value.getJsonString());
                if (!it.hasNext()) continue;
                data.append(",");
            }
            data.append("]");
            return data.toString();
        }
    }

    public static final class JsonObject
    extends JsonAbstract {
        private HashMap<String, JsonAbstract> fields = new HashMap();

        public JsonValue getValue(String name) {
            JsonAbstract a = this.fields.get(name);
            return a instanceof JsonValue ? (JsonValue)a : null;
        }

        public JsonObject getObject(String name) {
            JsonAbstract a = this.fields.get(name);
            return a instanceof JsonObject ? (JsonObject)a : null;
        }

        public JsonAbstract getAbstract() {
            return this.fields.get("val");
        }

        public Set<String> keySet() {
            return this.fields.keySet();
        }

        public void writeAbstract(String name, JsonAbstract value) {
            this.fields.put(name, value);
        }

        @Override
        protected String getJsonString() {
            String key;
            StringBuilder data = new StringBuilder("{");
            Iterator<String> it = this.fields.keySet().iterator();
            while (it.hasNext() && (key = it.next()) != null) {
                data.append("\"").append(key).append("\":").append(this.fields.get(key).getJsonString());
                if (!it.hasNext()) continue;
                data.append(",");
            }
            data.append("}");
            return data.toString();
        }
    }

    public static abstract class JsonAbstract {
        protected abstract String getJsonString();
    }

    private static class JsonParser {
        private Reader reader;
        private int rawChar;
        private int charIndex = -1;
        private boolean readEnd = false;
        private boolean atEnd = false;
        private int bufferStart = 0;
        private int bufferEnd = 0;
        private char[] readBuffer = new char[1024];
        private char currentChar;

        protected JsonParser(String data) {
            this.reader = new StringReader(data);
        }

        protected JsonParser(Reader reader) {
            this.reader = reader;
        }

        protected JsonObject process() throws IOException {
            this.readRawChar();
            return this.readObject();
        }

        private void readRawChar() throws IOException {
            int index;
            if (this.atEnd) {
                return;
            }
            ++this.charIndex;
            if (this.charIndex >= this.bufferEnd) {
                if (this.readEnd) {
                    this.atEnd = true;
                    return;
                }
                this.bufferStart = this.charIndex;
                this.bufferEnd = this.bufferStart + this.readBuffer.length;
                int read = this.reader.read(this.readBuffer);
                if (this.bufferStart + read < this.bufferEnd) {
                    this.bufferEnd = this.bufferStart + read;
                    this.readEnd = true;
                }
            }
            if ((index = this.charIndex - this.bufferStart) >= this.bufferEnd) {
                this.charIndex = -1;
                this.rawChar = -1;
                this.currentChar = (char)32;
                return;
            }
            this.rawChar = this.readBuffer[index];
            this.currentChar = this.readBuffer[index];
        }

        private void skipBlanks() throws IOException {
            while (this.rawChar == 32 || this.rawChar == 13 || this.rawChar == 10) {
                this.readRawChar();
            }
        }

        private JsonAbstract readAbstract() throws IOException {
            if (this.rawChar == 123) {
                return this.readObject();
            }
            if (this.rawChar == 91) {
                return this.readArray();
            }
            return this.readValue();
        }

        private JsonObject readObject() throws IOException {
            if (this.rawChar != 123) {
                throw this.throwUnexpectedException("expected object start {");
            }
            JsonObject object = new JsonObject();
            this.readRawChar();
            this.skipBlanks();
            if (this.rawChar == 125) {
                this.readRawChar();
                this.skipBlanks();
                return object;
            }
            while (this.rawChar != 125) {
                this.skipBlanks();
                String name = this.readName();
                this.skipBlanks();
                if (this.rawChar != 58) {
                    throw this.throwUnexpectedException("Did not find name separator : while parsing object");
                }
                this.readRawChar();
                this.skipBlanks();
                JsonAbstract value = this.readAbstract();
                object.writeAbstract(name, value);
                this.skipBlanks();
                if (this.rawChar != 44) continue;
                this.readRawChar();
                this.skipBlanks();
            }
            this.readRawChar();
            this.skipBlanks();
            return object;
        }

        private JsonArray readArray() throws IOException {
            if (this.rawChar != 91) {
                throw this.throwUnexpectedException("expected array start [");
            }
            JsonArray array = new JsonArray();
            this.readRawChar();
            this.skipBlanks();
            if (this.rawChar == 93) {
                this.readRawChar();
                this.skipBlanks();
                return array;
            }
            while (this.rawChar != 93) {
                this.skipBlanks();
                JsonAbstract value = this.readAbstract();
                array.add(value);
                this.skipBlanks();
                if (this.rawChar != 44) continue;
                this.readRawChar();
                this.skipBlanks();
            }
            this.readRawChar();
            this.skipBlanks();
            return array;
        }

        private JsonValue readValue() throws IOException {
            return new JsonValue(this.readString());
        }

        private String readName() throws IOException {
            if (this.rawChar != 34) {
                throw this.throwUnexpectedException("Did not find name start while parsing object");
            }
            return this.readString();
        }

        private String readString() throws IOException {
            if (this.rawChar != 34) {
                throw this.throwUnexpectedException("Did not find string entry while parsing value");
            }
            StringBuilder builder = new StringBuilder();
            this.readRawChar();
            while (this.rawChar != 34) {
                char prevChar = this.currentChar;
                this.readRawChar();
                if (prevChar == '\\' && this.rawChar == 34) {
                    prevChar = this.currentChar;
                    this.readRawChar();
                }
                builder.append(prevChar);
            }
            this.readRawChar();
            return builder.toString();
        }

        private JsonParsingException throwUnexpectedException(String message) {
            return new JsonParsingException(message + "\nAt char index: " + this.charIndex + " char: " + this.currentChar);
        }

        private static class JsonParsingException
        extends RuntimeException {
            private JsonParsingException(String message) {
                super(message);
            }
        }
    }
}

