/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.build.validation.border;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.template.build.validation.border.BorderMatrix;
import net.shadowmage.ancientwarfare.structure.template.build.validation.border.HorizontalCoords;
import net.shadowmage.ancientwarfare.structure.template.build.validation.border.points.PointType;
import net.shadowmage.ancientwarfare.structure.template.build.validation.border.points.SmoothingPoint;
import net.shadowmage.ancientwarfare.structure.worldgen.WorldStructureGenerator;

public class SmoothingMatrix {
    private SmoothingPoint[][] smoothingPoints;
    private final int fullXSize;
    private final int fullZSize;
    private Map<PointType, Set<SmoothingPoint>> typePoints = new HashMap<PointType, Set<SmoothingPoint>>();
    private final BlockPos minPos;

    public SmoothingMatrix(BorderMatrix borderMatrix, BlockPos structureMinPos, int borderSize) {
        this.fullXSize = borderMatrix.getFullXSize();
        this.fullZSize = borderMatrix.getFullZSize();
        this.smoothingPoints = this.initMatrix(this.fullXSize, this.fullZSize);
        this.minPos = structureMinPos.func_177982_a(-borderSize - 2, 0, -borderSize - 2);
    }

    Optional<SmoothingPoint> getPoint(HorizontalCoords coords) {
        return this.getPoint(coords.getX(), coords.getZ());
    }

    public Optional<SmoothingPoint> getPoint(int x, int z) {
        if (this.smoothingPoints.length == 0 || x < 0 || x >= this.smoothingPoints.length || z < 0 || z >= this.smoothingPoints[0].length) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.smoothingPoints[x][z]);
    }

    private void printMatrix() {
        this.printTypes();
        this.printDistances();
        this.printHeights();
    }

    private void printHeights() {
        for (int x = 0; x < this.fullXSize; ++x) {
            for (int z = 0; z < this.fullZSize; ++z) {
                System.out.print(String.format("%02d", this.getPoint(x, z).map(point -> !point.hasSmoothedPosSet() ? 0 : point.getSmoothedPos().func_177956_o()).orElse(0)) + " ");
            }
            System.out.println();
        }
    }

    private void printDistances() {
        for (int x = 0; x < this.fullXSize; ++x) {
            for (int z = 0; z < this.fullZSize; ++z) {
                System.out.print(this.getPoint(x, z).map(point -> point.getStructureBorderDistance() == Integer.MAX_VALUE ? "00" : String.format("%02d", point.getStructureBorderDistance())).orElse("00") + " ");
            }
            System.out.println();
        }
    }

    private void printTypes() {
        for (int x = 0; x < this.fullXSize; ++x) {
            for (int z = 0; z < this.fullZSize; ++z) {
                System.out.print(this.getPoint(x, z).map(point -> point.getType().getAcronym()).orElse(" ") + " ");
            }
            System.out.println();
        }
    }

    public boolean isEmpty(HorizontalCoords point) {
        return !this.getPoint(point).isPresent();
    }

    public SmoothingPoint addPoint(int x, int z, BlockPos pos, PointType type) {
        SmoothingPoint point = new SmoothingPoint(x, z, pos, type);
        this.addPoint(point);
        return point;
    }

    public SmoothingPoint addPoint(int x, int z, BlockPos pos, PointType type, IBlockState state) {
        SmoothingPoint point = this.addPoint(x, z, pos, type);
        point.setBlockState(state);
        return point;
    }

    void addPoint(SmoothingPoint point) {
        this.smoothingPoints[point.getX()][point.getZ()] = point;
        this.addTypePoint(point.getType(), point);
    }

    private SmoothingPoint[][] initMatrix(int fullXSize, int fullZSize) {
        SmoothingPoint[][] ret = new SmoothingPoint[fullXSize][];
        for (int x = 0; x < fullXSize; ++x) {
            ret[x] = new SmoothingPoint[fullZSize];
        }
        return ret;
    }

    private void addTypePoint(PointType type, SmoothingPoint point) {
        if (!this.typePoints.containsKey((Object)type)) {
            this.typePoints.put(type, new HashSet());
        }
        this.typePoints.get((Object)type).add(point);
    }

    public void apply(World world, Consumer<BlockPos> handleClearing) {
        HashSet chunkPoints = new HashSet();
        this.typePoints.get((Object)PointType.SMOOTHED_BORDER).forEach(point -> {
            this.levelTerrain(world, (SmoothingPoint)point, handleClearing);
            chunkPoints.add(new BlockPos(this.getChunkCornerCoord(point.getSmoothedPos().func_177958_n()), 0, this.getChunkCornerCoord(point.getSmoothedPos().func_177952_p())));
        });
        chunkPoints.forEach(pos -> this.decorate(world, (BlockPos)pos));
        this.typePoints.get((Object)PointType.SMOOTHED_BORDER).forEach(point -> {
            BlockPos posAbove = point.getSmoothedPos().func_177984_a();
            if (world.func_175708_f(posAbove, true)) {
                world.func_180501_a(posAbove, Blocks.field_150431_aC.func_176223_P(), 2);
            }
        });
    }

    private int getChunkCornerCoord(int coord) {
        return (coord >> 4) * 16;
    }

    private void decorate(World world, BlockPos point) {
        Random random = new Random((long)(point.func_177958_n() >> 4) * 341873128712L + (long)(point.func_177952_p() >> 4) * 132897987541L);
        world.func_180494_b(point).func_180624_a(world, random, point);
    }

    private void levelTerrain(World world, SmoothingPoint point, Consumer<BlockPos> handleClearing) {
        BlockPos originalPos = point.getWorldPos();
        BlockPos smoothedPos = point.getSmoothedPos();
        Biome biome = world.func_180494_b(originalPos);
        int topNonWaterY = WorldStructureGenerator.getTargetY(world, originalPos.func_177958_n(), originalPos.func_177952_p(), true, originalPos.func_177956_o());
        int topOuterBorderWaterY = point.getOuterBorderPoint().getWaterLevel();
        if (originalPos.func_177956_o() == smoothedPos.func_177956_o() && topNonWaterY == originalPos.func_177956_o()) {
            return;
        }
        if (originalPos.func_177956_o() > smoothedPos.func_177956_o()) {
            if (smoothedPos.func_177956_o() < topOuterBorderWaterY) {
                BlockTools.getAllInBoxTopDown(smoothedPos, new BlockPos(smoothedPos.func_177958_n(), topOuterBorderWaterY, smoothedPos.func_177952_p())).forEach(pos -> world.func_175656_a(pos, Blocks.field_150355_j.func_176223_P()));
            } else {
                BlockTools.getAllInBoxTopDown(smoothedPos, originalPos).forEach(handleClearing);
            }
        }
        if (smoothedPos.func_177956_o() - topNonWaterY > 1) {
            IBlockState fillerBlock = biome.field_76753_B;
            BlockPos.func_191532_a((int)originalPos.func_177958_n(), (int)(topNonWaterY + 1), (int)originalPos.func_177952_p(), (int)originalPos.func_177958_n(), (int)(smoothedPos.func_177956_o() - 1), (int)originalPos.func_177952_p()).forEach(pos -> world.func_175656_a(pos, fillerBlock));
        }
        world.func_175656_a(smoothedPos, point.getBlockState());
    }

    public BlockPos getMinPos() {
        return this.minPos;
    }

    public Set<SmoothingPoint> getPointsOfType(PointType type) {
        return this.typePoints.get((Object)type);
    }
}

