/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.build.validation.border;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import net.shadowmage.ancientwarfare.structure.template.build.validation.border.BorderMatrix;
import net.shadowmage.ancientwarfare.structure.template.build.validation.border.HorizontalCoords;
import net.shadowmage.ancientwarfare.structure.template.build.validation.border.points.BorderPoint;
import net.shadowmage.ancientwarfare.structure.template.build.validation.border.points.PointType;

public class BorderPointFiller {
    private BorderMatrix borderMatrix;
    private int borderSize;
    private Set<HorizontalCoords> toProcess = new LinkedHashSet<HorizontalCoords>();

    public BorderPointFiller(BorderMatrix borderMatrix, int borderSize) {
        this.borderMatrix = borderMatrix;
        this.borderSize = borderSize;
    }

    void fillInBorderPointsToSmooth(HorizontalCoords firstToSmooth) {
        this.toProcess.add(firstToSmooth);
        while (!this.toProcess.isEmpty()) {
            Optional<BorderPoint> point;
            Iterator<HorizontalCoords> it = this.toProcess.iterator();
            HorizontalCoords current = it.next();
            it.remove();
            boolean newPoint = false;
            if (this.borderMatrix.isEmpty(current)) {
                this.borderMatrix.addPoint(current, PointType.SMOOTHED_BORDER);
                newPoint = true;
            }
            if (!(point = this.borderMatrix.getPoint(current)).isPresent()) continue;
            this.checkAroundPoint(current, point.get(), newPoint);
        }
    }

    private void checkAroundPoint(HorizontalCoords current, BorderPoint point, boolean newPoint) {
        HashSet<HorizontalCoords> potentiallyFill = new HashSet<HorizontalCoords>();
        boolean recheckSurroundingDistances = false;
        HashSet<HorizontalCoords> toRecheckDistances = new HashSet<HorizontalCoords>();
        for (HorizontalCoords offset : HorizontalCoords.ADJACENT_OFFSETS) {
            HorizontalCoords adjacent = current.add(offset);
            Optional<BorderPoint> adjacentPoint = this.borderMatrix.getPoint(adjacent);
            if (!adjacentPoint.isPresent()) {
                potentiallyFill.add(adjacent);
                continue;
            }
            if (newPoint && adjacentPoint.get().getType() == PointType.STRUCTURE_BORDER) {
                this.updateBorderCoordsIfCloser(point, 1, adjacentPoint.get());
                continue;
            }
            if (adjacentPoint.get().getType() != PointType.SMOOTHED_BORDER) continue;
            if (newPoint && !this.updateBorderCoordsIfCloser(point, adjacentPoint.get().getStructureBorderDistance() + 1, adjacentPoint.get().getClosestBorderPoint())) {
                this.toProcess.add(adjacent);
                continue;
            }
            if (newPoint) continue;
            if (this.updateBorderCoordsIfCloser(point, adjacentPoint.get().getStructureBorderDistance() + 1, adjacentPoint.get().getClosestBorderPoint())) {
                recheckSurroundingDistances = true;
                continue;
            }
            toRecheckDistances.add(new HorizontalCoords(adjacent.getX(), adjacent.getZ()));
        }
        if (point.getDistanceToBorder() < (double)this.borderSize) {
            this.toProcess.addAll(potentiallyFill);
        }
        if (recheckSurroundingDistances) {
            this.toProcess.addAll(toRecheckDistances);
        }
    }

    private boolean updateBorderCoordsIfCloser(BorderPoint point, int distance, BorderPoint borderPoint) {
        return point.updateBorderCoordsIfCloser(distance, borderPoint);
    }
}

