/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.build.validation;

import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidationType;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidator;
import net.shadowmage.ancientwarfare.structure.template.build.validation.properties.StructureValidationProperties;

public class StructureValidatorSky
extends StructureValidator {
    public StructureValidatorSky() {
        super(StructureValidationType.SKY);
    }

    @Override
    protected void setDefaultSettings(StructureTemplate template) {
    }

    @Override
    public boolean shouldIncludeForSelection(World world, int x, int y, int z, EnumFacing face, StructureTemplate template) {
        int remainingHeight = world.func_72940_L() - this.getMinFlyingHeight() - (template.getSize().func_177956_o() - template.getOffset().func_177956_o());
        return y < remainingHeight;
    }

    @Override
    public int getAdjustedSpawnY(World world, int x, int y, int z, EnumFacing face, StructureTemplate template, StructureBB bb) {
        int range = this.getMaxGenerationHeight() - this.getMinGenerationHeight() + 1;
        return y + this.getMinFlyingHeight() + world.field_73012_v.nextInt(range);
    }

    @Override
    public boolean validatePlacement(World world, int x, int y, int z, EnumFacing face, StructureTemplate template, StructureBB bb) {
        int maxY = this.getMinGenerationHeight() - this.getMinFlyingHeight();
        return this.validateBorderBlocks(world, bb, 0, maxY, false);
    }

    @Override
    public void preGeneration(World world, BlockPos pos, EnumFacing face, StructureTemplate template, StructureBB bb) {
    }

    private int getMinFlyingHeight() {
        return this.getPropertyValue(StructureValidationProperties.MIN_FLYING_HEIGHT);
    }

    private int getMaxGenerationHeight() {
        return this.getPropertyValue(StructureValidationProperties.MAX_GENERATION_HEIGHT);
    }

    private int getMinGenerationHeight() {
        return this.getPropertyValue(StructureValidationProperties.MIN_GENERATION_HEIGHT);
    }
}

