/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Predicate;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.Loader;
import net.shadowmage.ancientwarfare.core.gamedata.AWGameData;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;
import net.shadowmage.ancientwarfare.structure.gamedata.StructureEntry;
import net.shadowmage.ancientwarfare.structure.gamedata.StructureMap;
import net.shadowmage.ancientwarfare.structure.registry.BiomeGroupRegistry;
import net.shadowmage.ancientwarfare.structure.registry.TerritorySettingRegistry;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidator;
import net.shadowmage.ancientwarfare.structure.template.build.validation.properties.StructureValidationProperties;
import net.shadowmage.ancientwarfare.structure.util.CollectionUtils;
import net.shadowmage.ancientwarfare.structure.worldgen.Territory;
import net.shadowmage.ancientwarfare.structure.worldgen.TerritoryManager;
import net.shadowmage.ancientwarfare.structure.worldgen.WorldGenDetailedLogHelper;
import net.shadowmage.ancientwarfare.structure.worldgen.stats.ValidationRejectionReason;
import net.shadowmage.ancientwarfare.structure.worldgen.stats.WorldGenStatistics;
import org.apache.logging.log4j.util.Supplier;

public class WorldGenStructureManager {
    public static final String GENERIC_TERRITORY_NAME = "generic";
    private HashMap<String, Set<StructureTemplate>> templatesByBiome = new HashMap();
    private HashMap<String, Set<StructureTemplate>> templatesByTerritoryName = new HashMap();
    private List<StructureEntry> searchCache = new ArrayList<StructureEntry>();
    private List<StructureTemplate> trimmedPotentialStructures = new ArrayList<StructureTemplate>();
    private HashMap<String, Integer> distancesFound = new HashMap();
    public static final WorldGenStructureManager INSTANCE = new WorldGenStructureManager();

    private WorldGenStructureManager() {
    }

    public void clearCachedTemplates() {
        this.templatesByBiome.clear();
        this.templatesByTerritoryName.clear();
    }

    public void loadBiomeList() {
        for (Biome biome : Biome.field_185377_q) {
            if (biome == null) continue;
            this.templatesByBiome.put(biome.getRegistryName().toString(), new HashSet());
        }
    }

    void registerWorldGenStructure(StructureTemplate template) {
        StructureValidator validation = template.getValidationSettings();
        Set<String> biomes = validation.getBiomeList();
        HashSet<String> biomeGroupBiomes = new HashSet<String>();
        validation.getBiomeGroupList().forEach(biomeGroup -> biomeGroupBiomes.addAll(BiomeGroupRegistry.getGroupBiomes(biomeGroup)));
        String territoryName = template.getValidationSettings().getPropertyValue(StructureValidationProperties.TERRITORY_NAME);
        if (territoryName.isEmpty()) {
            territoryName = GENERIC_TERRITORY_NAME;
        }
        Set templates = this.templatesByTerritoryName.getOrDefault(territoryName, new HashSet());
        templates.add(template);
        this.templatesByTerritoryName.put(territoryName, templates);
        if (validation.isBiomeWhiteList()) {
            this.whitelistBiomes(template, biomes, biomeGroupBiomes, territoryName);
        } else {
            this.blacklistBiomes(template, biomes, biomeGroupBiomes, territoryName);
        }
    }

    private void whitelistBiomes(StructureTemplate template, Set<String> biomes, Set<String> biomeGroupBiomes, String territoryName) {
        this.addTemplateToBiomes(template, biomeGroupBiomes, b -> true, territoryName);
        this.addTemplateToBiomes(template, biomes, b -> biomeGroupBiomes.isEmpty() || biomeGroupBiomes.contains(b), territoryName);
    }

    private void addTemplateToBiomes(StructureTemplate template, Set<String> biomeGroupBiomes, Predicate<String> checkBiome, String territoryName) {
        for (String biomeName : biomeGroupBiomes) {
            if (this.templatesByBiome.containsKey(biomeName) && checkBiome.test(biomeName)) {
                this.addBiomeTemplate(template, territoryName, biomeName);
                continue;
            }
            if (!Loader.isModLoaded((String)new ResourceLocation(biomeName).func_110624_b())) continue;
            AncientWarfareStructure.LOG.warn("Could not locate biome: {} while registering template: {} for world generation.", (Object)biomeName, (Object)template.name);
        }
    }

    private void addBiomeTemplate(StructureTemplate template, String territoryName, String biomeName) {
        this.templatesByBiome.get(biomeName).add(template);
        TerritoryManager.addTerritoryInBiome(territoryName, biomeName);
    }

    private void blacklistBiomes(StructureTemplate template, Set<String> biomes, Set<String> biomeGroupBiomes, String territoryName) {
        Set<String> biomesBaseList = biomeGroupBiomes.isEmpty() ? this.templatesByBiome.keySet() : biomeGroupBiomes;
        for (String biome : biomesBaseList) {
            if (!biomes.isEmpty() && biomes.contains(biome) || !this.templatesByBiome.containsKey(biome)) continue;
            this.addBiomeTemplate(template, territoryName, biome);
        }
    }

    public Optional<StructureTemplate> selectTemplateForGeneration(World world, Random rng, int x, int y, int z, EnumFacing face, Territory territory) {
        this.searchCache.clear();
        this.trimmedPotentialStructures.clear();
        this.distancesFound.clear();
        StructureMap map = AWGameData.INSTANCE.getPerWorldData(world, StructureMap.class);
        Biome biome = world.field_73011_w.getBiomeForCoords(new BlockPos(x, 1, z));
        String biomeName = biome.getRegistryName().toString();
        HashSet<StructureTemplate> potentialStructures = new HashSet<StructureTemplate>();
        this.getTerritoryTemplates(territory.getTerritoryName()).ifPresent(potentialStructures::addAll);
        this.getTerritoryTemplates(GENERIC_TERRITORY_NAME).ifPresent(potentialStructures::addAll);
        Set<StructureTemplate> biomeTemplates = this.templatesByBiome.get(biomeName);
        potentialStructures.removeIf(t -> !biomeTemplates.contains(t));
        if (potentialStructures.isEmpty()) {
            return Optional.empty();
        }
        int remainingValueCache = territory.getRemainingClusterValue();
        Supplier[] supplierArray = new Supplier[5];
        supplierArray[0] = () -> x;
        supplierArray[1] = () -> z;
        supplierArray[2] = () -> biomeName;
        supplierArray[3] = territory::getTerritoryName;
        supplierArray[4] = territory::getRemainingClusterValue;
        WorldGenDetailedLogHelper.log("Selecting template at x {} z {} in biome \"{}\" and territory \"{}\" with remaining cluster value of {}", supplierArray);
        int duplicateSearchDistance = 0;
        for (StructureTemplate structureTemplate : potentialStructures) {
            duplicateSearchDistance = Math.max(duplicateSearchDistance, structureTemplate.getValidationSettings().getMinDuplicateDistance());
        }
        Collection<StructureEntry> duplicateSearchEntries = map.getEntriesNear(world, x, z, duplicateSearchDistance / 16, false, this.searchCache);
        for (StructureEntry structureEntry : duplicateSearchEntries) {
            int mx = structureEntry.getBB().getCenterX() - x;
            int mz = structureEntry.getBB().getCenterZ() - z;
            int foundDistance = (int)MathHelper.func_76129_c((float)((float)mx * (float)mx + (float)(mz * mz)));
            if (this.distancesFound.containsKey(structureEntry.getName())) {
                int dist = this.distancesFound.get(structureEntry.getName());
                if (foundDistance >= dist) continue;
                this.distancesFound.put(structureEntry.getName(), foundDistance);
                continue;
            }
            this.distancesFound.put(structureEntry.getName(), foundDistance);
        }
        int n = world.field_73011_w.getDimension();
        for (StructureTemplate template : potentialStructures) {
            if (!this.validateTemplate(world, x, y, z, face, map, remainingValueCache, n, template)) continue;
            this.trimmedPotentialStructures.add(template);
        }
        if (this.trimmedPotentialStructures.isEmpty()) {
            return Optional.empty();
        }
        StructureTemplate structureTemplate = CollectionUtils.getWeightedRandomElement(rng, this.trimmedPotentialStructures, e -> this.getStructureWeight(x, y, z, territory, (StructureTemplate)e), (totalWeight, selected) -> {
            Supplier[] supplierArray = new Supplier[4];
            supplierArray[0] = this.trimmedPotentialStructures::size;
            supplierArray[1] = () -> totalWeight;
            supplierArray[2] = () -> selected == null ? "" : selected.name;
            supplierArray[3] = () -> selected == null ? "" : Integer.valueOf(this.getStructureWeight(x, y, z, territory, (StructureTemplate)selected));
            WorldGenDetailedLogHelper.log("Out of total of {} structures with weight total of {} structure \"{}\" with weight {} was selected", supplierArray);
            WorldGenDetailedLogHelper.log("Following structures and weights were considered: \n {}", () -> {
                StringJoiner joiner = new StringJoiner(", ");
                this.trimmedPotentialStructures.forEach(structure -> joiner.add(structure.name + ":" + this.getStructureWeight(x, y, z, territory, (StructureTemplate)structure)));
                return joiner.toString();
            });
            this.trimmedPotentialStructures.forEach(structure -> WorldGenStatistics.recordStructureConsideredInRandom(structure.name, this.getStructureWeight(x, y, z, territory, (StructureTemplate)structure), totalWeight, biomeName, territory.getTerritoryName()));
        }).orElse(null);
        this.distancesFound.clear();
        this.trimmedPotentialStructures.clear();
        return Optional.ofNullable(structureTemplate);
    }

    private int getStructureWeight(int x, int y, int z, Territory territory, StructureTemplate e) {
        boolean bigStructure = e.getValidationSettings().getClusterValue() > 50;
        int weight = e.getValidationSettings().getSelectionWeight();
        if (bigStructure) {
            return Math.max(0, (int)((double)weight - territory.getTerritoryCenter().func_177954_c((double)x, (double)y, (double)z) / TerritorySettingRegistry.getMaxTerritoryCenterDistanceSq(territory.getTerritoryName()) * (double)weight));
        }
        return weight;
    }

    private boolean validateTemplate(World world, int x, int y, int z, EnumFacing face, StructureMap map, int remainingValueCache, int dim, StructureTemplate template) {
        int dist;
        StructureValidator settings = template.getValidationSettings();
        boolean dimensionMatch = !settings.isDimensionWhiteList();
        for (int i = 0; i < settings.getAcceptedDimensions().length; ++i) {
            int dimTest = settings.getAcceptedDimensions()[i];
            if (dimTest != dim) continue;
            dimensionMatch = !dimensionMatch;
            break;
        }
        if (!dimensionMatch) {
            WorldGenStatistics.addStructureValidationRejection(template.name, ValidationRejectionReason.WRONG_DIMENSION);
            WorldGenDetailedLogHelper.log("Structure \"{}\" is defined for different dimension", () -> template.name);
            return false;
        }
        if (settings.isUnique() && map.isGeneratedUnique(template.name)) {
            WorldGenStatistics.addStructureValidationRejection(template.name, ValidationRejectionReason.UNIQUE_ALREADY_GENERATED);
            WorldGenDetailedLogHelper.log("Unique structure \"{}\" already generated", () -> template.name);
            return false;
        }
        if (settings.getClusterValue() > remainingValueCache) {
            WorldGenStatistics.addStructureValidationRejection(template.name, ValidationRejectionReason.TOO_HIGH_CLUSTER_VALUE);
            WorldGenDetailedLogHelper.log("Structure \"{}\" has too high cluster value {}", () -> template.name, () -> template.getValidationSettings().getClusterValue());
            return false;
        }
        if (this.distancesFound.containsKey(template.name) && (dist = this.distancesFound.get(template.name).intValue()) < settings.getMinDuplicateDistance()) {
            WorldGenStatistics.addStructureValidationRejection(template.name, ValidationRejectionReason.DUPLICATE_IN_RANGE);
            WorldGenDetailedLogHelper.log("Structure \"{}\" has duplicate {} blocks away", () -> template.name, () -> dist);
            return false;
        }
        return settings.shouldIncludeForSelection(world, x, y, z, face, template);
    }

    public Optional<Set<StructureTemplate>> getTerritoryTemplates(String territoryName) {
        return Optional.ofNullable(this.templatesByTerritoryName.get(territoryName));
    }
}

