/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.render;

import codechicken.lib.render.CCModelState;
import codechicken.lib.render.item.IItemRenderer;
import codechicken.lib.util.TransformUtils;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.shadowmage.ancientwarfare.structure.block.BlockCoffin;
import net.shadowmage.ancientwarfare.structure.block.BlockMulti;
import net.shadowmage.ancientwarfare.structure.block.BlockWoodenCoffin;
import net.shadowmage.ancientwarfare.structure.init.AWStructureBlocks;
import net.shadowmage.ancientwarfare.structure.item.ItemBlockWoodenCoffin;
import net.shadowmage.ancientwarfare.structure.model.ModelCoffin;
import net.shadowmage.ancientwarfare.structure.render.RenderLootInfo;
import net.shadowmage.ancientwarfare.structure.tile.TileWoodenCoffin;

public class WoodenCoffinRenderer
extends RenderLootInfo<TileWoodenCoffin>
implements IItemRenderer {
    private static final ModelCoffin COFFIN_MODEL = new ModelCoffin();
    private static final Map<BlockCoffin.IVariant, ResourceLocation> TEXTURES = new HashMap<BlockCoffin.IVariant, ResourceLocation>();
    private static final IModelState TRANSFORMS;

    public void render(TileWoodenCoffin te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        super.func_192841_a(te, x, y, z, partialTicks, destroyStage, alpha);
        IBlockState state = te.func_145831_w().func_180495_p(te.func_174877_v());
        if (state.func_177230_c() != AWStructureBlocks.WOODEN_COFFIN || Boolean.TRUE.equals(state.func_177229_b((IProperty)BlockMulti.INVISIBLE))) {
            return;
        }
        float rotation = te.getDirection().getRotationAngle();
        boolean upright = te.getUpright();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + (double)2.16f), (double)(z + 0.5));
        GlStateManager.func_179114_b((float)(-rotation), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179094_E();
        if (upright) {
            if (rotation % 90.0f == 0.0f) {
                GlStateManager.func_179137_b((double)0.0, (double)-1.25, (double)1.85);
            } else {
                GlStateManager.func_179137_b((double)0.0, (double)-1.25, (double)2.1);
            }
        } else {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.22f);
        }
        GlStateManager.func_179114_b((float)(upright ? 265.0f : 180.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.09f, (float)0.09f, (float)0.09f);
        this.func_147499_a(TEXTURES.get(te.getVariant()));
        float lidAngle = te.getPrevLidAngle() + (te.getLidAngle() - te.getPrevLidAngle()) * partialTicks;
        COFFIN_MODEL.renderAll((float)((double)(-lidAngle / 180.0f) * Math.PI));
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    @Override
    protected double getNameplateOffsetZ(TileWoodenCoffin te, double z) {
        if (!te.getUpright()) {
            return super.getNameplateOffsetZ(te, z);
        }
        double offSetZ = Math.max(Math.min(Minecraft.func_71410_x().field_71439_g.field_70161_v - (double)te.func_174877_v().func_177952_p(), 1.0), -1.0);
        return z + offSetZ;
    }

    @Override
    protected double getNameplateOffsetX(TileWoodenCoffin te, double x) {
        if (!te.getUpright()) {
            return super.getNameplateOffsetX(te, x);
        }
        double offSetX = Math.max(Math.min(Minecraft.func_71410_x().field_71439_g.field_70165_t - (double)te.func_174877_v().func_177958_n(), 1.0), -1.0);
        return x + offSetX;
    }

    public void renderItem(ItemStack stack, ItemCameraTransforms.TransformType transformType) {
        BlockWoodenCoffin.Variant variant = ItemBlockWoodenCoffin.getVariant(stack);
        GlStateManager.func_179094_E();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURES.get(variant));
        COFFIN_MODEL.renderAll();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179121_F();
    }

    public IModelState getTransforms() {
        return TRANSFORMS;
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return true;
    }

    static {
        for (BlockWoodenCoffin.Variant variant : BlockWoodenCoffin.Variant.values()) {
            TEXTURES.put(variant, new ResourceLocation("ancientwarfare", "textures/model/structure/coffin_" + variant.func_176610_l() + ".png"));
        }
        EnumMap<ItemCameraTransforms.TransformType, TRSRTransformation> map = new EnumMap<ItemCameraTransforms.TransformType, TRSRTransformation>(ItemCameraTransforms.TransformType.class);
        TRSRTransformation thirdPerson = TransformUtils.create((float)0.0f, (float)3.0f, (float)5.0f, (float)75.0f, (float)180.0f, (float)180.0f, (float)0.015f);
        map.put(ItemCameraTransforms.TransformType.GUI, TransformUtils.create((float)6.0f, (float)5.0f, (float)0.0f, (float)60.0f, (float)225.0f, (float)200.0f, (float)0.035f));
        map.put(ItemCameraTransforms.TransformType.GROUND, TransformUtils.create((float)0.0f, (float)8.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)180.0f, (float)0.025f));
        map.put(ItemCameraTransforms.TransformType.FIXED, TransformUtils.create((float)0.0f, (float)-4.0f, (float)-12.0f, (float)90.0f, (float)180.0f, (float)0.0f, (float)0.035f));
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, thirdPerson);
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, TransformUtils.flipLeft((TRSRTransformation)thirdPerson));
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, TransformUtils.create((float)25.0f, (float)-15.0f, (float)-10.0f, (float)50.0f, (float)170.0f, (float)170.0f, (float)0.08f));
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, TransformUtils.create((float)25.0f, (float)-15.0f, (float)-10.0f, (float)50.0f, (float)170.0f, (float)170.0f, (float)0.08f));
        TRANSFORMS = new CCModelState(map);
    }
}

