/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.render;

import codechicken.lib.render.CCModelState;
import codechicken.lib.render.item.IItemRenderer;
import codechicken.lib.util.TransformUtils;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.shadowmage.ancientwarfare.structure.block.BlockCoffin;
import net.shadowmage.ancientwarfare.structure.block.BlockMulti;
import net.shadowmage.ancientwarfare.structure.block.BlockStoneCoffin;
import net.shadowmage.ancientwarfare.structure.init.AWStructureBlocks;
import net.shadowmage.ancientwarfare.structure.item.ItemBlockStoneCoffin;
import net.shadowmage.ancientwarfare.structure.model.ModelStoneCoffin;
import net.shadowmage.ancientwarfare.structure.render.RenderLootInfo;
import net.shadowmage.ancientwarfare.structure.tile.TileStoneCoffin;

public class StoneCoffinRenderer
extends RenderLootInfo<TileStoneCoffin>
implements IItemRenderer {
    private static final ModelStoneCoffin STONE_COFFIN_MODEL = new ModelStoneCoffin();
    private static final Map<BlockCoffin.IVariant, ResourceLocation> TEXTURES = new HashMap<BlockCoffin.IVariant, ResourceLocation>();
    private static final IModelState TRANSFORMS;

    public void render(TileStoneCoffin te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        super.func_192841_a(te, x, y, z, partialTicks, destroyStage, alpha);
        IBlockState state = te.func_145831_w().func_180495_p(te.func_174877_v());
        if (state.func_177230_c() != AWStructureBlocks.STONE_COFFIN || Boolean.TRUE.equals(state.func_177229_b((IProperty)BlockMulti.INVISIBLE))) {
            return;
        }
        float rotation = te.getDirection().getRotationAngle();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)(y + (double)1.78f), (double)z);
        GlStateManager.func_179114_b((float)(-rotation), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179094_E();
        switch ((int)rotation) {
            case 0: {
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
                break;
            }
            case 90: {
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2.0f);
                break;
            }
            case 180: {
                GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)-2.0f);
                break;
            }
            default: {
                GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)-1.0f);
            }
        }
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.074f, (float)0.074f, (float)0.074f);
        this.func_147499_a(TEXTURES.get(te.getVariant()));
        float lidAngle = te.getPrevLidAngle() + (te.getLidAngle() - te.getPrevLidAngle()) * partialTicks;
        STONE_COFFIN_MODEL.renderAll((float)((double)(-lidAngle / 180.0f) * Math.PI));
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    public void renderItem(ItemStack stack, ItemCameraTransforms.TransformType transformType) {
        BlockStoneCoffin.Variant variant = ItemBlockStoneCoffin.getVariant(stack);
        GlStateManager.func_179094_E();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURES.get(variant));
        STONE_COFFIN_MODEL.renderAll();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179121_F();
    }

    public IModelState getTransforms() {
        return TRANSFORMS;
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return true;
    }

    static {
        for (BlockStoneCoffin.Variant variant : BlockStoneCoffin.Variant.values()) {
            TEXTURES.put(variant, new ResourceLocation("ancientwarfare", "textures/model/structure/stone_coffin_" + variant.func_176610_l() + ".png"));
        }
        EnumMap<ItemCameraTransforms.TransformType, TRSRTransformation> map = new EnumMap<ItemCameraTransforms.TransformType, TRSRTransformation>(ItemCameraTransforms.TransformType.class);
        TRSRTransformation thirdPerson = TransformUtils.create((float)0.0f, (float)3.0f, (float)5.0f, (float)75.0f, (float)180.0f, (float)180.0f, (float)0.015f);
        map.put(ItemCameraTransforms.TransformType.GUI, TransformUtils.create((float)1.0f, (float)4.0f, (float)0.0f, (float)60.0f, (float)225.0f, (float)200.0f, (float)0.019f));
        map.put(ItemCameraTransforms.TransformType.GROUND, TransformUtils.create((float)0.0f, (float)8.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)180.0f, (float)0.017f));
        map.put(ItemCameraTransforms.TransformType.FIXED, TransformUtils.create((float)0.0f, (float)-4.0f, (float)-12.0f, (float)90.0f, (float)180.0f, (float)0.0f, (float)0.035f));
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, thirdPerson);
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, TransformUtils.flipLeft((TRSRTransformation)thirdPerson));
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, TransformUtils.create((float)25.0f, (float)-15.0f, (float)-10.0f, (float)50.0f, (float)170.0f, (float)170.0f, (float)0.08f));
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, TransformUtils.create((float)25.0f, (float)-15.0f, (float)-10.0f, (float)50.0f, (float)170.0f, (float)170.0f, (float)0.08f));
        TRANSFORMS = new CCModelState(map);
    }
}

