/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.render;

import codechicken.lib.model.bakery.generation.ISimpleBlockBakery;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.block.BlockSoundBlock;
import net.shadowmage.ancientwarfare.structure.tile.TileSoundBlock;

@SideOnly(value=Side.CLIENT)
public class SoundBlockRenderer
implements ISimpleBlockBakery {
    public static ModelResourceLocation MODEL_LOCATION = new ModelResourceLocation(new ResourceLocation("ancientwarfare", "structure/sound_block"), "normal");
    public static SoundBlockRenderer INSTANCE = new SoundBlockRenderer();

    private SoundBlockRenderer() {
    }

    public List<BakedQuad> bakeQuads(@Nullable EnumFacing face, IExtendedBlockState state) {
        String[] parts;
        IBlockState disguiseState = Blocks.field_150421_aI.func_176223_P();
        String blockState = (String)state.getValue(BlockSoundBlock.DISGUISE_BLOCK);
        if (blockState != null && (parts = blockState.split("\\|")).length == 2) {
            disguiseState = Block.func_149684_b((String)parts[0]).func_176203_a(Integer.valueOf(parts[1]).intValue());
        }
        return Minecraft.func_71410_x().field_175617_aL.func_174954_c().func_178125_b(disguiseState).func_188616_a(disguiseState, face, 0L);
    }

    public IExtendedBlockState handleState(IExtendedBlockState state, IBlockAccess access, BlockPos pos) {
        IBlockState disguiseState = WorldTools.getTile(access, pos, TileSoundBlock.class).map(TileSoundBlock::getDisguiseState).orElse(null);
        String registryName = String.join((CharSequence)"|", Blocks.field_150421_aI.getRegistryName().toString(), "0");
        if (disguiseState != null) {
            registryName = String.join((CharSequence)"|", disguiseState.func_177230_c().getRegistryName().toString(), Integer.toString(disguiseState.func_177230_c().func_176201_c(disguiseState)));
        }
        return state.withProperty(BlockSoundBlock.DISGUISE_BLOCK, (Object)registryName);
    }

    public List<BakedQuad> bakeItemQuads(@Nullable EnumFacing face, ItemStack stack) {
        IBlockState defaultState = Blocks.field_150421_aI.func_176223_P();
        return Minecraft.func_71410_x().field_175617_aL.func_174954_c().func_178125_b(defaultState).func_188616_a(defaultState, face, 0L);
    }
}

