/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.render;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.RenderTools;
import net.shadowmage.ancientwarfare.structure.api.TemplateRuleBlock;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;

@SideOnly(value=Side.CLIENT)
public class PreviewRenderer {
    @SideOnly(value=Side.CLIENT)
    private static Cache<Integer, CachedState> previewCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();

    private PreviewRenderer() {
    }

    public static void clearCache() {
        previewCache.cleanUp();
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderTemplatePreview(EntityPlayer player, EnumHand hand, ItemStack stack, float delta, StructureTemplate structure, StructureBB bb, int turns) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179094_E();
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        int cacheKey = PreviewRenderer.getKey(stack, turns, hand);
        Optional<Object> state = Optional.ofNullable(previewCache.getIfPresent((Object)cacheKey));
        Vec3i offset = Vec3i.field_177959_e;
        if (state.isPresent()) {
            buffer.func_178993_a(((CachedState)state.get()).getVertexState());
            BlockPos bbMin = ((CachedState)state.get()).getBBMin();
            if (!bbMin.equals((Object)bb.min)) {
                offset = bb.min.func_177982_a(-bbMin.func_177958_n(), -bbMin.func_177956_o(), -bbMin.func_177952_p());
            }
        } else {
            HashMap<BlockPos, TemplateRuleBlock> dynamicRenderRules = new HashMap<BlockPos, TemplateRuleBlock>();
            PreviewRenderer.renderPreview(structure, bb, turns, buffer, dynamicRenderRules);
            CachedState stateToCache = new CachedState(bb.min, buffer.func_181672_a(), dynamicRenderRules);
            previewCache.put((Object)cacheKey, (Object)stateToCache);
            state = Optional.of(stateToCache);
        }
        GlStateManager.func_179137_b((double)(-RenderTools.getRenderOffsetX(player, delta) + (double)0.005f + (double)offset.func_177958_n()), (double)(-RenderTools.getRenderOffsetY(player, delta) + (double)0.005f + (double)offset.func_177956_o()), (double)(-RenderTools.getRenderOffsetZ(player, delta) + (double)0.005f + (double)offset.func_177952_p()));
        tessellator.func_78381_a();
        PreviewRenderer.renderDynamicRules(turns, (CachedState)state.get());
        GlStateManager.func_179121_F();
    }

    private static void renderDynamicRules(int turns, CachedState state) {
        Iterator it = state.getDynamicRenderRules().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            try {
                ((TemplateRuleBlock)entry.getValue()).renderRuleDynamic(turns, (BlockPos)entry.getKey());
            }
            catch (Exception e) {
                it.remove();
            }
        }
    }

    private static int getKey(ItemStack stack, int turns, EnumHand hand) {
        int hash = stack.hashCode();
        hash = hash * 31 + turns;
        hash = hash * 31 + hand.hashCode();
        return hash;
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderPreview(StructureTemplate structure, StructureBB bb, int turns, BufferBuilder buffer, Map<BlockPos, TemplateRuleBlock> dynamicRenderRules) {
        TemplateBlockAccess blockAccess = new TemplateBlockAccess(structure, bb, turns);
        for (int pass = 0; pass < 3; ++pass) {
            for (int y = 0; y < structure.getSize().func_177956_o(); ++y) {
                for (int x = 0; x < structure.getSize().func_177958_n(); ++x) {
                    for (int z = 0; z < structure.getSize().func_177952_p(); ++z) {
                        BlockPos pos = new BlockPos(x, y, z);
                        PreviewRenderer.renderPreviewAt(structure, bb, turns, buffer, dynamicRenderRules, blockAccess, pos);
                    }
                }
            }
        }
    }

    private static void renderPreviewAt(StructureTemplate structure, StructureBB bb, int turns, BufferBuilder buffer, Map<BlockPos, TemplateRuleBlock> dynamicRenderRules, TemplateBlockAccess blockAccess, BlockPos pos) {
        BlockPos translateTo = BlockTools.rotateInArea(pos, structure.getSize().func_177958_n(), structure.getSize().func_177952_p(), turns).func_177971_a((Vec3i)bb.min);
        structure.getRuleAt((Vec3i)pos).ifPresent(r -> {
            r.renderRule(turns, translateTo, blockAccess, buffer);
            if (r.isDynamicallyRendered(turns)) {
                dynamicRenderRules.put(translateTo, (TemplateRuleBlock)r);
            }
        });
    }

    private static class CachedState {
        private final BlockPos bbMin;
        private final BufferBuilder.State vertexState;
        private final Map<BlockPos, TemplateRuleBlock> dynamicRenderRules;

        private CachedState(BlockPos bbMin, BufferBuilder.State vertexState, Map<BlockPos, TemplateRuleBlock> dynamicRenderRules) {
            this.bbMin = bbMin;
            this.vertexState = vertexState;
            this.dynamicRenderRules = dynamicRenderRules;
        }

        private BufferBuilder.State getVertexState() {
            return this.vertexState;
        }

        private BlockPos getBBMin() {
            return this.bbMin;
        }

        private Map<BlockPos, TemplateRuleBlock> getDynamicRenderRules() {
            return this.dynamicRenderRules;
        }
    }

    private static class TemplateBlockAccess
    implements IBlockAccess {
        private final int templateXSize;
        private final int templateZSize;
        private StructureTemplate template;
        private StructureBB bb;
        private int turns;
        private Map<Long, IBlockState> positionStates = new HashMap<Long, IBlockState>();
        private Map<Long, TileEntity> positionTiles = new HashMap<Long, TileEntity>();

        private TemplateBlockAccess(StructureTemplate template, StructureBB bb, int turns) {
            this.template = template;
            this.bb = bb;
            this.turns = turns;
            int xSize = template.getSize().func_177958_n();
            int zSize = template.getSize().func_177952_p();
            if ((double)turns % 2.0 != 0.0) {
                this.templateXSize = zSize;
                this.templateZSize = xSize;
            } else {
                this.templateXSize = xSize;
                this.templateZSize = zSize;
            }
        }

        @Nullable
        public TileEntity func_175625_s(BlockPos pos) {
            long posSerialized = pos.func_177986_g();
            if (!this.positionTiles.containsKey(posSerialized)) {
                if (!this.bb.contains(pos)) {
                    this.positionTiles.put(posSerialized, null);
                } else {
                    this.getBlockRuleAt(pos).ifPresent(templateRuleBlock -> this.positionTiles.put(posSerialized, templateRuleBlock.getTileEntity(this.turns)));
                }
            }
            return this.positionTiles.get(posSerialized);
        }

        @SideOnly(value=Side.CLIENT)
        public int func_175626_b(BlockPos pos, int lightValue) {
            return 8;
        }

        public IBlockState func_180495_p(BlockPos pos) {
            long posSerialized = pos.func_177986_g();
            IBlockState state = this.positionStates.get(posSerialized);
            if (state == null) {
                if (!this.bb.contains(pos)) {
                    this.positionStates.put(posSerialized, Blocks.field_150350_a.func_176223_P());
                } else {
                    this.positionStates.put(posSerialized, this.getBlockRuleAt(pos).map(templateRuleBlock -> templateRuleBlock.getState(this.turns)).orElse(Blocks.field_150350_a.func_176223_P()));
                }
                state = this.positionStates.get(posSerialized);
            }
            return state;
        }

        private Optional<TemplateRuleBlock> getBlockRuleAt(BlockPos pos) {
            BlockPos tempPos = BlockTools.rotateInArea(pos.func_177982_a(-this.bb.min.func_177958_n(), -this.bb.min.func_177956_o(), -this.bb.min.func_177952_p()), this.templateXSize, this.templateZSize, -this.turns);
            return this.template.getRuleAt((Vec3i)tempPos);
        }

        public boolean func_175623_d(BlockPos pos) {
            return false;
        }

        public Biome func_180494_b(BlockPos pos) {
            return Biomes.field_76772_c;
        }

        public int func_175627_a(BlockPos pos, EnumFacing direction) {
            return 0;
        }

        public WorldType func_175624_G() {
            return WorldType.field_77137_b;
        }

        public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean defaultValue) {
            return false;
        }
    }
}

