/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.registry;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.JsonUtils;
import net.shadowmage.ancientwarfare.core.registry.IRegistryDataParser;
import net.shadowmage.ancientwarfare.core.util.parsing.JsonHelper;

public class TerritorySettingRegistry {
    private static TerritorySettings defaultSettings = new TerritorySettings(11, 1.0f, 1.0f, 1.0f);
    private static Map<String, TerritorySettings> territorySettings = new HashMap<String, TerritorySettings>();

    private TerritorySettingRegistry() {
    }

    public static TerritorySettings getTerritorySettings(String territoryName) {
        return territorySettings.getOrDefault(territoryName, defaultSettings);
    }

    public static double getMaxTerritoryCenterDistanceSq(String territoryName) {
        int maxTerritoryChunkRadius = TerritorySettingRegistry.getTerritorySettings(territoryName).getMaxRadiusInChunks();
        return Math.pow((double)maxTerritoryChunkRadius * 16.0, 2.0);
    }

    public static class Parser
    implements IRegistryDataParser {
        private static void setDefaultSettings(TerritorySettings defaultSettings) {
            defaultSettings = defaultSettings;
        }

        @Override
        public String getName() {
            return "territory_settings";
        }

        @Override
        public void parse(JsonObject json) {
            JsonObject defaultJson = JsonUtils.func_152754_s((JsonObject)json, (String)"defaults");
            Parser.setDefaultSettings(this.getTerritorySettings(defaultJson, new TerritorySettings.Builder()));
            JsonHelper.mapFromJson(json, "territories", territorySettings, Map.Entry::getKey, e -> {
                TerritorySettings.Builder builder = new TerritorySettings.Builder(defaultSettings);
                return this.getTerritorySettings(JsonUtils.func_151210_l((JsonElement)((JsonElement)e.getValue()), (String)""), builder);
            });
        }

        private TerritorySettings getTerritorySettings(JsonObject json, TerritorySettings.Builder builder) {
            if (JsonUtils.func_151204_g((JsonObject)json, (String)"max_radius_in_chunks")) {
                builder.setMaxRadiusInChunks(JsonUtils.func_151203_m((JsonObject)json, (String)"max_radius_in_chunks"));
            }
            if (JsonUtils.func_151204_g((JsonObject)json, (String)"per_chunk_cluster_value_multiplier")) {
                builder.setPerChunkClusterValueMultiplier(JsonUtils.func_151217_k((JsonObject)json, (String)"per_chunk_cluster_value_multiplier"));
            }
            if (JsonUtils.func_151204_g((JsonObject)json, (String)"structure_generation_chance_multiplier")) {
                builder.setStructureGenerationChanceMultiplier(JsonUtils.func_151217_k((JsonObject)json, (String)"structure_generation_chance_multiplier"));
            }
            if (JsonUtils.func_151204_g((JsonObject)json, (String)"territory_weight_multiplier")) {
                builder.setTerritoryWeightMultiplier(JsonUtils.func_151217_k((JsonObject)json, (String)"territory_weight_multiplier"));
            }
            return builder.build();
        }
    }

    public static class TerritorySettings {
        private int maxRadiusInChunks;
        private float perChunkClusterValueMultiplier;
        private float structureGenerationChanceMultiplier;
        private float territoryWeightMultiplier;

        int getMaxRadiusInChunks() {
            return this.maxRadiusInChunks;
        }

        public float getPerChunkClusterValueMultiplier() {
            return this.perChunkClusterValueMultiplier;
        }

        public float getStructureGenerationChanceMultiplier() {
            return this.structureGenerationChanceMultiplier;
        }

        public float getTerritoryWeightMultiplier() {
            return this.territoryWeightMultiplier;
        }

        private TerritorySettings(int maxRadiusInChunks, float perChunkClusterValueMultiplier, float structureGenerationChanceMultiplier, float territoryWeightMultiplier) {
            this.maxRadiusInChunks = maxRadiusInChunks;
            this.perChunkClusterValueMultiplier = perChunkClusterValueMultiplier;
            this.structureGenerationChanceMultiplier = structureGenerationChanceMultiplier;
            this.territoryWeightMultiplier = territoryWeightMultiplier;
        }

        public static class Builder {
            private int maxRadiusInChunks;
            private float perChunkClusterValueMultiplier;
            private float structureGenerationChanceMultiplier;
            private float territoryWeightMultiplier;

            void setMaxRadiusInChunks(int maxRadiusInChunks) {
                this.maxRadiusInChunks = maxRadiusInChunks;
            }

            void setPerChunkClusterValueMultiplier(float perChunkClusterValueMultiplier) {
                this.perChunkClusterValueMultiplier = perChunkClusterValueMultiplier;
            }

            void setStructureGenerationChanceMultiplier(float structureGenerationChanceMultiplier) {
                this.structureGenerationChanceMultiplier = structureGenerationChanceMultiplier;
            }

            void setTerritoryWeightMultiplier(float territoryWeightMultiplier) {
                this.territoryWeightMultiplier = territoryWeightMultiplier;
            }

            Builder() {
            }

            Builder(TerritorySettings settings) {
                this.maxRadiusInChunks = settings.maxRadiusInChunks;
                this.perChunkClusterValueMultiplier = settings.perChunkClusterValueMultiplier;
                this.structureGenerationChanceMultiplier = settings.structureGenerationChanceMultiplier;
                this.territoryWeightMultiplier = settings.territoryWeightMultiplier;
            }

            public TerritorySettings build() {
                return new TerritorySettings(this.maxRadiusInChunks, this.perChunkClusterValueMultiplier, this.structureGenerationChanceMultiplier, this.territoryWeightMultiplier);
            }
        }
    }
}

