/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.gamedata.AWGameData;
import net.shadowmage.ancientwarfare.core.network.PacketBase;
import net.shadowmage.ancientwarfare.core.util.PacketHelper;
import net.shadowmage.ancientwarfare.structure.gamedata.StructureEntry;
import net.shadowmage.ancientwarfare.structure.gamedata.StructureMap;

public class PacketStructureEntry
extends PacketBase {
    private int dimension;
    private int cx;
    private int cz;
    private StructureEntry entry;

    public PacketStructureEntry() {
    }

    public PacketStructureEntry(int dimension, int cx, int cz, StructureEntry entry) {
        this.dimension = dimension;
        this.cx = cx;
        this.cz = cz;
        this.entry = entry;
    }

    @Override
    protected void writeToStream(ByteBuf data) {
        data.writeInt(this.dimension);
        data.writeInt(this.cx);
        data.writeInt(this.cz);
        NBTTagCompound entryTag = new NBTTagCompound();
        this.entry.writeToNBT(entryTag);
        PacketHelper.writeNBTTag(data, entryTag);
    }

    @Override
    protected void readFromStream(ByteBuf data) {
        this.dimension = data.readInt();
        this.cx = data.readInt();
        this.cz = data.readInt();
        this.entry = new StructureEntry();
        this.entry.readFromNBT(PacketHelper.readNBTTag(data));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void execute() {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            AWGameData.INSTANCE.getPerWorldData((World)world, StructureMap.class).setGeneratedAt(this.dimension, this.cx, this.cz, this.entry, false);
        }
    }
}

