/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.item;

import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.input.IItemKeyInterface;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;
import net.shadowmage.ancientwarfare.structure.gui.GuiTownSelection;
import net.shadowmage.ancientwarfare.structure.item.ItemBaseStructure;
import net.shadowmage.ancientwarfare.structure.town.TownBoundingArea;
import net.shadowmage.ancientwarfare.structure.town.TownTemplate;
import net.shadowmage.ancientwarfare.structure.town.TownTemplateManager;
import net.shadowmage.ancientwarfare.structure.town.WorldTownGenerator;

public class ItemTownBuilder
extends ItemBaseStructure
implements IItemKeyInterface {
    public ItemTownBuilder(String name) {
        super(name);
        this.func_77625_d(1);
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return false;
    }

    @Override
    public boolean onKeyActionClient(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemAltFunction altFunction) {
        return altFunction == IItemKeyInterface.ItemAltFunction.ALT_FUNCTION_1;
    }

    @Override
    public void onKeyAction(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemAltFunction altFunction) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        RayTraceResult rayTraceResult = this.func_77621_a(player.field_70170_p, player, false);
        if (rayTraceResult == null || rayTraceResult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        Optional<TownTemplate> template = TownTemplateManager.INSTANCE.getTemplate(ItemTownBuilder.getTownName(stack));
        if (!template.isPresent()) {
            player.func_145747_a((ITextComponent)new TextComponentString("No town template set"));
            return;
        }
        long t1 = System.nanoTime();
        WorldTownGenerator.INSTANCE.generate(player.field_70170_p, this.getTownArea(rayTraceResult.func_178782_a(), player.func_174811_aO(), ItemTownBuilder.getLength(stack), ItemTownBuilder.getWidth(stack)), template.get());
        long t2 = System.nanoTime();
        AncientWarfareStructure.LOG.debug("Total Town gen nanos (incl. validation): {}", (Object)(t2 - t1));
    }

    private TownBoundingArea getTownArea(BlockPos pos, EnumFacing horizontalFacing, int chunkLength, int chunkWidth) {
        int minY = Math.max(pos.func_177956_o() - 3, 0);
        int maxY = Math.min(minY + 40, 255);
        if (horizontalFacing.func_176740_k() == EnumFacing.Axis.X) {
            int chunkMinX = (pos.func_177958_n() >> 4) - (horizontalFacing.func_82601_c() < 0 ? chunkLength : 0);
            int chunkMaxX = (pos.func_177958_n() >> 4) + (horizontalFacing.func_82601_c() > 0 ? chunkLength : 0);
            int chunkMinZ = (pos.func_177952_p() >> 4) - chunkWidth / 2;
            int chunkMaxZ = chunkMinZ + chunkWidth;
            return new TownBoundingArea(chunkMinX, chunkMinZ, chunkMaxX, chunkMaxZ, minY, maxY);
        }
        int chunkMinX = (pos.func_177958_n() >> 4) - chunkWidth / 2;
        int chunkMaxX = chunkMinX + chunkWidth;
        int chunkMinZ = (pos.func_177952_p() >> 4) - (horizontalFacing.func_82599_e() < 0 ? chunkLength : 0);
        int chunkMaxZ = (pos.func_177952_p() >> 4) + (horizontalFacing.func_82599_e() > 0 ? chunkLength : 0);
        return new TownBoundingArea(chunkMinX, chunkMinZ, chunkMaxX, chunkMaxZ, minY, maxY);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!player.field_70170_p.field_72995_K && !player.func_70093_af()) {
            NetworkHandler.INSTANCE.openGui(player, 54, 0, 0, 0);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public static String getTownName(ItemStack townBuilder) {
        return townBuilder.func_77978_p() == null ? "" : townBuilder.func_77978_p().func_74779_i("townName");
    }

    public static void setTownName(ItemStack townBuilder, String structName) {
        townBuilder.func_77983_a("townName", (NBTBase)new NBTTagString(structName));
    }

    public static void setWidth(ItemStack townBuilder, int width) {
        townBuilder.func_77983_a("width", (NBTBase)new NBTTagInt(width));
    }

    public static void setLength(ItemStack townBuilder, int length) {
        townBuilder.func_77983_a("length", (NBTBase)new NBTTagInt(length));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        super.registerClient();
        NetworkHandler.registerGui(54, GuiTownSelection.class);
    }

    public static int getWidth(ItemStack townBuilder) {
        return townBuilder.func_77942_o() ? townBuilder.func_77978_p().func_74762_e("width") : 0;
    }

    public static int getLength(ItemStack townBuilder) {
        return townBuilder.func_77942_o() ? townBuilder.func_77978_p().func_74762_e("length") : 0;
    }
}

