/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.item;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.input.IItemKeyInterface;
import net.shadowmage.ancientwarfare.core.input.InputHandler;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.EntityTools;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.gui.GuiLootChestPlacer;
import net.shadowmage.ancientwarfare.structure.item.ItemBaseStructure;
import net.shadowmage.ancientwarfare.structure.registry.EntitySpawnNBTRegistry;
import net.shadowmage.ancientwarfare.structure.tile.ISpecialLootContainer;
import net.shadowmage.ancientwarfare.structure.tile.LootSettings;

public class ItemLootChestPlacer
extends ItemBaseStructure
implements IItemKeyInterface {
    private static final String LOOT_SETTINGS_TAG = "lootSettings";
    private static final Map<String, LootContainerInfo> LOOT_CONTAINERS = new LinkedHashMap<String, LootContainerInfo>();
    private static final String LOOT_CONTAINER_NAME_TAG = "lootContainerName";

    public static Map<String, LootContainerInfo> getLootContainers() {
        return LOOT_CONTAINERS;
    }

    public static void registerLootContainer(String name, ItemStack stack, LootContainerInfo.IPlacementChecker mayPlace) {
        LOOT_CONTAINERS.put(name, new LootContainerInfo(name, stack, mayPlace));
    }

    public ItemLootChestPlacer() {
        super("loot_chest_placer");
        this.func_77625_d(1);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!player.field_70170_p.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 55, 0, 0, 0);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack lootChestPlacer = EntityTools.getItemFromEitherHand(player, ItemLootChestPlacer.class);
        if (lootChestPlacer.func_190926_b()) {
            return;
        }
        event.setCanceled(true);
        event.setCancellationResult(EnumActionResult.SUCCESS);
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        Entity entity = event.getTarget();
        LootSettings lootSettings = ItemLootChestPlacer.getLootSettings(lootChestPlacer).orElse(new LootSettings());
        lootSettings.setSpawnEntity(true);
        lootSettings.setEntity(EntityRegistry.getEntry(entity.getClass()).getRegistryName());
        lootSettings.setEntityNBT(EntitySpawnNBTRegistry.getEntitySpawnNBT(entity));
        ItemLootChestPlacer.setLootSettings(lootChestPlacer, lootSettings);
        entity.func_70106_y();
        event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("guistrings.spawner.entity_set", new Object[]{entity.func_70005_c_()}));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String keyText = InputHandler.ALT_ITEM_USE_1.getDisplayName();
        String text = keyText + " = " + I18n.func_135052_a((String)"guistrings.structure.loot_placer.copy", (Object[])new Object[0]);
        tooltip.add(text);
        keyText = InputHandler.ALT_ITEM_USE_2.getDisplayName();
        text = keyText + " = " + I18n.func_135052_a((String)"guistrings.structure.loot_placer.paste", (Object[])new Object[0]);
        tooltip.add(text);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemBlockStack;
        ItemBlock itemBlock;
        Block block;
        if (player.func_70093_af()) {
            return EnumActionResult.PASS;
        }
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        ItemStack placer = player.func_184586_b(hand);
        Optional<LootSettings> lootSettings = ItemLootChestPlacer.getLootSettings(placer);
        if (!lootSettings.isPresent()) {
            return EnumActionResult.PASS;
        }
        BlockPos placePos = pos.func_177972_a(facing);
        LootContainerInfo lootContainerInfo = ItemLootChestPlacer.getLootContainerInfo(placer);
        if (lootContainerInfo.canPlace(block = (itemBlock = (ItemBlock)(itemBlockStack = lootContainerInfo.getStack()).func_77973_b()).func_179223_d(), world, placePos, facing, player)) {
            itemBlock.placeBlockAt(itemBlockStack, player, world, placePos, facing, hitX, hitY, hitZ, block.getStateForPlacement(world, placePos, facing, hitX, hitY, hitZ, itemBlockStack.func_77960_j(), (EntityLivingBase)player, hand));
            WorldTools.getTile((IBlockAccess)world, placePos, ISpecialLootContainer.class).ifPresent(t -> ((LootSettings)lootSettings.get()).transferToContainer((ISpecialLootContainer)t));
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public static LootContainerInfo getLootContainerInfo(ItemStack placer) {
        NBTTagCompound compound;
        if (placer.func_77942_o() && (compound = placer.func_77978_p()).func_74764_b(LOOT_CONTAINER_NAME_TAG)) {
            return LOOT_CONTAINERS.getOrDefault(compound.func_74779_i(LOOT_CONTAINER_NAME_TAG), ItemLootChestPlacer.getFirstLootContainer());
        }
        return ItemLootChestPlacer.getFirstLootContainer();
    }

    public static void setContainerName(ItemStack placer, String name) {
        placer.func_77983_a(LOOT_CONTAINER_NAME_TAG, (NBTBase)new NBTTagString(name));
    }

    private static LootContainerInfo getFirstLootContainer() {
        return LOOT_CONTAINERS.values().iterator().next();
    }

    public static Optional<LootSettings> getLootSettings(ItemStack placer) {
        return placer.func_77942_o() && placer.func_77978_p().func_74764_b(LOOT_SETTINGS_TAG) ? Optional.of(LootSettings.deserializeNBT(placer.func_77978_p().func_74775_l(LOOT_SETTINGS_TAG))) : Optional.empty();
    }

    public static void setLootSettings(ItemStack placer, LootSettings lootSettings) {
        placer.func_77983_a(LOOT_SETTINGS_TAG, (NBTBase)lootSettings.serializeNBT());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        super.registerClient();
        NetworkHandler.registerGui(55, GuiLootChestPlacer.class);
    }

    @Override
    public boolean onKeyActionClient(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemAltFunction altFunction) {
        return altFunction == IItemKeyInterface.ItemAltFunction.ALT_FUNCTION_1 || altFunction == IItemKeyInterface.ItemAltFunction.ALT_FUNCTION_2;
    }

    @Override
    public void onKeyAction(EntityPlayer player, ItemStack placer, IItemKeyInterface.ItemAltFunction altFunction) {
        BlockPos hit = BlockTools.getBlockClickedOn(player, player.field_70170_p, false);
        WorldTools.getTile((IBlockAccess)player.field_70170_p, hit, ISpecialLootContainer.class).ifPresent(te -> {
            if (altFunction == IItemKeyInterface.ItemAltFunction.ALT_FUNCTION_1) {
                IBlockState state = player.field_70170_p.func_180495_p(hit);
                this.getLootContainerInfoByStack(state.func_177230_c().getPickBlock(state, new RayTraceResult(new Vec3d(0.0, 0.0, 0.0), EnumFacing.UP, hit), player.field_70170_p, hit, player)).ifPresent(container -> ItemLootChestPlacer.setContainerName(placer, container.getName()));
                ItemLootChestPlacer.getLootSettings(placer).ifPresent(s -> ItemLootChestPlacer.setLootSettings(placer, s.transferFromContainer((ISpecialLootContainer)te)));
            } else if (altFunction == IItemKeyInterface.ItemAltFunction.ALT_FUNCTION_2) {
                ItemLootChestPlacer.getLootSettings(placer).ifPresent(s -> s.transferToContainer((ISpecialLootContainer)te));
                BlockTools.notifyBlockUpdate(player.field_70170_p, hit);
            }
        });
    }

    private Optional<LootContainerInfo> getLootContainerInfoByStack(ItemStack stack) {
        for (LootContainerInfo container : LOOT_CONTAINERS.values()) {
            if (!ItemStack.func_77989_b((ItemStack)container.getStack(), (ItemStack)stack)) continue;
            return Optional.of(container);
        }
        return Optional.empty();
    }

    public static class LootContainerInfo {
        public static final IPlacementChecker SINGLE_BLOCK_PLACEMENT_CHECKER = (block, world, pos, sidePlacedOn, placer) -> block.func_176196_c(world, pos);
        private final String name;
        private final ItemStack stack;
        private final IPlacementChecker placementChecker;

        private LootContainerInfo(String name, ItemStack stack, IPlacementChecker placementChecker) {
            this.name = name;
            this.stack = stack;
            this.placementChecker = placementChecker;
        }

        public String getName() {
            return this.name;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        private boolean canPlace(Block block, World world, BlockPos pos, EnumFacing sidePlacedOn, EntityPlayer placer) {
            return this.placementChecker.mayPlace(block, world, pos, sidePlacedOn, placer);
        }

        public static interface IPlacementChecker {
            public boolean mayPlace(Block var1, World var2, BlockPos var3, EnumFacing var4, EntityPlayer var5);
        }
    }
}

