/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.item;

import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.input.IItemKeyInterface;
import net.shadowmage.ancientwarfare.core.input.InputHandler;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.event.IBoxRenderer;
import net.shadowmage.ancientwarfare.structure.item.FloodFillPathfinder;
import net.shadowmage.ancientwarfare.structure.item.ItemBaseStructure;

public class ItemConstructionTool
extends ItemBaseStructure
implements IItemKeyInterface,
IBoxRenderer {
    public ItemConstructionTool(String name) {
        super(name);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flagIn) {
        ConstructionSettings settings = ItemConstructionTool.getSettings(stack);
        if (settings == null) {
            return;
        }
        String text = I18n.func_135052_a((String)"guistrings.construction.mode", (Object[])new Object[0]) + ": " + (Object)((Object)settings.type);
        tooltip.add(text);
        text = I18n.func_135052_a((String)"guistrings.construction.fill_block", (Object[])new Object[0]) + ": " + Block.field_149771_c.func_177774_c((Object)settings.block);
        tooltip.add(text);
        text = "RMB = " + I18n.func_135052_a((String)"guistrings.construction.do_action", (Object[])new Object[0]);
        tooltip.add(text);
        String keyText = InputHandler.ALT_ITEM_USE_1.getDisplayName();
        text = keyText + " = " + I18n.func_135052_a((String)"guistrings.construction.toggle_mode", (Object[])new Object[0]);
        tooltip.add(text);
        keyText = InputHandler.ALT_ITEM_USE_2.getDisplayName();
        text = keyText + " = " + I18n.func_135052_a((String)"guistrings.construction.set_fill_block", (Object[])new Object[0]);
        tooltip.add(text);
        keyText = InputHandler.ALT_ITEM_USE_3.getDisplayName();
        text = keyText + " = " + I18n.func_135052_a((String)"guistrings.construction.set_pos_1", (Object[])new Object[0]);
        tooltip.add(text);
        keyText = InputHandler.ALT_ITEM_USE_4.getDisplayName();
        text = keyText + " = " + I18n.func_135052_a((String)"guistrings.construction.set_pos_2", (Object[])new Object[0]);
        tooltip.add(text);
        keyText = InputHandler.ALT_ITEM_USE_5.getDisplayName();
        text = keyText + " = " + I18n.func_135052_a((String)"guistrings.construction.clear_positions", (Object[])new Object[0]);
        tooltip.add(text);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        ConstructionSettings settings = ItemConstructionTool.getSettings(stack);
        if (settings == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        switch (settings.type) {
            case SOLID_FILL: {
                this.handleSolidFill(player, settings);
                break;
            }
            case BOX_FILL: {
                this.handleBoxFill(player, settings);
                break;
            }
            case LAKE_FILL: {
                this.handleLakeFill(player, settings);
                break;
            }
            case LAYER_FILL: {
                this.handleLayerFill(player, settings);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    private void handleSolidFill(EntityPlayer player, ConstructionSettings settings) {
        if (settings.pos1 != null && settings.pos2 != null && settings.block != null) {
            BlockPos min = BlockTools.getMin(settings.pos1, settings.pos2);
            BlockPos max = BlockTools.getMax(settings.pos1, settings.pos2);
            for (int x = min.func_177958_n(); x <= max.func_177958_n(); ++x) {
                for (int z = min.func_177952_p(); z <= max.func_177952_p(); ++z) {
                    for (int y = min.func_177956_o(); y <= max.func_177956_o(); ++y) {
                        player.field_70170_p.func_180501_a(new BlockPos(x, y, z), settings.block.func_176203_a(settings.meta), 3);
                    }
                }
            }
        }
    }

    private void handleBoxFill(EntityPlayer player, ConstructionSettings settings) {
        if (settings.pos1 != null && settings.pos2 != null && settings.block != null) {
            int y;
            int x;
            BlockPos min = BlockTools.getMin(settings.pos1, settings.pos2);
            BlockPos max = BlockTools.getMax(settings.pos1, settings.pos2);
            for (x = min.func_177958_n(); x <= max.func_177958_n(); ++x) {
                for (int z = min.func_177952_p(); z <= max.func_177952_p(); ++z) {
                    player.field_70170_p.func_180501_a(new BlockPos(x, max.func_177956_o(), z), settings.block.func_176203_a(settings.meta), 3);
                    player.field_70170_p.func_180501_a(new BlockPos(x, min.func_177956_o(), z), settings.block.func_176203_a(settings.meta), 3);
                }
            }
            for (x = min.func_177958_n(); x <= max.func_177958_n(); ++x) {
                for (y = min.func_177956_o(); y <= max.func_177956_o(); ++y) {
                    player.field_70170_p.func_180501_a(new BlockPos(x, y, min.func_177952_p()), settings.block.func_176203_a(settings.meta), 3);
                    player.field_70170_p.func_180501_a(new BlockPos(x, y, max.func_177952_p()), settings.block.func_176203_a(settings.meta), 3);
                }
            }
            for (int z = min.func_177952_p(); z <= max.func_177952_p(); ++z) {
                for (y = min.func_177956_o(); y <= max.func_177956_o(); ++y) {
                    player.field_70170_p.func_180501_a(new BlockPos(min.func_177958_n(), y, z), settings.block.func_176203_a(settings.meta), 3);
                    player.field_70170_p.func_180501_a(new BlockPos(max.func_177958_n(), y, z), settings.block.func_176203_a(settings.meta), 3);
                }
            }
        }
    }

    private void handleLakeFill(EntityPlayer player, ConstructionSettings settings) {
        BlockPos pos;
        if (settings.block != null && (pos = BlockTools.getBlockClickedOn(player, player.field_70170_p, player.func_70093_af())) != null) {
            IBlockState state = player.field_70170_p.func_180495_p(pos);
            Block block = state.func_177230_c();
            Set<BlockPos> toFill = new FloodFillPathfinder(player.field_70170_p, pos, block, state, false, true).doFloodFill();
            for (BlockPos p1 : toFill) {
                player.field_70170_p.func_180501_a(new BlockPos(p1.func_177958_n(), p1.func_177956_o(), p1.func_177952_p()), settings.block.func_176203_a(settings.meta), 3);
            }
        }
    }

    private void handleLayerFill(EntityPlayer player, ConstructionSettings settings) {
        BlockPos pos;
        if (settings.block != null && (pos = BlockTools.getBlockClickedOn(player, player.field_70170_p, player.func_70093_af())) != null) {
            IBlockState state = player.field_70170_p.func_180495_p(pos);
            Block block = state.func_177230_c();
            Set<BlockPos> toFill = new FloodFillPathfinder(player.field_70170_p, pos, block, state, false, false).doFloodFill();
            for (BlockPos p1 : toFill) {
                player.field_70170_p.func_180501_a(p1, settings.block.func_176203_a(settings.meta), 3);
            }
        }
    }

    @Override
    public boolean onKeyActionClient(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemAltFunction altFunction) {
        return true;
    }

    @Override
    public void onKeyAction(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemAltFunction altFunction) {
        ConstructionSettings settings = ItemConstructionTool.getSettings(stack);
        if (settings == null) {
            return;
        }
        switch (altFunction) {
            case ALT_FUNCTION_1: {
                settings.type = settings.type.next();
                break;
            }
            case ALT_FUNCTION_2: {
                BlockPos pos = BlockTools.getBlockClickedOn(player, player.field_70170_p, player.func_70093_af());
                if (pos != null) {
                    IBlockState state = player.field_70170_p.func_180495_p(pos);
                    settings.block = state.func_177230_c();
                    settings.meta = state.func_177230_c().func_176201_c(state);
                    ItemConstructionTool.writeConstructionSettings(stack, settings);
                }
                return;
            }
            case ALT_FUNCTION_3: {
                BlockPos pos = BlockTools.getBlockClickedOn(player, player.field_70170_p, player.func_70093_af());
                if (pos != null) {
                    settings.pos1 = pos;
                    ItemConstructionTool.writeConstructionSettings(stack, settings);
                }
                return;
            }
            case ALT_FUNCTION_4: {
                BlockPos pos = BlockTools.getBlockClickedOn(player, player.field_70170_p, player.func_70093_af());
                if (pos != null) {
                    settings.pos2 = pos;
                    ItemConstructionTool.writeConstructionSettings(stack, settings);
                }
                return;
            }
            case ALT_FUNCTION_5: {
                settings.pos1 = null;
                settings.pos2 = null;
            }
        }
        ItemConstructionTool.writeConstructionSettings(stack, settings);
    }

    public static ConstructionSettings getSettings(ItemStack item) {
        if (item.func_77973_b() instanceof ItemConstructionTool) {
            ConstructionSettings settings = new ConstructionSettings();
            if (item.func_77942_o() && item.func_77978_p().func_74764_b("constructionSettings")) {
                settings.readFromNBT(item.func_77978_p().func_74775_l("constructionSettings"));
            }
            return settings;
        }
        return null;
    }

    public static void writeConstructionSettings(ItemStack item, ConstructionSettings settings) {
        if (item.func_77973_b() instanceof ItemConstructionTool) {
            item.func_77983_a("constructionSettings", (NBTBase)settings.writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderBox(EntityPlayer player, EnumHand hand, ItemStack stack, float delta) {
        BlockPos p2;
        ConstructionSettings settings = ItemConstructionTool.getSettings(stack);
        if (settings == null) {
            return;
        }
        BlockPos p3 = BlockTools.getBlockClickedOn(player, player.field_70170_p, player.func_70093_af());
        BlockPos p1 = settings.hasPos1() ? settings.pos1() : p3;
        BlockPos blockPos = p2 = settings.hasPos2() ? settings.pos2() : p3;
        if (p1 != null && p2 != null) {
            IBoxRenderer.Util.renderBoundingBox(player, BlockTools.getMin(p1, p2), BlockTools.getMax(p1, p2), delta);
        }
        if (p3 != null) {
            IBoxRenderer.Util.renderBoundingBox(player, p3, p3, delta, 1.0f, 0.0f, 0.0f);
        }
    }

    public static enum ConstructionType {
        LAKE_FILL,
        LAYER_FILL,
        SOLID_FILL,
        BOX_FILL;


        public ConstructionType next() {
            int ordinal = this.ordinal();
            if (++ordinal >= ConstructionType.values().length) {
                ordinal = 0;
            }
            return ConstructionType.values()[ordinal];
        }

        public static ConstructionType get(int index) {
            if (index >= 0 && index < ConstructionType.values().length) {
                return ConstructionType.values()[index];
            }
            return SOLID_FILL;
        }
    }

    public static final class ConstructionSettings {
        Block block;
        int meta;
        BlockPos pos1;
        BlockPos pos2;
        ConstructionType type = ConstructionType.SOLID_FILL;

        protected void readFromNBT(NBTTagCompound tag) {
            if (tag.func_74764_b("pos1")) {
                this.pos1 = BlockPos.func_177969_a((long)tag.func_74763_f("pos1"));
            }
            if (tag.func_74764_b("pos2")) {
                this.pos2 = BlockPos.func_177969_a((long)tag.func_74763_f("pos2"));
            }
            if (tag.func_74764_b("block")) {
                this.block = Block.func_149684_b((String)tag.func_74779_i("block"));
            }
            if (tag.func_74764_b("meta")) {
                this.meta = tag.func_74762_e("meta");
            }
            if (tag.func_74764_b("type")) {
                this.type = ConstructionType.get(tag.func_74762_e("type"));
            }
        }

        protected NBTTagCompound writeToNBT(NBTTagCompound tag) {
            if (this.block != null) {
                tag.func_74778_a("block", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.block)).toString());
            }
            tag.func_74768_a("meta", this.meta);
            if (this.pos1 != null) {
                tag.func_74772_a("pos1", this.pos1.func_177986_g());
            }
            if (this.pos2 != null) {
                tag.func_74772_a("pos2", this.pos2.func_177986_g());
            }
            tag.func_74768_a("type", this.type.ordinal());
            return tag;
        }

        public boolean hasPos1() {
            return this.pos1 != null;
        }

        public boolean hasPos2() {
            return this.pos2 != null;
        }

        public BlockPos pos1() {
            return this.pos1;
        }

        public BlockPos pos2() {
            return this.pos2;
        }
    }
}

