/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.item;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.item.ItemBlockBase;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.tile.TileColored;
import org.apache.commons.lang3.StringUtils;

public class ItemBlockColored
extends ItemBlockBase {
    private static final String DYE_COLOR_TAG = "dyeColor";
    private static final int WHITE = 0xF9FFFE;
    private static final String COLOR_TAG = "color";
    private static final String CUSTOM_DATA_TAG = "customData";
    private final Set<NBTTagCompound> customItemTags = new HashSet<NBTTagCompound>();

    public ItemBlockColored(Block block) {
        super(block);
    }

    @SideOnly(value=Side.CLIENT)
    public int getColor(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag.func_74764_b(COLOR_TAG)) {
                return tag.func_74762_e(COLOR_TAG);
            }
            Optional<EnumDyeColor> dyeColor = this.getDyeColor(stack);
            if (dyeColor.isPresent()) {
                return dyeColor.get().func_193350_e();
            }
        }
        return 0xF9FFFE;
    }

    public void addCustomItemTag(NBTTagCompound tag) {
        this.customItemTags.add(tag);
    }

    private Optional<EnumDyeColor> getDyeColor(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(DYE_COLOR_TAG)) {
            return Optional.of(EnumDyeColor.func_176766_a((int)stack.func_77978_p().func_74762_e(DYE_COLOR_TAG)));
        }
        return Optional.empty();
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (int dyeDamage = 0; dyeDamage < 16; ++dyeDamage) {
                ItemStack item = new ItemStack((Item)this, 1);
                item.func_77983_a(DYE_COLOR_TAG, (NBTBase)new NBTTagInt(dyeDamage));
                items.add((Object)item);
            }
            for (NBTTagCompound tag : this.customItemTags) {
                ItemStack item = new ItemStack((Item)this, 1);
                item.func_77982_d(tag);
                items.add((Object)item);
            }
        }
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        boolean result = super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);
        if (world.func_180495_p(pos).func_177230_c() == this.field_150939_a) {
            WorldTools.getTile((IBlockAccess)world, pos, TileColored.class).ifPresent(t -> t.setFromStack(stack));
        }
        return result;
    }

    public String func_77653_i(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return this.func_77657_g(stack);
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (tag.func_74764_b(CUSTOM_DATA_TAG)) {
            return I18n.func_74837_a((String)(this.func_77657_g(stack) + "." + tag.func_74779_i("unlocalizedNamePart") + ".name").trim(), (Object[])new Object[]{StringUtils.capitalize((String)tag.func_74779_i(CUSTOM_DATA_TAG))});
        }
        String color = I18n.func_74838_a((String)this.getDyeColor(stack).map(EnumDyeColor::func_176762_d).orElse("white"));
        return I18n.func_74837_a((String)(this.func_77657_g(stack) + ".name").trim(), (Object[])new Object[]{color});
    }
}

